<?php 
use PDO\DB;



class Dish
{
	private $_id = false;
	private $_db = false;

	private $_data=null;
	private $_branch=null;

	function __construct($id=null,$branch_id=null)
	{
		$this->_id=$id;

		$this->_db=new DB;


		$db=$this->_db;


		if ($this->_id) {
			$data = $db->row("SELECT * FROM dishes WHERE id = ? ",[$this->_id]);

			if ($data) {
				$this->_data=$data;
			}
		}

		if ($branch_id) {
			$this->_branch = $db->row("SELECT * FROM branches WHERE id = ? ",[$branch_id]);
		}

		
	}

	public function rprice($price){
		if (is_numeric($price) && $this->_branch) {
			return $price+$price*$this->_branch['price_rate']/100;
		}
		return $price;
	}

	public function price($size=0){
		$index = array_search($size,json_decode($this->_data['sizes']));
		if ($index) {
			return $this->rprice(json_decode($this->_data['prices'])[$index]);
		}

		return $this->rprice(json_decode($this->_data['prices'])[0]);
	}

	public function size($size=0){
		$index = array_search($size,json_decode($this->_data['sizes']));
		if ($index) {
			return json_decode($this->_data['sizes'])[$index];
		}
		
		return json_decode($this->_data['sizes'])[0];
	}

	public function name(){
		return $this->_data['name'];
	}
	public function name_ar(){
		return $this->_data['name_ar'];
	}

	public function tax(){
		$db=$this->_db;
		return $db->row("SELECT * FROM taxes WHERE id = ? ",[$this->_data['tax_id']]);
	}

	public function id(){
		return $this->_data['id'];
	}

	public function description(){
		return $this->_data['description'];
	}

	public function category(){
		$db=$this->_db;
		return $db->row("SELECT * FROM categories WHERE id = ? ",[$this->_data['category_id']]);	
	}

	public function category_id(){
		return $this->_data['category_id'];	
	}



	public function sizes(){
		return json_decode($this->_data['sizes'])	;
	}


	public function addons(){
		return json_decode($this->_data['addons'])	;
	}

	public function img(){
		return file_get($this->_data['file']);
	}

	public function discount(){

		// return $this->_data['discount'];
	}

	public function discountable(){
		return $this->_data['discount']==1;
	}

	public function max_discount(){
		return $this->_data['max_discount'];
	}

	public function size_and_price(){
		$sizes=[];
		$sizes1 = json_decode($this->_data['sizes']);
		$price1 = json_decode($this->_data['prices']);
		for ($i=0; $i < count($sizes1); $i++) { 
			$sizes[]=[
				'size'  =>$sizes1[$i],
				'price' =>$this->rprice($price1[$i]),
			];
		}

		return $sizes;

	}

	public function addon_and_price(){
		$addons=[];

		if (is_json($this->_data['addons'])) {
			$addons1 = json_decode($this->_data['addons']);
			$price1 = json_decode($this->_data['aprices']);
			
			for ($i=0; $i < count($addons1); $i++) { 
				$addons[]=[
					'addon'  =>$addons1[$i],
					'price' =>$this->rprice($price1[$i]),
				];
			}
		}
		

		return $addons;
	}

	public function ingredients(){
		return json_decode($this->_data['ingredients'],true);
	}


	public function validate_addons($addons=[]){
		// var_dump($this->addon_and_price());
		for ($i=0; $i < count($addons); $i++) { 
			
			if (in_array($addons[$i], $this->addon_and_price())) {
				
			}else{
				unset($addons[$i]);
			}
		}
		return $addons;
	}






}