<?php 
namespace Classes;
use PDO\DB as Database;
use \Gumlet\ImageResize;

/**
 * 
 */
class File
{
	
	public $path;
	public $id;
	public $error;
	public $file;

	public $status;
	public $message;
	public $target;
	public $resize_status;




	public  function save($file,$public=0){

		$db= new Database;

		$save_to = conf("App.upload_path");
		$errors=[];
		$error=false;
		if (
	        !isset($file['error']) ||
	        is_array($file['error'])
	    ) {
	        $error = true;$errors[]=('Invalid parameters.');
	    }

	    $filepath="";


	    switch ($file['error']) {
	        case UPLOAD_ERR_OK:
	            break;
	        case UPLOAD_ERR_NO_FILE:
	            $error = true;$errors[]=tr('No file sent.');
	        case UPLOAD_ERR_INI_SIZE:
	        case UPLOAD_ERR_FORM_SIZE:
	            $error = true;$errors[]=tr('Exceeded filesize limit.');
	        default:
	            $error = true;$errors[]=tr('Unknown errors.');
	    }


	    $extentions = conf('upload.ext');
	    $temp       = explode(".", $file["name"]);
	    $old_file_name=$file["name"];
	    if(!in_array(strtolower(end($temp)) , $extentions)){
	        $error = true;$errors[]=(tr('Unsupported file format').' ['.end($temp).'].');
	    }

	    if($file['size'] > conf('upload.max_size')) {
	        $error = true;$errors[]=(tr('File size').' > ' . (conf('upload.max_size') / 1000000) . "MB.");
	    }

	    $file_id=0;
	    $rand=rand(1, 1000000).round(microtime(true)) ;
	    $file_name = $rand . '.' . end($temp);
	    $target =  $save_to.basename($file_name);
	    if (!move_uploaded_file($file['tmp_name'], $target)) {
	        $error = true;$errors[]=tr('Failed to move uploaded file.');
	    }else{
	        $db->query("INSERT INTO uploads(file, file_name, public) VALUES(?,?,?)",[$file_name,$old_file_name,$public]);

	        $file_id = $db->lastInsertId();
	    }
	    
	    
		$this->status  =!$error;
		$this->message =$errors;
		$this->file    =$file_name;
		$this->id      =$file_id;
		$this->target      =$target;

	    return $this;
	}


	public function resize($size=[640,640]){

		$this->resize_status=false;

		if (!$this->is_image()) {

			return $this;
		}

		$db= new Database;
		$save_to = conf("App.upload_path");

		if ($this->status && count($size)==2) {
			$image = new ImageResize($this->target);
        	$image->resizeToBestFit($size[0], $size[1]);
        	$image->save($save_to . basename($this->file));
        	$this->resize_status=true;
        	return $this;
		}

		return $this;
	    
	}

	public  function resized(){
		
		return $this->resize_status;
	}

	public  function resizeToBestFit(){

	}

	public  function saved(){
		
		return (bool)$this->status;
	}

	public  function errors(){
		return $this->message;
	}


	public function is_image(){
		$temp       = explode(".", $this->target);

		$ext = end($temp);

		if (in_array(strtolower($ext), ["png","jpg","jpeg"])) {
			return true;
		}
		return false;
	}

	public function remove(){

	}
}
