<?php 
namespace Classes;


use Classes\Display;
use Classes\Hash;
use Classes\Validator;
use Classes\Request;
use Classes\Token;
use Classes\Cookie;
use Classes\Emailer;
use ReCaptcha\ReCaptcha;
use Classes\Redirect;
use Carbon\Carbon;
use PDO\DB AS Database;
use Illuminate\Database\Capsule\Manager as DB;


class User
{
	public static  $ip        = '';
	public static  $id        = 0;
	private	static $is_signed = false;
	private	static $_usersTable = "users";
	private	static $_rememberTable = "user_remember";



	function __construct()
	{
		self::$ip = getenv('HTTP_CLIENT_IP')?:
					getenv('HTTP_X_FORWARDED_FOR')?:
					getenv('HTTP_X_FORWARDED')?:
					getenv('HTTP_FORWARDED_FOR')?:
					getenv('HTTP_FORWARDED')?:
					getenv('REMOTE_ADDR');

		$r= new Request();
		if ($r->input("logout")) {
			$this->logout();
		}
		
	

		if (isset($_POST['signin'])) {
			
			$this->login(new Request);
		}

		
		if (!self::auth()) {
			$this->loginWithRemember();
		}


	}




	private function logout() {
		if(isset($_SESSION)){
            $_SESSION = array();
			session_regenerate_id();

			if (Cookie::get(conf("auth.remember"))) {
				$remember = explode('___', Cookie::get(conf("auth.remember")));

		    	if (count($remember)==2) {
		    		
		    		$remember_id    =$remember[0];
					$remember_token =$remember[1];

					DB::update("UPDATE ".self::$_rememberTable." SET status = 'Deleted' WHERE remember_id=?",[$remember_id]);
		    	}

		    	Cookie::unset(conf("auth.remember"));
			}

		}
  	
        Redirect::to(conf('App.url') . '/signin.php');		
    }

	private function login(Request $rq) { // Login with the form content
		$v  = new Validator;
		
    	$v->validate([
			tr('Username')=> [$rq->input('username'),'required'],
			tr('Password')=> [$rq->input('password'),'required'],
		]);

		if (conf("App.active_recaptcha") && $v->passes()) { // validate recaptcha

			$v->validate([
				tr("recaptcha")      => [$rq->input('g-recaptcha-response'),"required"]
			]);

			if ($v->passes()) {

				$recaptcha = new ReCaptcha(conf("App.recaptcha_secret"));
				$resp = $recaptcha->setExpectedHostname($_SERVER['SERVER_NAME'])
                      ->verify($rq->input('g-recaptcha-response'), $_SERVER['REMOTE_ADDR']);
                $recaptcha_status = $resp->isSuccess();

                if (!$recaptcha_status) {
                	Display::error(tr("Invalid recaptcha."));
                }
			}

		}else{
			$recaptcha_status=true;
		}

    	Display::error($v->errors()->all(),"error");


	

		if ($v->passes() && $recaptcha_status) {

			$user = DB::table(self::$_usersTable)->where(function ($query) use ($rq) {
			    $query->where('phone', (int)$rq->input('username'))
			          ->orWhere('email', $rq->input('username'))
			          ->orWhere('log_name', $rq->input('username'));
			})->where('deleted_01', '0')->first();

			if ($user) {

				$otp = DB::table("login_otp")->where("phone",(int)$rq->input('username'))->where("created_at",">",Carbon::now()->subDay())->orderBy('id', 'desc')->first(['otp']);

				if (Hash::password_check($rq->input('password'),$user->password) ||(isset($otp->otp)?$otp->otp==$rq->input('password'):false)) { // vlaidate passowrd

					DB::table("login_otp")->where("phone",(int)$rq->input('username'))->delete();
	
	                $_SESSION[conf('auth.session')]=$user->id;
	                DB::insert("INSERT INTO user_session(session_id,ip) VALUES(?,?)",[session_id(),self::$ip]);
	                self::$id=$user->id;


	 				if ($rq->input("remember_me")) { // remember me

	 					$remember_token=Token::generateString(120);
	 					$remember_id=Token::generateString(120);

	 					if (Cookie::get(conf("auth.remember"))) {
	 						Cookie::unset(conf("auth.remember"));
	 						
	 					}

	 					DB::table(self::$_rememberTable)->insert(
	 						[
	 							"user_id"=>$user->id,
	 							"remember_token"=>Hash::password($remember_token),
	 							"remember_id"=>$remember_id,
	 							"ip"=>self::$ip,
	 						]
	 					); 

	 					Cookie::set(
							conf("auth.remember"), 
							$remember_id."___".$remember_token, 
							conf("auth.remember_days")
						);

	 				}

	 				Redirect::to(conf("App.url"));
	 				
	                return true;          
	                
	            } else {
	                Display::add_error(tr("Wrong user name or password."));
	                return false;  
	            }  
			}else {
	                Display::add_error(tr("Wrong user name or password."));
	                return false;  
	        }  
    	}
    
	}


	private function loginWithRemember(){

			if (Cookie::get(conf("auth.remember"))==null) {
				return false;
			}

			$remember = explode('___', Cookie::get(conf("auth.remember")));

	    	if (count($remember)!=2) {
	    		Cookie::unset(conf("auth.remember"));
	    		return false;
	    	}

			$remember_id    =$remember[0];
			$remember_token =$remember[1];

			$remember_row = DB::table("user_remember");
			$remember_row = $remember_row->where("remember_id",$remember_id);
			$remember_row = $remember_row->where("status",'Active');

			if (conf("auth.validate_ip")) {
				$remember_row = $remember_row->where("ip",self::$ip);
			}

			$remember_row = $remember_row->first();
		
	    	if (!$remember_row) {
	    		return false;
	    	}

			$user = DB::table(self::$_usersTable)->where("deleted_01",0)->where("id",$remember_row->user_id)->first();

			
			if (!$user) {
				Cookie::unset(conf("auth.remember"));
	    		return false;
	    	}

	    	if (Hash::password_check($remember_token,$remember_row->remember_token)) {

	         	
	            $_SESSION[conf('auth.session')]=$user->id; 
	            DB::insert("INSERT INTO user_session(session_id,ip) VALUES(?,?)",[session_id(),self::$ip]);
	            self::$id=$user->id;

	            //  $_SESSION[conf('auth.session')]=$user->id; 
	            // DB::insert("INSERT INTO user_session(session_id,ip) VALUES(?,?)",[session_id(),self::$ip]);
	            // self::$id=$user->id;

				// DB::table("users_signs")->insert(["user_id"=>$user->id,"ip"=>self::$ip]); 

				

				

	    	}else{
	    		// DB::update("UPDATE ".self::$_rememberTable." SET status='Deleted' WHERE user_id = ?",[$user->id]);
	    		Cookie::unset(conf("auth.remember"));
	    		return false;
	    	}
	    	
	    }


	public static function auth(){
		if (isset($_SESSION[conf('auth.session')]) && $_SESSION[conf('auth.session')]>=1) {

			$session = DB::table('user_session')->where('session_id',session_id());
			if (conf("auth.validate_ip")) {
				$session = $session->where("ip",self::$ip);
			}
			$session = $session->first();

			if ($session) {
				$id = $_SESSION[conf('auth.session')]; 
				$user =  DB::table(self::$_usersTable)->where("id",$id)->where('deleted_01',0)->first();
				if ($user) {


					if ($user->main == 0 ) {
						$user->main = $user->id;
					}

					return $user;
				}
			}


		}
		return false;
	}


	public static function get($id=0){
		if ($id==0) {
			DB::table("users")->where("id",auth()->id)->first();
		}
		return DB::table("users")->where("id",$id)->first();
	}

	public function authorize($role){
		if (!can($role)) {
			$html='<h1>!!!! '.tr("You are unauthorized to make this action.").' !!!!</h1>';
			$html.='<a href="'.conf("App.url").'">'.tr("Back to home page.").'</a>';
			die($html);
		}
	}

	public function can($role){

		if (strlen($role)==0) {
			return true;
		}

		$roles = explode("|", $role);
		$db = new Database;
		$roles_list = $db->column("SELECT roles FROM roles WHERE id = ?",[auth()->role_id]);

		foreach ($roles as $key => $value) {
			if (in_array($value, json_decode($roles_list[0]))) {
				return true;
			}
		}
	
		return false;
	}



	public static function ip(){
		return self::$ip;
	}

	
}