<?php 
 class Phonetics
 {
		public function EnglishToArabic($source)
		{
			$result="";
			mb_internal_encoding("UTF-8");
			// lowercase it all to start with
			//$source = strtolower($source);
			// start by looking for the 8 letters that have an approximate equivalent in arabic
			// these are B,F,K,L,M,N,R and Z
				// hack to pick out i 
			if(strlen($source) == 1)
			{
				if($source=='i')
				{
					$result.="آ";
				}
			}
			// check for arabic chars in
			// remove all the vowels unless they're doubled up or u or ie
			$result.=" ";
			for ($i = 0; $i < strlen($source); $i++) 
			{
				$char = substr($source, $i, 1);
				// check for arabic characters in the string and just output them if they exist
				if(ord(substr($source, 0, 1))==216 || ord(substr($source, 0, 1))==217)
				{	
					$result.=substr($source, $i, 2);
					$i++;
					continue;
				}
				$char = strtolower($char);
				switch($char)
				{
					case 'a':
						$result.='ا'; // alif
					break;
					case 'b':
						$result.='ب'; // bah
					break;
					case 'c':
						$result.='ك'; // kah
					break;
					case 'd':
						$result.='د'; // dal
					break;
					case 'e':
						$result.='ي'; // yeh
					break;
					case 'f':
						$result.='ف'; // feh
					break;
					case 'g':
						$result.='غ'; // ghaim
					break;
					case 'h':
						$result.='ه'; // heh
					break;
					case 'i':
						$result.='ي'; // yeh
					break;
					case 'j':
						$result.='ج'; // jeem
					break;
					case 'k':
						$result.='ك'; // kaf
					break;
					case 'l':
						$result.='ل'; // lam
					break;
					case 'm':
						$result.='م'; // meem
					break;
					case 'n':
						$result.='ن'; // noon
					break;
					case 'o':
						$result.='و'; // waw
					break;
					case 'p':
						$result.='ب'; // beh
					break;
					case 'q':
						$result.='ك'; // kah
					break;
					case 'r':
						$result.='ر'; // reh
					break;
					case 's':
						$result.='س'; // seen
					break;
					case 't':
						$result.='ت'; // teh
					break;
					case 'u':
						$result.='و'; // waw
					break;
					case 'v':
						$result.='ڤ'; // veh
					break;
					case 'w':
						$result.='و'; // waw
					break;
					case 'x':
						$result.='كس'; // kaf and seen
					break;
					case 'y':
						$result.='ي'; // yeh
					break;
					case 'z':
						$result.='ز'; // zain
					break;
					default:
						$result.=$char;						
					break;
				}
			}
			return $result;
		}
		/*
		 * we'll use the ALA-LC Romanization Tables for this
		 * http://www.al-bab.com/arab/language/roman1.htm
		 */
 		public function ArabicToEnglish($source)
		{
			$result="";
			mb_internal_encoding("UTF-8");
			$result.=" ";
			for ($i = 0; $i < strlen($source); $i++) 
			{
				$byte1 = ord(substr($source, $i, 1));
				$byte2 = ord(substr($source, $i+1, 1));
			// hack to pick out wa (and), aw (or)
			if(strlen($source) == 2)
			{
				if($byte1==217 && $byte2==136)
				{
					$result.="wa";
				}
				if($byte1==216 && $byte2==163)
				{
					$result.="aw";
				}
			}
				switch($byte1)
				{
					case 216:
						switch($byte2)
						{
							case 155:
								$result.=";";// arabic semicolon ؛
							break;
							case 159:
								$result.="?";// ؟ arabic question mark
							break;
							case 161:
								$result.="a";// ء hamza
							break;
							case 162:
								$result.="AA";// آ Alif with madda
							break;
							case 163:
								$result.="a";// أ Alif with hamza
							break;
							case 164:
								$result.="ou";//ؤ waw with hamza
							break;
							case 165:
								$result.="i";//إ alif with hamza below
							break;
							case 166:
								$result.="i";// ئ yeh with hamza above
							break;							
							case 167:
								$result.="a";// alifا
							break;
							case 168:
								$result.="b";//  ب bah
							break;
									case 169:
										$result.="a";//  ة teh marbuta (fastened teh)
									break;
							case 170:
								$result.="t";//  ت teh
							break;
							case 171:
								$result.="th";//  ث theh
							break;
							case 172:
								$result.="j";//  ج jeem
							break;
							case 173:
								$result.="H";//  ح hah
							break;
							case 174:
								$result.="kh";// خ khah
							break;
							case 175:
								$result.="d";// د dal
							break;
							case 176:
								$result.="Th";// ذ thal
							break;
							case 177:
								$result.="r";// ر reh
							break;
							case 178:
								$result.="z";// ز zain
							break;
							case 179:
								$result.="s";// س seen
							break;
							case 180:
								$result.="sh";// ش sheen
							break;
							case 181:
								$result.="S";// sad ص
							break;
							case 182:
								$result.="dh";// ض dad
							break;
							case 183:
								$result.="T";// ط tah
							break;
							case 184:
								$result.="TH";// ظ zah
							break;
							case 185:
								$result.="A";// ع ain
							break;
							case 186:
								$result.="gh";// غ ghain
							break;
							case 187:
								$result.="gh";// غ ghain
							break;
						}
					break;
					case 217:
						switch($byte2)
						{
							case 128:
								$result.="";// ـ tatwheel
							break;
							case 129:
								$result.="f";// ف Feh
							break;
							case 130:
								$result.="q";// ق qaf
							break;
							case 131:
								$result.="k";// ك kaf
							break;							
							case 132:
								$result.="l";//  Lam ل
							break;
							case 133:
								$result.="m";// م meem
							break;
							case 134:
								$result.="n";// ن noon
							break;	
							case 135:
								$result.="h";// ه heh
							break;	
							case 136:
								$result.="o";// و waw
							break;	
							case 137:
								$result.="a";// ى alef maksure
							break;
							case 138:
								$result.="i";// ي yeh
							break;
							// numbers
							case 160:
								$result.="0";// ٠
							break;
							case 161:
								$result.="1";// ١
							break;
							case 162:
								$result.="2";// ٢
							break;
							case 163:
								$result.="3";// ٣
							break;
							case 164:
								$result.="4";// ٤
							break;
							case 165:
								$result.="5";// ٥
							break;
							case 166:
								$result.="6";// ٦
							break;
							case 167:
								$result.="7";// ٧
							break;
							case 168:
								$result.="8";// ٨
							break;	
							case 169:
								$result.="9";// ٩
							break;	
						}
					break;
					default: // if no characters match assume english and just output
						$result.=substr($source, $i, 1);
						// this was a single byte char so take one off the loop
						$i=$i-1;
					break;
				}
				$i++;
				continue;
			}
			return $result;
		}
		public function ArToEn($string)
		{
			$result="";
			$words = explode(" ",$string);
			foreach($words as $word)
			{
				$result.=$this->ArabicToEnglish($word);
			}
			return $result;
		}
		public function EnToAr($string)
		{
			$result="";
			$words = explode(" ",$string);
			foreach($words as $word)
			{
				$result.=$this->EnglishToArabic($word);
			}
			return $result;
		}
 }