<?php
namespace Classes;
use Violin\Violin;
use Illuminate\Database\Capsule\Manager as DB;
use PDO\DB as Database;
class Validator extends Violin
{
	

	function __construct()
	{

		$this->addRuleMessage('unique_logname', tr('That log name is taken.'));
		$this->addRuleMessage('unique_email', tr('That email is taken.'));
		$this->addRuleMessage('unique_phone', tr('That phone is taken.'));

		$this->addRuleMessage('in_table', tr('Invalid input.'));
		$this->addRuleMessage('unique_table', tr('This record already exist.'));
		$this->addRuleMessage('query', tr('Invalid input.'));
	}



	public function unique($table,$columns=[],$valus=[]){
		$table = filter_var ( $table, FILTER_SANITIZE_STRING);
		$check_table=DB::select("SHOW tables like '$table'");

		if (count($check_table)<1) {
			return false;
		}
		
		$query = " SELECT  count(*) as count FROM " . $table . ' WHERE 1 AND  ';

		$identfy=[];
		for ($i=0; $i < count($columns) && $i < count($valus); $i++) { 
			$identfy[]='' . $columns[$i] . '=?';
		}

		$query .= implode(' AND ', $identfy);

		$unique=DB::select($query,$valus);
	
		return !(bool) $unique[0]->count;
	}

	public function unique2($table,$columns,$valus,$exept=null,$nullable=false){

		if ($nullable && ($valus==null || strlen($valus)==0)) {
			return true;
		}
		
		$has_deleted = DB::select("SHOW COLUMNS FROM ".$table." LIKE 'deleted_01' ");
		if (count($has_deleted)<1) {
			$has_deleted = false;
		}else{
			$has_deleted=true;
		}


		$identfy=[];
		$query = " SELECT  count(*) as count FROM " . $table . ' WHERE '.$columns.' = ? ';
		array_push($identfy, $valus);
		if ($exept!=null && strlen($exept)>0) {
			$query.= " AND id != ?";
			array_push($identfy, $exept);
		}

		if ($has_deleted) {
			$query.=" AND deleted_01 = 0 ";
		}

		$unique=DB::select($query,$identfy);
		
		return !(bool) $unique[0]->count;
	}



	public function validate_unique_logname($value, $input, $args){
		return $this->unique2("users","log_name",$value,(isset($args[0])?$args[0]:null));
	}

	public function validate_unique_email($value, $input, $args){
		return $this->unique2($args[0],$args[1],$value,(isset($args[2])?$args[2]:null),(isset($args[3])?true:null));
	}

	public function validate_unique_phone($value, $input, $args){
		return $this->unique2($args[0],$args[1],$value,(isset($args[2])?$args[2]:null));
	}

	public function validate_in_table($value, $input, $args){
		$table = filter_var ( $args[0], FILTER_SANITIZE_STRING);
		$check_table=DB::select("SHOW tables like '$table'");

		if (count($check_table)<1) {
			return false;
		}

		return (bool) DB::table($table)->where($args[1],$value)->count();
	}

	public function validate_unique_table($value, $input, $args){
	
	
		return $this->unique2($args[0],$args[1],$value,(isset($args[2])?$args[2]:null));
	}


	public function validate_query($value, $input, $args){

		$db = new Database;
		

		$result = $db->single($args[0],[$value]);
		return (bool)$result;
	}

}