<?php 

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

use Noodlehaus\Config;

require_once __DIR__.'/../../vendor/autoload.php';

session_start();
$mode=file_get_contents(__DIR__ . '/../mode.php');
$conf=Config::load(__DIR__ . '/../config/' . $mode .'.php');


require_once(__DIR__ . '/../functions/conf.function.php');
require_once(__DIR__ . '/../classes/customer.class.php');
require_once(__DIR__ . '/../classes/token.class.php');
require_once(__DIR__ . '/../classes/hash.class.php');
require_once(__DIR__ . '/../functions/amount.function.php');

$tk =new Classes\Token; 

$hash =new Classes\Hash; 
$db = new PDO\DB; 




$queue=$db->query("SELECT * FROM email_q WHERE sent_01=0");

foreach ($queue as $key => $email) {
	$mail = new PHPMailer(true);
	$mail->setFrom('norply@stockmanager.com', $conf->get("App.name"));
	$send_to=json_decode($email['send_to']);

	foreach ($send_to as $key => $rec) {

		$mail->addAddress($key,$rec);
	}
	

	$mail->Subject = $email['title'];


	$mail->isHTML(true);   
	$mail->Body    = $email['template'];


	if (condition) {
		// code...
	}
	/* SMTP parameters. */
	$mail->IsSMTP();
	$mail->Mailer = 'smtp';
	$mail->SMTPAuth = $conf->get("mail.SMTPAuth");
	$mail->Host = $conf->get("mail.Host");
	$mail->Port = $conf->get("mail.Port");
	$mail->SMTPSecure = $conf->get("mail.SMTPSecure");
	$mail->SMTPOptions = array(
	    'ssl' => array(
	        'verify_peer' => false,
	        'verify_peer_name' => false,
	        'allow_self_signed' => true
	    )
	);

	/* SMTP authentication username. */
	$mail->Username = $conf->get("mail.username");

	/* SMTP authentication password. */
	$mail->Password = $conf->get("mail.password");

	/* Set the SMTP port. */


	/* Finally send the mail. */
	$status = $mail->send();


	if ($status) {
		$db->query("UPDATE email_q SET sent_01=1 WHERE id= ?",[$email['id']]);
	}
	$mail=null;
}

