<?php
use PDO\DB;
class Db_Tool_Backup
{
    protected $_backup_dir;

    protected $_compression;

    protected $_extra_config;
    protected $_previous_count = array();
    protected $_backup_files   = array();
    protected $_db_names       = array();

    protected $connectionStatus;



    public function __construct()
    {   
       

    }
    


    public function backup()
    {
        $now = new DateTime('now', new DateTimeZone('UTC'));
        $suffix = $now->format('Y-m-d-H-i-s');

        if ( ! empty(conf("db.database")))
        {
           
            $this->_single_backup(conf("db.database"), $suffix);
            
        }
    }


    protected function _single_backup($db_name, $suffix)
    {
        $suffix.="BB";
        $filename = $db_name.'_'.$suffix.'.sql';
        $filepath = conf("db.backup_dir").'\\'.$db_name.'\\'. $filename ;


        $params = array();

        $params[] = ' -u '.conf("db.username");
        $params[] = '-p'.conf("db.password");
        $params[] = '-h '.conf("db.host");


        $command = conf("db.mysqldump") . implode(' ', $params) . " $db_name> $filepath";
        

        exec($command);
        $db=new DB;
        $db->query("INSERT INTO backup(name) VALUES('$filename')");

    }



    public function cleanup()
    {
        $this->_single_cleanup(conf("db.database"));
    }


    protected function _single_cleanup($db_name)
    {
        $this->_get_backup_files($db_name);

        $delete_files = $this->_get_files_to_delete($db_name);
        if ( ! empty($delete_files))
        {
            foreach ($delete_files as $key => $file)
            {
                $filename = conf("db.backup_dir").'/'.$db_name.'/'.$file;
                $this->_delete($filename);
            }

            return TRUE;
        }

        return FALSE;
    }
    

    protected function _get_files_to_delete($db_name)
    {
        // Only return files that should not be kept
        if ( ! empty($this->_backup_files[$db_name]))
        {
            $ret = array();

            $count = count($this->_backup_files[$db_name]);

            if ($count > conf("db.keep_files"))
            {
                for ($c = conf("db.keep_files"); $c < $count; $c++)
                {
                    if (
                        isset($this->_backup_files[$db_name][$c]) && 
                        $this->_backup_files[$db_name][$c] != '.' && 
                        $this->_backup_files[$db_name][$c] != '..'
                    )
                    {
                        $ret[] = $this->_backup_files[$db_name][$c];
                    }
                }
            }

            return $ret;
        }
        return FALSE;
    }
    
    protected function _get_backup_files($db_name)
    {

        $dir = conf("db.backup_dir").'/'.$db_name;
        if (!file_exists($dir)) {
            mkdir($dir);
        }

        $files = scandir($dir, 1);

        if ( ! empty($files))
        {
            $this->_backup_files[$db_name] = $files;

            return $this->_backup_files[$db_name];
        }
        return FALSe;
    }
    

    protected function _delete($filename)
    {
        if (is_file($filename))
        {
            return unlink($filename);
        }

        return FALSE;
    }
    

    protected function _set_count($db_name, $count)
    {
        $filename = dirname(__FILE__).'/'.$db_name.'_count';

        $file = fopen($filename, 'wb');

        if ($file)
        {
            return fwrite($file, (string) $count);
        }

        return FALSE;
    }
    

    protected function _get_count($db_name)
    {
        $filename = __DIR__.'/'.$db_name.'_count';

        $file = fopen($filename, 'rb');

        if ($file)
        {
            $count = fgets($file, 4096);

            if ( ! is_numeric($count))
            {
                $count = FALSE;
            }

            fclose($file);

            $this->_previous_count[$db_name] = $count;

            return $this->_previous_count[$db_name];
        }
    }
}

// Perform backup
