<?php 


use Noodlehaus\Config;


require_once __DIR__.'/../../vendor/autoload.php';

session_start();

$mode=file_get_contents(__DIR__ . '/../mode.php');
$conf=Config::load(__DIR__ . '/../config/' . $mode .'.php');

require_once(__DIR__ . '/../classes/emailer/emailer.php');
require_once(__DIR__ . '/../functions/conf.function.php');
require_once(__DIR__ . '/../classes/customer.class.php');
require_once(__DIR__ . '/../classes/token.class.php');
require_once(__DIR__ . '/../classes/hash.class.php');
require_once(__DIR__ . '/../functions/amount.function.php');

$tk =new Classes\Token; 

$hash =new Classes\Hash; 
$db = new PDO\DB; 

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

$email=new Emailer;


$email_settings = $db->row("SELECT * FROM email_settings LIMIT 1");

if ($email_settings['send_quantity'] ) {

	$qnty_sent=$db->row("SELECT * FROM email_q WHERE title ='Quantity report ".date('d-m-Y')."' ORDER BY id DESC LIMIT 1");

	if (!$qnty_sent) {
		
			$email->to($db->single("SELECT r_email FROM email_settings LIMIT 1 "));
	        $email->template("products_alert");
	        $email->app_name   = conf("App.name");
	
	        $email->p_alert=$db->query("SELECT p.*, pd.remain FROM products p LEFT JOIN (
		SELECT p_id, SUM(remain) AS remain FROM product_details WHERE deleted_01=0 GROUP BY p_id
	) pd ON p.id = pd.p_id  WHERE p.deleted_01=0 AND pd.remain<= p.alert ");
	        $email->title      = "Quantity report ".date('d-m-Y');
	        $email->send();
		
	}else{
		$start_date = new DateTime(date('Y-m-d H:i:s'));
		$since_start = $start_date->diff(new DateTime($qnty_sent['added_on']));
		if ($since_start->days>=1) {
			$email->to($db->single("SELECT r_email FROM email_settings LIMIT 1 "));
	        $email->template("products_alert");
	        $email->app_name   = conf("App.name");
	
	        $email->p_alert=$db->query("SELECT p.*, pd.remain FROM products p LEFT JOIN (
		SELECT p_id, SUM(remain) AS remain FROM product_details WHERE deleted_01=0 GROUP BY p_id
	) pd ON p.id = pd.p_id  WHERE p.deleted_01=0 AND pd.remain<= p.alert ");
	        $email->title      = "Quantity report ".date('d-m-Y');
	        $email->send();
		}
	}

	

}	


if ($email_settings['send_sales'] ) {


	$send_sales=$db->row("SELECT * FROM email_q WHERE title ='"."Sales report ".date('d-m-Y')."' ORDER BY id DESC LIMIT 1");
	if (!$send_sales) {
		$salesa = $db->query("SELECT * FROM bills WHERE deleted_01=0 AND DATE(created_at)= DATE( STR_TO_DATE('".date('d-m-Y')."', '%d-%m-%Y' ))");
		$sales =[];
		foreach ($salesa as $key => $item) {
			$item['list']=$db->query("SELECT * FROM bill_details WHERE bill_id = ? AND deleted_01=0",[$item['id']]);
			$sales[]=$item;
		
		}
		$email->to($db->single("SELECT r_email FROM email_settings LIMIT 1 "));
        $email->template("sales_report");
        $email->app_name   = conf("App.name");

        $email->sales=$sales;
        $email->title      = "Sales report ".date('d-m-Y');
        $email->send();
		
	}else{
		$start_date = new DateTime(date('Y-m-d H:i:s'));
		$since_start = $start_date->diff(new DateTime($send_sales['added_on']));

		if ($since_start->days>=1) {

			$salesa = $db->query("SELECT * FROM bills WHERE deleted_01=0 AND DATE(created_at)= DATE( STR_TO_DATE('".date('d-m-Y')."', '%d-%m-%Y' ))");
			$sales =[];
			foreach ($salesa as $key => $item) {
				$item['list']=$db->query("SELECT * FROM bill_details WHERE bill_id = ? AND deleted_01=0",[$item['id']]);
				$sales[]=$item;
			
			}
		
			$email->to($db->single("SELECT r_email FROM email_settings LIMIT 1 "));
	        $email->template("sales_report");
	        $email->app_name   = conf("App.name");
	
	        $email->sales=$sales;
	        $email->title      = "Sales report ".date('d-m-Y');
	        $email->send();
		}
	}

}

	
