<?php 
use Noodlehaus\Config;
require_once __DIR__.'/../../vendor/autoload.php';

session_start();
$mode=file_get_contents(__DIR__ . '/../mode.php');
$conf=Config::load(__DIR__ . '/../config/' . $mode .'.php');


require_once(__DIR__ . '/../functions/sms_q.function.php');
require_once(__DIR__ . '/../functions/sms.function.php');
require_once(__DIR__ . '/../functions/conf.function.php');
require_once(__DIR__ . '/../classes/token.class.php');
require_once(__DIR__ . '/../classes/hash.class.php');
require_once(__DIR__ . '/../functions/amount.function.php');

$tk =new Classes\Token; 

$hash =new Classes\Hash; 
$db = new PDO\DB; 



$sms_list = $db->query("SELECT * FROM sms_q WHERE status ='Queue' ");


foreach ($sms_list as $key => $sms) {

	sleep(1);

	$current_status  = $db->single("SELECT status FROM sms_q WHERE id=?",[$sms['id']]);

	if ($current_status !='Queue') {
		$db->query("DELETE FROM cron_jobs WHERE status ='completed' AND name='sms'");
		$db->query("UPDATE cron_jobs SET status ='completed' WHERE name='sms'");
		die();
	}

	$db->query("UPDATE sms_q SET status='Sending' WHERE id = ?",[$sms['id']]);

	$status  = sms($sms['phone'],$sms['sms'],$sms['send_date']);


	if ($status['status']) {
		$db->query("UPDATE sms_q SET status='Success', response=? WHERE id = ?",[$status['code'],$sms['id']]);
	}else{
		if ($status['code']==100 || $status['code']==77 || $status['code']==88 || $status['code']==99) {
			$db->query("UPDATE sms_q SET status='Queue', response=? WHERE id = ?",[$status['code'],$sms['id']]);
		}else{
			$db->query("UPDATE sms_q SET status='Failed', response=? WHERE id = ?",[$status['code'],$sms['id']]);
			
			
		}
	}
}

