<?php 
use Noodlehaus\Config;
require_once __DIR__.'/../../vendor/autoload.php';

session_start();

$mode=file_get_contents(__DIR__ . '/../mode.php');
$conf=Config::load(__DIR__ . '/../config/' . $mode .'.php');


require_once(__DIR__ . '/../functions/sms_q.function.php');
require_once(__DIR__ . '/../functions/sms.function.php');
require_once(__DIR__ . '/../functions/customer_sms.function.php');
require_once(__DIR__ . '/../functions/conf.function.php');
require_once(__DIR__ . '/../classes/customer.class.php');
require_once(__DIR__ . '/../classes/token.class.php');
require_once(__DIR__ . '/../classes/hash.class.php');
require_once(__DIR__ . '/../functions/amount.function.php');

$tk =new Classes\Token; 

$hash =new Classes\Hash; 
$db = new PDO\DB; 




$monthly_debt_sms    =$db->single("SELECT monthly_debt_sms FROM sms_settings LIMIT 1");

if ($monthly_debt_sms) {
	$custoners_list = $db->query("SELECT * FROM customers WHERE deleted_01 = 0 AND removed_01 = 0 AND id NOT IN (SELECT cus_id FROM customer_sms WHERE DATE(added_on) < (CURRENT_DATE() - INTERVAL 1 MONTH ))");

	foreach ($custoners_list as $key => $c) {
		customer_sms($c['id']);
	}
}

