<?php

$updater = new DbUpdate();

// Create stock_order_requests table
$updater->addUpdate('2025.11.29.1', 'CREATE TABLE IF NOT EXISTS stock_order_requests (
    id INT PRIMARY KEY AUTO_INCREMENT,
    branch_id INT NOT NULL,
    status VARCHAR(20) NOT NULL DEFAULT "pending",
    notes TEXT,
    purchase_id INT DEFAULT NULL,
    created_by INT NOT NULL,
    created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    updated_by INT DEFAULT NULL,
    updated_at TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
    deleted_01 INT(1) NOT NULL DEFAULT 0
);');

$updater->applyUpdates('2025.11.29.1');

// Create stock_order_requests_data table
$updater->addUpdate('2025.11.29.2', 'CREATE TABLE IF NOT EXISTS stock_order_requests_data (
    id INT PRIMARY KEY AUTO_INCREMENT,
    request_id INT NOT NULL,
    product_id INT NOT NULL,
    qty FLOAT NOT NULL DEFAULT 0,
    notes TEXT,
    created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    deleted_01 INT(1) NOT NULL DEFAULT 0
);');

$updater->applyUpdates('2025.11.29.2');
