<?php 


use PDO\DB as Database;



function branch($id=null){

	global $info;

	if ($id == null) {
		$branch =new BranchHelpers();
	}

	if ($id != null) {
		$branch =new BranchHelpers($id);
	}

	if (auth()) {
		(strlen($branch->data()->phone)>1)?$info['phone']=$branch->data()->phone:$info['phone'];
		(strlen($branch->data()->zip)>1)?$info['p_code']=$branch->data()->zip:$info['p_code'];
		(strlen($branch->data()->address_en)>1)?$info['address_en']=$branch->data()->address_en:$info['address_en'];
		(strlen($branch->data()->address)>1)?$info['address_ar']=$branch->data()->address:$info['address_ar'];
		(strlen($branch->data()->box)>1)?$info['po_box']=$branch->data()->box:$info['po_box'];
	}

	return $branch;

}


class BranchHelpers
{
	private $_selected;
	private $_id=null;

	function __construct($id = null)
	{
		$db=new Database;

		$this->_id = $id;

		if (isset($_POST['branch_id'])) {
			$cehck = $db->single("SELECT count(*) FROM branches WHERE id = ? ",[$_POST['branch_id']]);
			if (!can("branches") || $cehck!=1) {
				$_POST['branch_id']=auth()->branch_id;
			}
		}

		if (auth()) {
			if (!isset($_SESSION['branch_id']) || !isset($_SESSION['branch_id'])) {
				
				$_SESSION['branch_id']=auth()->branch_id;
				$_SESSION['branch']=auth()->branch_id;

			}else{
				if ($_SESSION['branch_id']!=auth()->branch_id && !can("branches")) {
					
					$_SESSION['branch']=auth()->branch_id;
					$_SESSION['branch_id']=auth()->branch_id;
				}
				
			}

			if (can("branches") && isset($_GET['branch'])) {
				if (is_numeric($_GET['branch']) && $_GET['branch']>0) {
					$cehck = $db->single("SELECT count(*) FROM branches WHERE id = ? ",[$_GET['branch']]);
					if ($cehck==1) {
						$_SESSION['branch']=$_GET['branch'];
						$_SESSION['branch_id']=$_GET['branch'];
					}
				}

				if ( strtolower($_GET['branch'])=="all") {
					$_SESSION['branch']="all";
				}
				
			}

	
			$this->_selected = (object)$db->row("SELECT * FROM branches WHERE id = ? ",[$_SESSION['branch_id']]);
			$_SESSION['branch_id']=$this->_selected->id;
		}
		
	}

	public function id(){
		if ($this->_id==null) {
			return $this->_selected->id;
		}

		return $this->_id;
		
	}

	public function list(){
		$db=new Database;
		if (can("branches")) {
			return (object)$db->query("SELECT *, ".trl("name","name_en")." as name FROM branches WHERE deleted_01=0");
		}

		return (object)$db->query("SELECT *, ".trl("name","name_en")." as name FROM branches WHERE deleted_01=0 and id = ? ",[auth()->branch_id]);
		
	}

	public function name(){
		
		if ($this->_id != null ) {
			$db=new Database;
			return $db->single("SELECT ".trl("name","name_en")." as name FROM branches WHERE id = ? ",[$this->_id]);
		}

		if (can("branches") &&  $_SESSION['branch']=="all" ) {
			return tr("All");
		}


		return $this->_selected->{trl("name","name_en")};
	}


	public function data(){
		return $this->_selected;
	}




	public function query($colomn="branch_id"){
		if (can("branches") && strtolower($_SESSION['branch'])=="all" && $this->_id==null) {
			$sql = " ( 0 ";

			foreach($this->list() as $branch){
				$sql.=" OR ".$colomn."=".$branch['id'];
			}

			$sql.=" ) ";

			return $sql;
		}


		$sql = " (  ";
		$sql.=" ".$colomn."=".$this->id();

		$sql.=" ) ";
	
		return $sql;

	}

	public function query_auth($colomn="branch_id"){
		if (can("branches") ) {
			$sql = " ( 0 ";

			foreach($this->list() as $branch){
				$sql.=" OR ".$colomn."=".$branch['id'];
			}

			$sql.=" ) ";

			return $sql;
		}


		$sql = " (  ";
		$sql.=" ".$colomn."=".$this->id();

		$sql.=" ) ";
	
		return $sql;

	}


}

