<?php


use Illuminate\Database\Eloquent\Model;



class Option extends Model
{
    protected $table = 'options'; // name of the options table
    public $timestamps = false; // if the table doesn't have created_at and updated_at columns

    // The attributes that are mass assignable
    protected $fillable = ['option_name', 'option_value'];
}

function get_option($option_name) {
    $option = Option::where('option_name', $option_name)->first();
    return $option ? $option->option_value : null;
}

function set_option($option_name, $value) {
    $option = Option::firstOrNew(['option_name' => $option_name]);
    $option->option_value = $value;
    $option->save();
}