<?php 
function remove_from_url($sourceURL, $key){

$url = parse_url($sourceURL);

if (!isset($url['query'])) return unparse_url($url);
parse_str($url['query'], $query_data);

if (is_array($key)) {
  for ($i=0; $i < count($key); $i++) { 
    if (isset($query_data[$key[$i]])) {
      unset($query_data[$key[$i]]);
    }
  }
}else{
  if ($key===TRUE) {
    $query_data=[];
  }else{
    if (isset($query_data[$key])) {
      unset($query_data[$key]);
    }
  }
}


    
$url['query'] = http_build_query($query_data);

return unparse_url($url);

}


function unparse_url($parsed_url) { 

  $scheme   = isset($parsed_url['scheme']) ? $parsed_url['scheme'] . '://' : ''; 
  $host     = isset($parsed_url['host']) ? $parsed_url['host'] : ''; 
  $port     = isset($parsed_url['port']) ? ':' . $parsed_url['port'] : ''; 

  $user     = isset($parsed_url['user']) ? $parsed_url['user'] : ''; 
  $pass     = isset($parsed_url['pass']) ? ':' . $parsed_url['pass']  : ''; 
  $pass     = ($user || $pass) ? "$pass@" : ''; 
  $path     = isset($parsed_url['path']) ? $parsed_url['path'] : ''; 
  $query    = (isset($parsed_url['query']) && strlen($parsed_url['query'] )>0) ? '?' . $parsed_url['query'] : ''; 
  $fragment = isset($parsed_url['fragment']) ? '#' . $parsed_url['fragment'] : ''; 

  return "$scheme$user$pass$host$port$path$query$fragment"; 
}


