<?php



class DbUpdate {

    private $pdo;
    private $updates = [];

    public function __construct() {

        try {
            $this->pdo = new PDO("mysql:host=".conf('db.host').";dbname=".conf('db.database'), conf('db.username'), conf('db.password'));
            $this->pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $this->pdo->setAttribute(PDO::MYSQL_ATTR_USE_BUFFERED_QUERY, true);

        } catch (PDOException $e) {
            die("Connection failed: " . $e->getMessage());
        }
     
    }

    // Add an update query with a corresponding version
    public function addUpdate($version, $query) {
        $this->updates[$version] = $query;  
    }

    // Apply updates for a specific version
    public function applyUpdates($version) {
    // Get the current version from the options table
    //
        try {
            $currentVersion = get_option('app_version');
        } catch (Exception $e) {
            $currentVersion = null;
        }
        

        if ($currentVersion==null) {
            $currentVersion = "1";
        }

        // Compare the given version with the current version
        if (version_compare($version, $currentVersion, '>')) {
            if (isset($this->updates[$version])) {
                try {
                    $this->pdo->beginTransaction();
                    $stmt = $this->pdo->prepare($this->updates[$version]);
                    $stmt->execute();
                    $this->pdo->commit();

                    // Set the new application version
                    set_option('app_version', $version);

                    return "Update for version $version applied successfully.";
                } catch (PDOException $e) {
                    // Try to rollback, but DDL statements cause implicit commits so this may fail
                    try {
                        $this->pdo->rollback();
                    } catch (PDOException $rollbackException) {
                        // Ignore rollback failure - transaction was already committed by DDL
                    }
                    return "Error applying update for version $version: " . $e->getMessage();
                }
            } else {
                return "No update found for version $version.";
            }
        } else {
            return "Given version $version is not greater than the current version $currentVersion. Update ignored.";
        }
    }
}