<?php

	header_remove("X-Powered-By");
    use Noodlehaus\Config;
    
  
	date_default_timezone_set('Asia/Muscat');
	ini_set('session.gc_maxlifetime', "500000");
	ini_set("session.cookie_lifetime","500000");
	session_start();

	$mode=file_get_contents(__DIR__ . '/mode.php');


	require_once (__DIR__ . '/../vendor/autoload.php');

	$conf=Config::load(__DIR__. '/config/' . $mode .'.php');

	error_reporting(E_ALL);

	if ($conf->get("display.DEBUG")){
	    ini_set('display_errors', 'On');        
	}
	else{
	    ini_set('display_errors', 'Off');
	}


	require_once(__DIR__ . '/classes/token.class.php');
	require_once(__DIR__ . '/classes/Request.php');
	require_once(__DIR__ . '/classes/MultiLang.class.php');
	require_once(__DIR__ . '/classes/redirect.class.php');
	require_once(__DIR__ . '/classes/display.class.php');
	require_once(__DIR__ . '/classes/hash.class.php');
	
		require_once(__DIR__ . '/classes/emailer/emailer.php');
	
	require_once(__DIR__ . '/classes/validator.class.php');
	
	require_once(__DIR__ . '/classes/Cookie.php');
	require_once(__DIR__ . '/classes/File.php');
	require_once(__DIR__ . '/classes/User.php');
	require_once(__DIR__ . '/classes/Dish.php');



foreach (glob(__DIR__."/helpers/*.php") as $helper)
{
    require_once $helper;
}


	$ml = new MultiLang($use_cookies = true, $untranslated_logging = false);
	$tk          =new Classes\Token; 
	$redirect    =new Classes\Redirect; 

	$db = new PDO\DB(); 

	$now         =date("H:i d-m-Y"); 

	$uri_parts   = explode('?', $_SERVER['REQUEST_URI'], 2);
$this_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
$currentPage =(isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]".$uri_parts[0];
$app_url=conf("App.url");


	use Illuminate\Database\Capsule\Manager as Capsule;

	$capsule = new Capsule;

	$capsule->addConnection([
	    'driver'    => conf('db.driver'),
	    'host'      => conf('db.host'),
	    'database'  => conf('db.database'),
	    'username'  => conf('db.username'),
	    'password'  => conf('db.password'),
	    'charset'   => 'utf8',
	    'collation' => 'utf8_unicode_ci',
	    'prefix'    => '',
	]);

	// Make this Capsule instance available globally via static methods... (optional)
	$capsule->setAsGlobal();

	// Setup the Eloquent ORM... (optional; unless you've used setEventDispatcher())
	$capsule->bootEloquent();



	

	$display     =new Classes\Display; 
	
	

foreach (glob(__DIR__."/dbupdate/*.php") as $update)
{
    require_once $update;
}


	$user = new Classes\User;


	//lang switch
if (isset($_GET['lang']) && !empty($_GET['lang']) && strlen($_GET['lang'])) {
  $ml->setLanguage($_GET['lang']);
  $this_url=remove_from_url($this_url,["lang"]);
}


if (isset($_GET['cur']) && !empty($_GET['cur']) && strlen($_GET['cur'])) {
  // $front->setCurrency($_GET['cur']);
  $this_url=remove_from_url($this_url,["cur"]);
}








	$auth_page=[
			conf('App.url') . '/index.php',
	  	conf('App.url') . '/',
	  	// conf('App.url') . '/resetpassword.php',
	  	conf('App.url') . '/signin.php',
	  	// conf('App.url') . '/registeration.php',
	  	
	];

	$ex_pages=[
	  	
	  	conf('App.url') . '/uploads/',
	  	conf('App.url') . '/uploads/index.php',
	  	conf('App.url') . '/c/',
	  	conf('App.url') . '/c/index.php',
	  	conf('App.url') . '/c/ax/',
	  	conf('App.url') . '/ajax/is_active.php',
	  	conf('App.url') . '/pos/ajax/is_active.php',
	  	str_replace("https", "http", conf('App.url')) . '/pos/ajax/is_active.php',

	];

	if ($user->auth()) {
		 
		if (in_array($currentPage, $auth_page) ) {
			if (isset($_GET['url'])) {
		      $redirect->to($_GET['url']);
		    }
	    
	    	$redirect->to(conf('App.url')."/dashboard.php");
		}

	}else{

		if (!in_array($currentPage, $auth_page) ) {

			if (!in_array($currentPage, $ex_pages)) {
				$redirect->to(conf('App.url') . '/signin.php');
			}
		}
	}


	



$v = new Classes\Validator;
$local  =  ' lang="'. strtolower($ml->lang).'" dir="'.($ml->lang=="AR"?'rtl':'ltr').'"';

$payment_methods = [
	"Cash",
	"Credit card",
	"Cheque",
	"Other",
];



$info = $db->row("SELECT * FROM info");

if (auth() && !is_ajax()) {
  $db->query("INSERT INTO user_activities(user_id, url) VALUES(?,?)",[auth()->id,$this_url]);

  // echo date("Y-m-d",strtotime("today -3 days"));

  $db->query("DELETE FROM user_activities WHERE date(created_at)<?",[date("Y-m-d",strtotime("today -3 days"))]);
}


// if (is_ajax() && isset($_POST['ajax_from'])) {
// die($this_url);
// }


function to_age($birth){
	$date = new DateTime($birth);
	$now = new DateTime();
	$interval = $now->diff($date);
	return $interval->y;
}




require_once __DIR__."/vars.php";