<?php 
header("Access-Control-Allow-Origin: *");

$root="../..";

require_once($root."/php/init.php");

if (!isset($_POST['func'])) {
	echo json_encode([
			"status"  =>false,
			"message" =>["Session timeout."],
			"code"    =>md5( rand(1, 1000000) . round(microtime(true)) ),
		
		]);
	exit();
}


function print_order($code){
	global $db, $root;
	include"../print/print_order.php";
}


$function = isset($_POST['func'])?$_POST['func']:(isset($_GET['func'])?$_GET['func']:'');
switch ($function) {
	case 'get_customer':
		
		$phone = isset($_POST['phone'])?$_POST['phone']:'';
		$name = isset($_POST['name'])?$_POST['name']:'';

		if (strlen($name)<2) {
			$name=$phone;
		}
		
		$customer = $db->row("SELECT * FROM customers WHERE phone =  ?",[$phone]);

		if ($customer) {
			die(json_encode([
				"name"=>$customer['name'],
				"phone"=>$customer['phone'],
				"points"=>$customer['points'],
			],JSON_NUMERIC_CHECK ));
		}

		$db->query("INSERT INTO customers(name,phone) VALUES(?,?)",[$name,$phone]);


		die(json_encode([
			"name"=>$name,
			"phone"=>$phone,
			"points"=>0,
		],JSON_NUMERIC_CHECK ));

	break;
	case 'send_otp':
		
		$phone = isset($_POST['phone'])?$_POST['phone']:'';
		
		$customer = $db->row("SELECT * FROM customers WHERE phone =  ?",[$phone]);

		if (!$customer) {
			$db->query("INSERT INTO customers(name,phone) VALUES(?,?)",[$phone,$phone]);

			$customer = $db->row("SELECT * FROM customers WHERE phone =  ?",[$phone]);
		}

		$otp = rand ( 1000 , 9999 );

		if (strlen($customer['phone'])==8  ) {

			$phone = $customer['phone'];

			$sms = tr("Your OTP: ").$otp;
				
			sms_q($sms,$phone);
		
		}


		die(json_encode([
			"otp_val"=>$otp,
		]));

	break;
	case 'get_product_data':
		

		
		$dish = dish($_POST['id'],branch()->id());

		echo json_encode([
			"id"         => $_POST['id'],
			"name"       => $dish->name(),
			"description"      => $dish->description(),
			"cat_id"     => $dish->category_id(),
			"sizes"      => $dish->size_and_price(),
			"addons"     => $dish->addon_and_price(),
			"category"     => $dish->category(),
		]);

		

	exit();
	break;



	case 'delete_hold':
		$db->query("UPDATE orders SET status ='Canceled' WHERE id = ? AND status = 'Hold'",[$_POST['id']]);
		$db->query("UPDATE payments SET deleted_01=1 WHERE order_id = ?",[$_POST['id']]);
		echo json_encode(
			[
				"status"  =>1, 
				"message" =>"Hold order deleted.",
			]
		);

	break;

	case 'delete_website':
		$db->query("DELETE FROM website_orders WHERE id = ? ",[$_POST['id']]);
		echo json_encode(
			[
				"status"  =>1, 
				"message" =>"Order deleted.",
			]
		);

	break;



	case 'new':
		$check=$db->single("SELECT count(*) FROM orders WHERE code LIKE ? AND status ='Completed'",["%".$_POST['code']."%"]);


		if ($tk->passes() && $check==0) {
			$is_hold = $db->row("SELECT * FROM orders WHERE code LIKE ? AND status = 'Hold'",["%".$_POST['code']."%"]);
			if ($is_hold) {
				$db->query("DELETE FROM order_data WHERE order_id = ? ",[$is_hold['id']]);
			}

			$cart= json_decode($_POST['cart'],true);

			$customer="";

			if ($cart['type']=="In Store") {
				$customer=$cart['table']['name'];
			}elseif($cart['type']=="Delivery"){
				$customer=$cart['customer']['name'];
			}elseif($cart['type']=="Take Away"){
				$customer=$cart['customer']['car'];
			}

			$code             =$cart['code'];
			$price            =$cart['price'];
			$paid             =$cart['amount'];
			$discount         =$cart['discount'];
			$totaldiscount         =$cart['totaldiscount'];

			$tax              =$cart['tax'];
			$status           =$_POST['status'];
			$payment_method   =$cart['payment_method'];
			$type       	  =$cart['type'];
			$customer_phone   =$cart['customer']['phone'];
			$customer_name    =$cart['customer']['name'];
			$customer_address =$cart['customer']['address'];
			$points_used      =$cart['points_used'];
			$car_number       =$cart['customer']['car'];
			$json             =$_POST['cart'];
			$created_by       =auth()->id;
			$note             =$cart['note'];
			$branch_id        =branch()->id();

		

			// for ($i=0; $i < count($cart['list'] ); $i++) { 
			// 	$cart['list'][$i]['price'] = $cart['list'][$i]['price'] + $cart['list'][$i]['price']*$cart['tax']/100;
			// }

			$customer_id = 0;

			if (strlen($cart['customer']['phone'])==8) {
				$customer2 = $db->row("SELECT * FROM customers WHERE phone = ?",[$customer_phone]);

				if (!$customer2) {
					$db->query("INSERT INTO customers(name,phone) VALUES(?,?)",[$cart['customer']['name'],$cart['customer']['phone']]);
					$customer2 = $db->row("SELECT * FROM customers WHERE id = ? ",[$db->lastInsertId()]);
				}

				$customer_id = (int)$customer2['id'];
			}
			
		

			if ($is_hold) {
				$db->query("DELETE FROM order_data WHERE order_id = ? ",[$is_hold['id']]);
				$db->query(
					"UPDATE orders SET
						customer=?,
						code=?,
						price=?,
						discount=?,
						totaldiscount=?,
						tax=?,
						type=?,
						customer_phone=?,
						customer_name=?,
						customer_address=?,
						car_number=?,
						note=?,
						status=?,
						json=?,
						created_by=?,
						branch_id=?,
						customer_id=?
						WHERE id = ?
						
					",
					[
						$customer,
						$code,
						$price,
						$discount,
						$totaldiscount,
						$tax,
						$type,
						$customer_phone,
						$customer_name,
						$customer_address,
						$car_number,
						$note,
						$status,
						json_encode($cart),
						$created_by,
						$branch_id,
						$customer_id,
						$is_hold['id']
					]
				);

				$id = $is_hold['id'];
			}else{

				$delivery_id = 0;

				if ($cart['delivery']!="None") {
					$delivery_row = $db->row("SELECT * FROM delivery WHERE name = ? ",[$cart['delivery']]);

					if ($delivery_row ) {
						$delivery_id = $delivery_row['id'];
					}
				}

				$db->query(
					"INSERT INTO orders( 
						customer,
						code,
						price,
						discount,
						totaldiscount,
						tax,
						type,
						customer_phone,
						customer_name,
						customer_address,
						car_number,
						note,
						status,
						json,
						created_by,
						branch_id,
						delivery_id,
						customer_id
						
					) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)",
					[
						$customer,
						$code,
						$price,
						$discount,
						$totaldiscount,
						$tax,
						$type,
						$customer_phone,
						$customer_name,
						$customer_address,
						$car_number,
						$note,
						$status,
						json_encode($cart),
						$created_by,
						$branch_id,
						$delivery_id,
						$customer_id
					]
				);

				$id=$db->lastInsertId();
			}


			
			
				
				foreach ($cart['list'] as $key => $item) {

					

					$dish=dish($item['id'],branch()->id());
					

					$ingredients = $dish->ingredients();
					
					if (is_array($ingredients) && $status=="Completed") {
						foreach ($ingredients as $key => $cont) {
							if (isset($cont['size'])) {
								if ($item['size'] == $cont['size']) {
									$db->query(
										"UPDATE stock_product_quantity SET quantity =quantity-? WHERE p_id= ? AND branch_id=? ",
										[$cont['qty']*$item['qty'], $cont['p_id'],$branch_id]
									);

									$db->query("INSERT INTO stock_product_logs(p_id,branch_id,qty_change, added_by, type) VALUES (?,?,?,?,?)",
										[$cont['p_id'], $branch_id, "-".($cont['qty']*$item['qty']), auth()->id,$dish->name()."[".$item['size']."] x".$item['qty']]);
								}
							}
						}
					}
					

					$db->query(
						"INSERT INTO order_data(order_id, dish_id, size, price,tax, note, quantity, name,name_ar,discount,branch_id,json) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)",
						[$id, $item['id'], $item['size'], $item['total_price'], $item['tax'], isset($item['note'])?$item['note']:'', $item['qty'] , $item['name'],$dish->name_ar(), $item['totaldiscount'],$branch_id,json_encode($item)]
					);
				
				}

				$points_settings = $db->row("SELECT * FROM points_settings LIMIT 1 ");
				if ( ($paid>0 || $points_used>0) && $status=="Completed") {
					if ($paid>0) {

						if ($paid>($price-$discount)) {
							$paid=$price-$discount;
						}
						$db->query("INSERT INTO payments(order_id, amount, branch_id, method, created_by) VALUES(?,?,?,?,?)",[
							$id,
							$paid,
							$branch_id,
							$payment_method,
							auth()->id
						]);

						if (isset($customer2) && $points_settings['active_01']==1) {
							$db->query("UPDATE customers SET points = points+? WHERE id = ? AND points<?",[
								(int)($paid/$points_settings['point_reword']),
								$customer2['id'],
								$points_settings['max_points']
							]);
						}
					}
					

					

					if ( isset($customer2)) {
						if ($points_used>0 && $customer2['points']>=$points_used) {
							$db->query("INSERT INTO payments(order_id, amount, branch_id, method,points,points_rate, created_by) VALUES(?,?,?,?,?,?,?)",[
								$id,
								$points_settings['point_rate']*$points_used,
								$branch_id,
								"Points",
								$points_used,
								$points_settings['point_rate'],
								auth()->id
							]);

							$db->query("UPDATE customers SET points = points-? WHERE id = ?",[
								$points_used,
								$customer2['id'],
							]);

						}

					}
				}

				if (isset($cart['website'])) {
					$db->query("DELETE FROM website_orders WHERE id = ? ",[$cart['website']]);
				}

				$holds=$db->query("SELECT *,json as cart FROM orders WHERE status = 'Hold' AND branch_id=? AND created_at >= NOW() - INTERVAL 5 HOUR ORDER BY id DESC",[branch()->id()]);

				for ($i=0; $i < count($holds); $i++) { 
					$holds[$i]['cart']=json_decode($holds[$i]['cart'],true);

				}

				echo json_encode([
					"status"    =>true,
					"message"   =>[],
					"holds"   =>$holds,
					"code"      =>md5(microtime(true)),
					"order_id"    =>$id,
					"token"     =>$tk->csrf,
					
				]);
		

			
		}else{
			echo json_encode([
				"status"  =>false,
				"message" =>["Session timeout. Please reload the page and try again."],
				"code"    =>md5(microtime(true)),
				"token"   =>$tk->csrf,
			]);
		}
		
		
	break;


	case 'interval':

		$last_orders = $db->query("SELECT * FROM orders WHERE branch_id =? AND status ='Completed' AND created_at> DATE_SUB(NOW(),INTERVAL 4 HOUR)   ORDER BY id DESC LIMIT 15",[branch()->id()]);

		$lasts=[];
		foreach ($last_orders as $key => $order) {
			$order_data=$db->query("SELECT * FROM order_data WHERE order_id = ? ",[$order['id']]);
			$lasts[]=[
				"order_id" =>$order['id'],
				"customer" =>$order['customer'],
				"price"    =>$order['price'],
				"discount" =>$order['discount'],
				"tax" =>$order['tax'],
	
				"order_data"   =>$order_data,
			];
			

		}

	

		$list = $db->query("SELECT * FROM website_orders WHERE branch_id =? AND status='new' OR status = 'printed' AND  created_at >= NOW() - INTERVAL 1 HOUR ORDER BY id DESC",[branch()->id()]);
		for ($i=0; $i < count($list); $i++) { 
			$list[$i]['cart']=json_decode($list[$i]['cart'],true);
			$list[$i]['cart']['website']=$list[$i]['id'];
			$list[$i]['cart']['price_rate']=0;
			$list[$i]['cart']['points_used']=0;
			$list[$i]['cart']['points_used0']=0;
			$list[$i]['cart']['delivery']="None";
		
			$list[$i]['cart']['customer']['points']=$db->single("SELECT points FROM customers WHERE phone = ? ",[$list[$i]['cart']['customer']['phone']]);
			$otp = rand ( 1000 , 9999 );
			$list[$i]['cart']['customer']['otp']= $otp ;
			$list[$i]['cart']['customer']['otp_val']= $otp ;
			
			

			if ($list[$i]['cart']['type']=="Take Away") {
				$list[$i]['cart']['table']=$db->row("SELECT * FROM tables WHERE   ".branch()->query()."" );
			}else{
				if ($db->row("SELECT * FROM tables WHERE name=? AND  ".branch()->query()."",[$list[$i]['cart']['table']] )) {
					$list[$i]['cart']['table']=$db->row("SELECT * FROM tables WHERE name=? AND  ".branch()->query()."",[$list[$i]['cart']['table']] );
				}else{
					$list[$i]['cart']['table']=$db->row("SELECT * FROM tables WHERE  ".branch()->query()."");
				}
				
			}

		
			
		}


		$holds=$db->query("SELECT *,json as cart FROM orders WHERE status = 'Hold' AND branch_id=? AND created_at >= NOW() - INTERVAL 5 HOUR ORDER BY id DESC",[branch()->id()]);

		for ($i=0; $i < count($holds); $i++) { 
			$holds[$i]['cart']=json_decode($holds[$i]['cart'],true);

		}

		echo json_encode([
			"holds"=>$holds,
			"website"=>$list,
			"last"=>$lasts,
		]);

		die;
	break;

	


	
	default:
		exit();
	break;
}



exit();