<!-- delete Modal -->
<div class="modal" id="delete-modal" tabindex="-1" role="dialog" aria-labelledby="delete-modalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="delete-modalLabel">Are You Sure?</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        Once deleted, you will not be able to recover this order!
      </div>
      <div class="modal-footer p-0">
        <div class="btn-group btn-block m-0">
          <button type="button" class="btn btn-secondary btn-lg" data-dismiss="modal">Cancel</button>
          <button type="button" data-dismiss="modal" class="btn btn-danger btn-lg" @click="cart.list=[]">Ok</button>
        </div>
      </div>
    </div>
  </div>
</div>


<!-- discount Modal -->
<div class="modal" id="discount-Modal" tabindex="-1" role="dialog" aria-labelledby="discount-ModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="discount-ModalLabel">Discount - {{ parseInt((cart.discount / cart.price)*100) }}%</h5> {{cart.price}}
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body p-0">
        <div class="row w-100 mx-0">
        
          <div class="col-sm-3 p-0">
            <button @click="cart.discount+=0.1" style="height: 50px" class="btn btn-info btn-block display-5" >+ 0.10</button>
          </div>
          <div class="col-sm-2 p-0">
            <button @click="cart.discount+=0.05" style="height: 50px" class="btn btn-info btn-block" >+ 0.05</button>
          </div>
          <div class="col-sm-2 p-0">
            <input style="height: 50px"   :value="cart.discount" v-model="cart.discount"   @change="cart.discount==''?cart.discount=0:false" type="text" class="form-control text-center" onclick="$(this).select()">
          </div>
           <div class="col-sm-2 p-0">
            <button @click="cart.discount-=0.05" style="height: 50px" class="btn btn-info btn-block" >- 0.05</button>
          </div>
          <div class="col-sm-3 p-0">
            <button style="height: 50px" @click="cart.discount-=0.1" class="btn btn-info btn-block" >- 0.10</button>
          </div>
        </div>
      
      </div>
      <div class="modal-footer p-0">
        <div class="btn-group btn-block m-0">
          <button type="button" class="btn btn-danger btn-lg" data-dismiss="modal">Close</button>
        </div>
        
      </div>
    </div>
  </div>
</div>

<!-- tax Modal -->
<div class="modal" id="tax-Modal" tabindex="-1" role="dialog" aria-labelledby="tax-ModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="tax-ModalLabel">Tax</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body p-0">
        <div class="row w-100 mx-0">
        
          <div class="col-sm-3 p-0">
            <button @click="cart.tax+=5" style="height: 50px" class="btn btn-info btn-block display-5" >+ 5</button>
          </div>
          <div class="col-sm-2 p-0">
            <button @click="cart.tax+=1" style="height: 50px" class="btn btn-info btn-block" >+ 1</button>
          </div>
          <div class="col-sm-2 p-0">
            <input style="height: 50px" v-model="cart.tax" type="text" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" class="form-control text-center" onclick="$(this).select()">
          </div>
           <div class="col-sm-2 p-0">
            <button @click="cart.tax-=1" style="height: 50px" class="btn btn-info btn-block" >- 1</button>
          </div>
          <div class="col-sm-3 p-0">
            <button style="height: 50px" @click="cart.tax-=5" class="btn btn-info btn-block" >- 5</button>
          </div>
        </div>
      
      </div>
      <div class="modal-footer p-0">
        <div class="btn-group btn-block m-0">
          <button type="button" class="btn btn-danger btn-lg" data-dismiss="modal">Close</button>
        </div>
        
      </div>
    </div>
  </div>
</div>

<!-- rate Modal -->
<div class="modal" id="price_rate-Modal" tabindex="-1" role="dialog" aria-labelledby="tax-ModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="tax-ModalLabel">Price rate</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body p-0">
        <div class="row w-100 mx-0">
        
          <div class="col-sm-3 p-0">
            <button @click="cart.price_rate+=5;pos.getTotalBillPrice()" style="height: 50px" class="btn btn-info btn-block display-5" >+ 5</button>
          </div>
          <div class="col-sm-2 p-0">
            <button @click="cart.price_rate+=1;pos.getTotalBillPrice()" style="height: 50px" class="btn btn-info btn-block" >+ 1</button>
          </div>
          <div class="col-sm-2 p-0">
            <input style="height: 50px" v-model="cart.price_rate" type="text" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');pos.getTotalBillPrice()" class="form-control text-center" onclick="$(this).select()">
          </div>
           <div class="col-sm-2 p-0">
            <button @click="cart.price_rate-=1;pos.getTotalBillPrice()" style="height: 50px" class="btn btn-info btn-block" >- 1</button>
          </div>
          <div class="col-sm-3 p-0">
            <button style="height: 50px" @click="cart.price_rate-=5;pos.getTotalBillPrice()" class="btn btn-info btn-block" >- 5</button>
          </div>
        </div>
      
      </div>
      <div class="modal-footer p-0">
        <div class="btn-group btn-block m-0">
          <button type="button" class="btn btn-danger btn-lg" data-dismiss="modal">Close</button>
        </div>
        
      </div>
    </div>
  </div>
</div>

<!-- table Modal -->
<div class="modal" id="table-ModalLong" tabindex="-1" role="dialog" aria-labelledby="table-ModalLongTitle" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="table-ModalLongTitle">Tables</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="btn-group-vertical  btn-block">
          <button v-for="(table,index) in tables" @click="cart.table=table" data-dismiss="modal" class="btn btn-outline-secondary btn-lg" :class="{'active':table.id==cart.table.id}">
            {{ table.name }}
          </button>
        </div>
      </div>
      <div class="modal-footer p-0">
        <div class="btn-group btn-block m-0">
          <button type="button" class="btn btn-danger btn-lg" data-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
  </div>
</div>


<!-- delivery Modal -->
<div class="modal" id="delivery-ModalLong" tabindex="-1" role="dialog" aria-labelledby="delivery-ModalLongTitle" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="delivery-ModalLongTitle">Delivery</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="btn-group-vertical  btn-block">
          <button  @click="cart.delivery='None';cart.price_rate = 0" data-dismiss="modal" class="btn btn-outline-secondary btn-lg" :class="{'active':'None'==cart.delivery}">
            None 
          </button>
          <button v-for="(delivery,index) in deliveries" @click="cart.delivery=delivery.name;cart.price_rate = delivery.rate" data-dismiss="modal" class="btn btn-outline-secondary btn-lg" :class="{'active':delivery.name==cart.delivery}">
            {{ delivery.name }} [+{{ delivery.rate }}%]
          </button>
        </div>
      </div>
      <div class="modal-footer p-0">
        <div class="btn-group btn-block m-0">
          <button type="button" class="btn btn-danger btn-lg" data-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- ordertype Modal -->
<div class="modal" id="ordertype-ModalLong" tabindex="-1" role="dialog" aria-labelledby="ordertype-ModalLongTitle" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="ordertype-ModalLongTitle">Order Type</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="btn-group-vertical  btn-block">
          <button v-for="(order,index) in order_types" @click="cart.type=order;cart.delivery='None';cart.price_rate = 0" data-dismiss="modal" class="btn btn-outline-secondary btn-lg" :class="{'active':order==cart.type}">
            {{ order }}
          </button>
        </div>
      </div>
      <div class="modal-footer p-0">
        <div class="btn-group btn-block m-0">
          <button type="button" class="btn btn-danger btn-lg" data-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- holded_order Modal -->
<div class="modal" id="holded_order-modal" tabindex="-1" role="dialog" aria-labelledby="holded_order-modalTitle" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="holded_order-modalTitle">In Hold</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">

        <div class="list-group">
          <a href="#" class="list-group-item list-group-item-action " v-for="(hold,index) in holds" >
            <div class="d-flex w-100 justify-content-between">
              <h4 >#{{ hold.id }} {{ hold.customer }} </h4>
            
            </div>
           
            <table class="table table-sm table-borderless table-striped border">
              <tr  v-for="(item,sub_index) in hold.cart.list ">
                <td>{{ item.name }} [{{ item.size }}]
                  <p class="p-0 m-0" v-for="addon in item.selected_addons">
                    <small><i>- {{addon.addon}}</i></small>
                  </p>
                </td>
                <td></td>
                <td>x{{ item.qty }}</td>
                <td>{{ to_price(item.total_price*item.qty) }}</td>
         
              </tr>
               
             
            </table>
            <div class="d-flex">
              <button @click="get_hold(index) " class="btn btn-block btn-outline-dark py-2 mt-0">
                <i class="fas fa-reply"></i>
              </button>
             
              
              <!-- <button @click="hold_to_delete = index "  v-show="hold_to_delete!=index" class="btn btn-block btn-danger py-2 mt-0">
                <i class="far fa-trash-alt"></i>
              </button> -->

               <button @click="delete_hold(index)" v-show="hold_to_delete==index" class="btn btn-block btn-danger py-2 mt-0">
                Confirm delete
              </button>
            </div>
 
          </a>
 
        </div>



      </div>
      <div class="modal-footer p-0">
        <div class="btn-group btn-block m-0">
          <button type="button" class="btn btn-danger btn-lg" data-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
  </div>
</div>


<!-- last_orders Modal -->
<div class="modal" id="last_orders-modal" tabindex="-1" role="dialog" aria-labelledby="holded_order-modalTitle" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="holded_order-modalTitle">Last Orders</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <table class="table table-borderless">
          <tr v-for="(order,index) in last_orders">
           
            <th >{{ order.customer }}</th>
            <td><small><span v-for="(item,sub_index) in order.cart ">{{ item.name }}, </span></small></td>
           
          </tr>
        </table>
        
          
        

      </div>
      <div class="modal-footer p-0">
        <div class="btn-group btn-block m-0">
          <button type="button" class="btn btn-danger btn-lg" data-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
  </div>
</div>


<div class="modal" id="websiteorders-modal" tabindex="-1" role="dialog" aria-labelledby="holded_order-modalTitle" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="holded_order-modalTitle">Website</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <table class="table table-sm table-borderless">
          <template v-for="(order,index) in website_orders" >
          <tr class="bg-light border">
           
            <th >#{{order.id}} - {{ order.cart.customer.name }} {{ order.cart.customer.phone }} <br>
                {{ order.cart.type }} <span v-if="order.cart.type=='In Store'">[{{ order.cart.table.name }}]</span>
                <span v-if="order.cart.type=='Take Away'">[{{ order.cart.customer.car }}]</span>
              <br>
              <small>{{ order.created_at }} </small>
            </th>

            <td v-html="order.cart.note.replace(/(?:\r\n|\r|\n)/g, '<br>')"></td>
       
            
            
          </tr>
          <tr v-for="item in order.cart.list" class="border">
            <td >
              {{item.name}} {{item.size}}
              <small><ul class="my-0">
                <li v-for="addon in item.selected_addons">{{addon.addon}}</li>
              </ul></small>
              <span v-html="item.note"></span>
            </td>
            <td>x{{item.qty}}</td>
          </tr>
          <tr>
            <td colspan="2">
              <div class="d-flex">
              <button @click="cart=order.cart;points_checked=true" class="btn btn-block btn-outline-dark py-2 mt-0">
                <i class="fas fa-reply"></i>
              </button>
             
              
              <button @click="hold_to_delete = index "  v-show="hold_to_delete!=index" class="btn btn-block btn-danger py-2 mt-0">
                <i class="far fa-trash-alt"></i>
              </button>

               <button @click="delete_website(index);hold_to_delete=null" v-show="hold_to_delete==index" class="btn btn-block btn-danger py-2 mt-0">
                Confirm delete
              </button>
            </div>
            </td>
          </tr>
          </template>
        </table>
        
          
        

      </div>
      <div class="modal-footer p-0">
        <div class="btn-group btn-block m-0">
          <button type="button" class="btn btn-danger btn-lg" data-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
  </div>
</div>
