<?php $points = $db->row("SELECT * FROM points_settings LIMIT 1") ?>
<!-- ordertype Modal -->
<div class="modal" id="check-out-modal" tabindex="-1" role="dialog" aria-labelledby="payment-modalLabel" aria-hidden="true" data-backdrop="static" data-keyboard="false" style="overflow-y: scroll;">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="check-out-modalTitle">Checkout</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="col-3 p-1" v-for="btn in cash" >
          <button class="btn btn-secondary btn-block" @click="btn.count++;quickCashVal()">
            {{to_price(btn.val)}} <span class="badge badge-light">{{btn.count}}</span>
          </button>
        </div>

         <div class="col-3 p-1"  >
          <button class="btn btn-danger btn-block" @click=" cash = cash_reset;quickCashVal()">
            Clear cash
          </button>
        </div>
          
   
          
        </div>
        <div class="row mt-3">
          <div class="col" 
          style="height: 50px" 
          @click="(cart.payment_method=='Cash')?cart.amount=to_price(cart.payable-cart.points_used*<?= $points['point_rate'] ?>):'';cart.payment_method='Cash';">
            <h1 class="text-center" title="Cash">
              <i class="fas fa-money-bill-wave fa-sm" :class="{'text-success':cart.payment_method=='Cash'}"></i>
         
            </h1>

          </div>
          <div class="col" style="height: 50px" 
          @click="cart.amount=to_price(cart.payable-cart.points_used*<?= $points['point_rate'] ?>);cart.payment_method='Credit card';">
            <h1 class="text-center" title="Credit card">
              <i class="far fa-credit-card fa-sm" :class="{'text-success':cart.payment_method=='Credit card'}"></i>
            </h1>
          </div>

          <div class="col" style="height: 50px" 
          @click="cart.amount=to_price(cart.payable-cart.points_used*<?= $points['point_rate'] ?>);cart.payment_method='QR';">
            <h1 class="text-center" title="QR">
              <i class="fas fa-qrcode fa-sm" :class="{'text-success':cart.payment_method=='QR'}"></i>
          
            </h1>
          </div>

          <div class="col" style="height: 50px" 
          @click="cart.amount=to_price(cart.payable-cart.points_used*<?= $points['point_rate'] ?>);cart.payment_method='Bank transfer';">
            <h1 class="text-center" title="Bank transfer">

              <i class="fas fa-university fa-sm" :class="{'text-success':cart.payment_method=='Bank transfer'}"></i>
          
            </h1>
          </div>


        </div>

        <?php if ($points['active_01']==1): ?>
          <p class="text-center"><button type="button" @click="show_points=!show_points" class="btn btn-link text-dark"><i class="fas fa-angle-down"></i></button></p>
          <div class="row py-1 bg-light" v-show="show_points">
            
            <div class="col-6">
              <input type="text" class="form-control" placeholder="Customer" v-model="cart.customer.name">
            </div>
            <div class="col-6">
              <input type="text" class="form-control" 
              @change="points_checked=false;cart.customer.points=0;cart.points_used=0;otp_sent=false" 
              placeholder="Phone" 
              v-model="cart.customer.phone">
            </div>

            <div class="col-4 pt-2">
              <input type="text" disabled class="form-control text-center" placeholder="Balance" :value="points_checked?cart.customer.points:'--'">
            </div>

            <div class="col-4 pt-2">
              <input type="text" disabled class="form-control text-center" placeholder="Balance" :value="to_price(cart.customer.points*<?= $points['point_rate'] ?>)">
            </div>

            <div class="col-4 pt-2 text-center">
             <button type="button" @click="get_customer()" class="btn btn-outline-secondary"><i class="fas fa-sync"></i></button>
            </div>

            <div class="col-4 pt-2">
              <input 
              type="number" 
              step="1" 
              min="0" 
              :max="cart.customer.points" 
              v-model="cart.points_used0"
              @change="if(cart.points_used0>cart.customer.points){cart.points_used0=cart.customer.points}"
              class="form-control text-center" placeholder="Points"  >
            </div>

            <div class="col-4 pt-2">
              <input type="text" disabled class="form-control text-center" placeholder="Balance" :value="to_price(cart.points_used0*<?= $points['point_rate'] ?>)">
            </div>

            <div class="col-4 pt-2">
             <input type="text" placeholder="OTP" class="form-control text-center" v-model="cart.customer.otp">
            </div>

            <div class="col-6 pt-2">
             <button 
             @click="send_otp()" 
             :disabled="cart.customer.otp==cart.customer.otp_val||otp_sent||cart.customer.phone.length<8||!points_checked" 
             type="button" 
             class="btn btn-secondary">Send OTP</button>
            </div>
            <div class="col-6 pt-2">
             <button 
             :disabled="cart.customer.otp!=cart.customer.otp_val"
             @click="cart.points_used=cart.points_used0;cart.amount=0"
             type="button" class="btn btn-secondary">Add ({{cart.points_used0}}) points</button>
            </div>

        
          </div>
        <?php endif ?>
        <div class="row mt-3">
          <div class="col-6">
            <label for="">Total Paid  <span v-if="cart.points_used>0"> | Points:{{to_price(cart.points_used*<?= $points['point_rate'] ?>)}}</span></label>
            <input 
            type="number" 
            class="form-control numpad text-center" 
            onclick="$(this).select()" 
            @change="if(cart.amount.length==0){cart.amount=0}"
            v-model="cart.amount"
            >
          </div>
          <div class="col-6">
            <label for="">Change</label>
            <input type="text" class="form-control text-center" disabled="" :value="to_price(parseFloat(cart.points_used*<?= $points['point_rate'] ?>)+(parseFloat(cart.amount)) - cart.payable)">
            
          </div>
        </div>
        <div class="row mt-3">
          <div class="col">
            <textarea cols="30" rows="2" placeholder="Note" class="form-control" v-model="cart.note"></textarea>
          </div>
        </div>

        
        <?php if ($points['active_01']==0): ?>
          <div class="row pt-2">
          <div class="col-6">
              <input type="text" class="form-control" placeholder="Customer" v-model="cart.customer.name">
            </div>
            <div class="col-6">
              <input type="text" class="form-control" placeholder="Phone" v-model="cart.customer.phone">
            </div>
        </div>
        <?php endif ?>

        
        <div v-show="cart.type=='Delivery' || cart.type=='Take Away'">
          <p class="mt-3 pb-0 mb-0">Customer details</p>
          <div class="row border-top mt-1 pt-2">
        
            <div class="col-12 mt-2">
              <input type="text" class="form-control" placeholder="Address"  v-model="cart.customer.address">
            </div>
          </div>
        </div>

        <div v-show="cart.type=='Take Away'">
          <p class="mt-3 pb-0 mb-0">Car No</p>
          <div class="row  mt-1 pt-2">
            <div class="col-12 mt-2">
              <input type="text" class="form-control" placeholder="Car No"  v-model="cart.customer.car">
            </div>
          </div>
        </div>


      </div>

      <div class="modal-footer p-0">
        <div class="btn-group btn-block m-0">
          <button 
          type="button"
          class="btn btn-success btn-lg" 
          :disabled="
          parseFloat((parseFloat(cart.amount)+
          parseFloat(cart.points_used*<?= $points['point_rate'] ?>)))
          <(parseFloat(cart.payable)-0.1)  || cart.amount.length==0  " 
          @click="submit"
          >Submit</button>
          <button type="button" class="btn btn-warning btn-lg"  @click="hold()">Hold</button>
          <button type="button" class="btn btn-danger btn-lg" data-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
  </div>
</div>


<!-- Modal -->
<div class="modal" id="success_modal" tabindex="-1" role="dialog" aria-labelledby="success_modalTitle" aria-hidden="true" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-body">
        <div class="row justify-content-center">
          <div class="col-4" style="height: 15vh" >
            <button title="New customer" class="btn btn-block btn-success h-100 text-center"  data-dismiss="modal">
                <i class="fas fa-user-plus fa-2x"></i>
                <br>
                ( N )
            </button>
          </div>
          <div class="col-4" style="height: 15vh" v-show="!holded">
            <button title="Print" class="btn btn-block btn-success h-100 text-center" @click="print">
                
                <i class="fas fa-receipt fa-2x"></i>
                <br>
                ( R )
            </button>
          </div>

          <div class="col-4" style="height: 15vh" >
            <button title="Print" class="btn btn-block btn-success h-100 text-center" @click="printorder">
                <i class="fas fa-clipboard-list fa-2x"></i>
        
                <br>
                ( O )
            </button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>