<?php
header("Access-Control-Allow-Origin: *");
	$root="..";
	require("../php/init.php");
	$page=['title'=>$conf->get("App.name")];

  $categories = $db->query("SELECT * FROM categories WHERE deleted_01=0 AND id in(SELECT category_id FROM dishes WHERE deleted_01=0) ORDER BY name ");
  $order_type=["In Store", "Take Away", "Delivery"];

function get_os() {
    $u_agent = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '';
    $operating_system = 'Unknown Operating System';

    //Get the operating_system name
  if($u_agent) {
    if (preg_match('/linux/i', $u_agent)) {
      $operating_system = 'Android';
    } elseif (preg_match('/macintosh|mac os x|mac_powerpc/i', $u_agent)) {
      $operating_system = 'Mac';
    } elseif (preg_match('/windows|win32|win98|win95|win16/i', $u_agent)) {
      $operating_system = 'Windows';
    } elseif (preg_match('/ubuntu/i', $u_agent)) {
      $operating_system = 'Ubuntu';
    } elseif (preg_match('/iphone/i', $u_agent)) {
      $operating_system = 'IPhone';
    } elseif (preg_match('/ipod/i', $u_agent)) {
      $operating_system = 'IPod';
    } elseif (preg_match('/ipad/i', $u_agent)) {
      $operating_system = 'IPad';
    } elseif (preg_match('/android/i', $u_agent)) {
      $operating_system = 'Android';
    } elseif (preg_match('/blackberry/i', $u_agent)) {
      $operating_system = 'Blackberry';
    } elseif (preg_match('/webos/i', $u_agent)) {
      $operating_system = 'Mobile';
    }
  } else {
    $operating_system = php_uname('s');
  }
    
    return $operating_system;
}
  function isSecure() {
    return
      (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off')
      || $_SERVER['SERVER_PORT'] == 443;
  }

  if (isSecure() && 1 ) {
    $redirect->to(str_replace("https", "http", $this_url));
  }
  



?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta name="<?= $conf->get('csrf.session') ?>" content="<?= $tk->csrf ?>">
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <title><?= (isset($page['title']))?$page['title']:$conf->get("App.name") ?></title>
 
  <link rel="stylesheet" href="<?= $root ?>/assets/core/style.css">
  
  <script src="<?= $root ?>/assets/core/jquery-3.4.1.min.js"></script>
  <script src="<?= $root ?>/assets/core/vue.min.js"></script>
  <script src="<?= $root ?>/assets/core/popper.min.js"></script>
  <script src="<?= $root ?>/assets/core/bootstrap.min.js"></script>
  <script src="<?= $root ?>/assets/vendor/howler.js-master/howler.min.js"></script>

  <script>
    $(document).ajaxStop(function(){
      $("#ajax_loading").hide()
    });

    $(document).ajaxStart(function(){
      $("#ajax_loading").show()
    });
  </script>
</head>


<style>

  #keyboard{
    z-index: 9999;
    width: 100vw !important
  }

 

</style>
<body>


<div id="app" v-cloak>

  <?php require("./inc/header.inc.php") ?>
  <div class="container-fluid" >
  <div class="row">



    <main role="main" class="col px-4 " style="padding-top: 0vh">
      <!-- content here -->
      <?php $display->display_messages() ?>
      <div class="row" style="height: 80vh">
        <?php require_once("inc/bill_list.inc.php") ?>
        <?php require_once("inc/product_list.inc.php") ?>
        
      </div>
    </main>


  </div>


  <?php require_once("inc/modals.inc.php") ?>
  <?php require_once("inc/product_modals.inc.php") ?>
  <?php require_once("inc/payment_modal.inc.php") ?>
  <?php require_once("inc/lasts.inc.php") ?>
  

</div>
</div>


<?php require_once("inc/vendor.php") ?>
<?php require_once("inc/script.inc.php") ?> 





</body>
</html>