<?php 
use Classes\Hash;
use Classes\Validator;

$v = new Validator;
if (isset($_POST['save']) && $tk->passes()) {
	

	$name      =isset($_POST['name'])?$_POST['name']:'';
	$phone     =isset($_POST['phone'])?$_POST['phone']:'';

	$email     =isset($_POST['email'])?$_POST['email']:'';
	// $log_name     =isset($_POST['email'])?$_POST['email']:'';



	$v->validate([
		tr("Name")           =>[$name,"required"],
		tr("phone")          =>[$phone,"required|number|unique_phone(".auth()->id.")"],
		tr("Email")          =>[$email,"required|unique_email(".auth()->id.")"],
		// tr("Log name")          =>[$log_name,"required|unique_logname(".auth()->id.")"],
		// tr("log_name")       =>[$log_name,"required|unique_logname(users,log_name)"],


	]);




	if ($v->passes() ) {

	

		$db->query(
		"UPDATE users SET name=?,phone=?,email=?,updated_by=?,updated_at=? WHERE id=?",
		[ $name,$phone,$email,auth()->id,timestamp(),auth()->id ]
				);



		$display->success(tr("Profile updated successfully."));
		// $redirect->to(remove_from_url($this_url,["v"]));
		
	}
}

if (isset($_POST['update_password']) && $tk->passes()) {
	$password  =isset($_POST['password'])?$_POST['password']:'';
	$cpassword =isset($_POST['cpassword'])?$_POST['cpassword']:'';
	$v->validate([
				
				tr("password")       =>[$password,"required"],
				tr("Password again") =>[$cpassword,"required|matches(".tr("password").")"],

			]);

	if ($v->passes()) {
		$db->query(
				"UPDATE users SET password=? WHERE id=?",
				[ Hash::password($password),auth()->id ]
			);

		$display->success(tr("password updated successfully."));
	}
}
$display->error($v->errors()->all());