<?php
  $root="..";
  require("../php/init.php");
  




$from = date("Y-m-1");
$to = date("Y-m-d");



if (isset($_GET['from'])) {
  $from = date("Y-m-d",strtotime($_GET['from']));
}

if (isset($_GET['to'])) {
  $to = date("Y-m-d",strtotime($_GET['to']));
}

  $page_nav=[
    "breadcrumb"=>[
      "Report"=>""
    ],
    "branch"=>1,
    "date_filter"=>[
      "from"=>$from,
      "to"=>$to,
    ]
  ];



$sql = "SELECT SUM(d.quantity) 
FROM order_data d LEFT JOIN orders o ON o.id = d.order_id
WHERE d.dish_id = ? 
AND d.size = ? 
AND DATE(o.created_at)>=DATE( '$from') 
AND DATE(o.created_at)<=DATE( '$to') AND o.status='Completed'
AND ".branch()->query("o.branch_id");





?>
<!DOCTYPE html>
<html <?= $local ?> >
  <?php require($root."/inc/head.php") ?>
  
  <body class=" <?= isset($page['class'])?$page['class']:'' ?> " >
    <?php require($root."/inc/header.php") ?>

  

<!-- content here -->
<?php $display->display_messages() ?>
<div class="card">
  <div class="card-header">
    <div class="row">
      <div class="col-md-6 ">
        <h3>Dishes report</h3>
      </div>
      <div class="col-md-6 text-end">
        
        
      </div>
    </div>
  </div>
      <table class="table table-responsive-md  table-hover  " id="datatable-tabletools"> 
      <thead>
        <tr>
          <th>#</th>
          
          <th colspan="2" class="text-center">Dish</th>
          <th>Category</th>
          <th class="text-center">Size/Price/Sold</th>
          <th class="text-center">Sold Qty</th>
          <th class="text-center">Sales</th>
         
        </tr>
      </thead>
      <tbody>
        <?php foreach ($db->query("SELECT d.*, c.name as category  FROM dishes d LEFT JOIN categories c ON c.id = d.category_id WHERE d.deleted_01=0") as $key => $pr): ?>
          <?php 
            $sizes=json_decode($pr['sizes'],true);
            $prices=json_decode($pr['prices'],true);
           ?>
          <tr>
            <td><?= $pr['id'] ?></td>
            <td >
          
                <img style="max-width: 80px; max-height: 80px;" src="<?= file_get($pr['file']) ?>" alt="" >
        
            </td>
            <td><?= $pr['name'] ?></td>
            <td><?= $pr['category'] ?></td>
            <td class="text-center">
              <table class="table table-sm table-borderless p-0 m-0" style="width: 80px;">
                
              
                <?php $sales=0;$totalSold=0; ?>
                <?php for ($i=0; $i < count($sizes); $i++) { ?>

                  <?php 
                  
         
                    $sold=$db->single($sql,[ $pr['id'],$sizes[$i] ]);
              
         
                  

                  $sales+=($prices[$i]*$sold);
                  $totalSold+=$sold;
                  
                   ?>

                  <tr>
                    <td class="p-1 m-0"><?= $sizes[$i] ?></td>
                    <td class="p-1 m-0"><?= amount($prices[$i]) ?></td>
                    <td class="p-1 m-0"><?= ($sold)?$sold:'--' ?></td>
                  </tr>
    
              
             
                  
                <?php } ?>
                </table>
              
            </td>
            <td class="text-center text-monospace"><?= float($totalSold,0) ?></td>
            <td class="text-center text-monospace"><?= amount($sales) ?></td>
     

          </tr>
        <?php endforeach ?>
      </tbody>
    </table>
</div>







  <?php require_once($root."/inc/footer.php") ?>
  <?php require_once($root."/inc/scripts.php") ?>


<script type="text/javascript">
    var url="./ajax/data-table.php?from=<?= $from ?>&to=<?= $to ?>"
    var table=''
    $(document).ready(function() {
        var $table = $('#datatable-tabletools');

         table = $table.dataTable({
          "lengthMenu": [
                [25, 50, 100],
                [25, 50, 100]
              ],
              // "order": [[ 0, "desc" ]],
          language: {
                  search: '<span></span> _INPUT_',
                  searchPlaceholder: '<?= tr("Search") ?>',
                  lengthMenu: '<span><?= tr("Show") ?>:</span> _MENU_',
                  paginate: { 'first': '<?= tr("First") ?>', 'last': '<?= tr("Last") ?>', 'next': '<?= tr("Next") ?>', 'previous': '<?= tr("Previous") ?>' }
              },
          "columnDefs": [
              // { "orderable": false, "targets": [10]},
        
              // { "targets": [8],"class": "text-indigo-800 text-center"},
              // { "targets": [9],"class": "text-indigo-800 "},
          ],
          
       
              stateSave: true,
 
          
          dom: '<"datatable-header"fBl><"datatable-scroll-wrap"t><"datatable-footer"ip>',
          responsive: true,
           autoWidth: false,

          buttons: {
          dom: {
              button: {
                  className: 'btn btn-light border'
                  }
              },
              buttons: [
                { 
                  extend: 'copyHtml5', 
                 
                  exportOptions: {
                      stripHtml: false,
                      columns: [ 0, 2,3,5,6 ]
                  }
                },

                { 
                  extend: 'csv', 
                 
                  exportOptions: {
                      stripHtml: false,
                      columns: [ 0, 2,3,5,6 ]
                  }
                },
                
         
                {
                    extend: 'print', 
                    footer: true,
                    exportOptions: {
                      stripHtml: false,
                      columns: [ 0,2,3,5,6 ]
                  }
                },

              ],
          },

          
        });
        });

</script>
</body>
</html>
