<?php
$root="..";
require("../php/init.php");

$user->authorize("view-reports");

$page=[
	"title"=>tr("Report"),
	"active"=>"report",
	"class"=>"sidebar-xs"
];

$from = date("Y-m-d",strtotime("-1 month"));
$to = date("Y-m-d");

if (isset($_GET['from'])) {
	$from = date("Y-m-d",strtotime($_GET['from']));
}

if (isset($_GET['to'])) {
	$to = date("Y-m-d",strtotime($_GET['to']));
}

$page_nav=[
	"breadcrumb"=>[
		tr("Report")=>""
	],
	"branch"=>1,
	"date_filter"=>[
		"from"=>$from,
		"to"=>$to,
	]
];

// Fetch all data
$order = $db->row("SELECT sum(price-discount) as tprice, count(*) as rownum, sum(totaldiscount) as tdiscount FROM orders WHERE status='Completed' AND deleted_01=0 AND DATE(created_at)>=DATE('$from') AND DATE(created_at)<=DATE('$to') AND ".branch()->query());

$hold_orders = $db->row("SELECT count(*) as cnt, sum(price) as total FROM orders WHERE status='Hold' AND DATE(created_at)>=DATE('$from') AND DATE(created_at)<=DATE('$to') AND ".branch()->query());

$canceled_orders = $db->row("SELECT count(*) as cnt, sum(price) as total FROM orders WHERE status='Canceled' AND DATE(created_at)>=DATE('$from') AND DATE(created_at)<=DATE('$to') AND ".branch()->query());

$expenses = $db->single("SELECT sum(amount) FROM expenses WHERE deleted_01=0 AND DATE(e_date)>=DATE('$from') AND DATE(e_date)<=DATE('$to') AND ".branch()->query());

$purchases = $db->single("SELECT sum(d.cost*d.qty) FROM stock_imports_data d LEFT JOIN stock_imports s ON s.id = d.import_id WHERE d.deleted_01=0 AND s.deleted_01=0 AND DATE(s.time_date)>=DATE('$from') AND DATE(s.time_date)<=DATE('$to') AND ".branch()->query('d.branch_id'));

$tpayments = $db->single("SELECT sum(amount) FROM payments WHERE deleted_01=0 AND form_id=0 AND DATE(created_at)>=DATE('$from') AND DATE(created_at)<=DATE('$to') AND ".branch()->query());

$payments = $db->column("SELECT DISTINCT method FROM payments WHERE deleted_01=0 AND method!='' AND form_id=0 AND ".branch()->query());

$pay_by = [];
foreach ($payments as $method) {
	$pay_by[$method] = $db->single("SELECT sum(amount) FROM payments WHERE deleted_01=0 AND form_id=0 AND method=? AND DATE(created_at)>=DATE('$from') AND DATE(created_at)<=DATE('$to') AND ".branch()->query(), [$method]);
}

// User sales
$user_sales = $db->query("SELECT u.name, sum(p.amount) as total FROM payments p LEFT JOIN users u ON u.id = p.created_by WHERE p.deleted_01=0 AND p.form_id=0 AND DATE(p.created_at)>=DATE('$from') AND DATE(p.created_at)<=DATE('$to') AND ".branch()->query('p.branch_id')." GROUP BY p.created_by HAVING total > 0 ORDER BY total DESC");

// Delivery stats
$delivery_stats = $db->query("SELECT d.name, SUM(o.price) as total_price, COUNT(o.delivery_id) as order_count FROM delivery d JOIN orders o ON d.id = o.delivery_id WHERE DATE(o.created_at)>=DATE(?) AND DATE(o.created_at)<=DATE(?) AND ".branch()->query("o.branch_id")." GROUP BY d.id ORDER BY total_price DESC", [$from, $to]);

// Daily sales for chart
$daily_sales = $db->query("SELECT DATE(created_at) as date, sum(price-discount) as total, count(*) as cnt FROM orders WHERE status='Completed' AND deleted_01=0 AND DATE(created_at)>=DATE('$from') AND DATE(created_at)<=DATE('$to') AND ".branch()->query()." GROUP BY DATE(created_at) ORDER BY date ASC");

// Calculate totals
$total_revenue = floatval($order['tprice'] ?? 0);
$total_expenses = floatval($expenses ?? 0);
$total_purchases = floatval($purchases ?? 0);
$gross_profit = $total_revenue - $total_purchases;
$net_profit = $total_revenue - $total_expenses - $total_purchases;

// Get max for chart scaling
$max_sale = 1;
foreach ($daily_sales as $ds) {
	if (floatval($ds['total']) > $max_sale) {
		$max_sale = floatval($ds['total']);
	}
}

// Cake (for branch 1)
$cake_price = 0;
if (branch()->id() == 1) {
	$cake_price = $db->single("SELECT sum(price) FROM cake WHERE status='Completed' AND deleted_01=0 AND DATE(added_on)>=DATE('$from') AND DATE(added_on)<=DATE('$to')");
}

// Monthly Performance - Last 12 months
$monthly_performance = [];
for ($i = 11; $i >= 0; $i--) {
	$month_start = date("Y-m-01", strtotime("-$i months"));
	$month_end = date("Y-m-t", strtotime("-$i months"));
	$month_name = date("M Y", strtotime("-$i months"));
	
	$month_revenue = $db->single("SELECT COALESCE(sum(price-discount), 0) FROM orders WHERE status='Completed' AND deleted_01=0 AND DATE(created_at)>=DATE('$month_start') AND DATE(created_at)<=DATE('$month_end') AND ".branch()->query());
	
	$month_orders = $db->single("SELECT COUNT(*) FROM orders WHERE status='Completed' AND deleted_01=0 AND DATE(created_at)>=DATE('$month_start') AND DATE(created_at)<=DATE('$month_end') AND ".branch()->query());
	
	$month_expenses = $db->single("SELECT COALESCE(sum(amount), 0) FROM expenses WHERE deleted_01=0 AND DATE(e_date)>=DATE('$month_start') AND DATE(e_date)<=DATE('$month_end') AND ".branch()->query());
	
	$month_purchases = $db->single("SELECT COALESCE(sum(d.cost*d.qty), 0) FROM stock_imports_data d LEFT JOIN stock_imports s ON s.id = d.import_id WHERE d.deleted_01=0 AND s.deleted_01=0 AND DATE(s.time_date)>=DATE('$month_start') AND DATE(s.time_date)<=DATE('$month_end') AND ".branch()->query('d.branch_id'));
	
	$month_profit = floatval($month_revenue) - floatval($month_expenses) - floatval($month_purchases);
	
	$monthly_performance[] = [
		'month' => $month_name,
		'month_num' => date("m", strtotime("-$i months")),
		'revenue' => floatval($month_revenue),
		'orders' => intval($month_orders),
		'expenses' => floatval($month_expenses),
		'purchases' => floatval($month_purchases),
		'profit' => $month_profit
	];
}

// Get max revenue for chart scaling
$max_monthly_revenue = 1;
foreach ($monthly_performance as $mp) {
	if ($mp['revenue'] > $max_monthly_revenue) {
		$max_monthly_revenue = $mp['revenue'];
	}
}

?>
<!DOCTYPE html>
<html <?= $local ?>>
<?php require($root."/inc/head.php") ?>

<style>
	.report-card {
		border: none;
		border-radius: 8px;
		transition: transform 0.2s, box-shadow 0.2s;
		overflow: hidden;
	}
	.report-card:hover {
		transform: translateY(-2px);
	}
	.stat-icon {
		width: 50px;
		height: 50px;
		border-radius: 8px;
		display: flex;
		align-items: center;
		justify-content: center;
		font-size: 20px;
	}
	.stat-value {
		font-size: 1.5rem;
		font-weight: 700;
	}
	.stat-label {
		font-size: 0.8rem;
		text-transform: uppercase;
		letter-spacing: 0.5px;
	}
	.kpi-positive { color: #28a745; }
	.kpi-negative { color: #dc3545; }
	.section-title {
		font-size: 1rem;
		font-weight: 600;
		color: #495057;
		margin-bottom: 1rem;
		padding-bottom: 0.5rem;
		border-bottom: 2px solid #e9ecef;
	}
	.summary-header {
		background: linear-gradient(135deg, #2c3e50 0%, #34495e 100%);
		border-radius: 8px;
		color: white;
		padding: 1.5rem;
		margin-bottom: 1.5rem;
	}
	.chart-bar {
		height: 8px;
		border-radius: 4px;
		background: #e9ecef;
		overflow: hidden;
	}
	.chart-bar-fill {
		height: 100%;
		border-radius: 4px;
		background: linear-gradient(90deg, #007bff, #00c6ff);
		transition: width 0.5s ease;
	}
	.progress-thin {
		height: 6px;
		border-radius: 3px;
	}
	.table-report th {
		background: #f8f9fa;
		font-weight: 600;
		text-transform: uppercase;
		font-size: 0.75rem;
		letter-spacing: 0.5px;
		color: #6c757d;
		border-top: none;
	}
	.table-report td {
		vertical-align: middle;
	}
	.avatar-circle {
		width: 36px;
		height: 36px;
		border-radius: 50%;
		display: inline-flex;
		align-items: center;
		justify-content: center;
	}
	.border-left-success { border-left: 4px solid #28a745 !important; }
	.border-left-warning { border-left: 4px solid #ffc107 !important; }
	.border-left-danger { border-left: 4px solid #dc3545 !important; }
	.border-left-info { border-left: 4px solid #17a2b8 !important; }
	.border-left-primary { border-left: 4px solid #007bff !important; }
	@media print {
		.no-print { display: none !important; }
		.report-card { box-shadow: none !important; border: 1px solid #ddd; }
		.summary-header { background: #2c3e50 !important; }
	}
</style>

<body class="<?= isset($page['class'])?$page['class']:'' ?>">
	<?php require($root."/inc/header.php") ?>

	<div class="row">
		<div class="col">
			<?php $display->display_messages() ?>
			<div id="notify"></div>

			<!-- Header Section -->
			<div class="summary-header shadow">
				<div class="row align-items-center">
					<div class="col-md-8">
						<h4 class="mb-1 font-weight-bold">
							<i class="fas fa-chart-line mr-2"></i><?= tr("Financial Summary")?>
						</h4>
						<p class="mb-0" style="opacity: 0.8;">
							<i class="far fa-calendar-alt mr-1"></i>
							<?= date("M d, Y", strtotime($from)) ?> - <?= date("M d, Y", strtotime($to)) ?>
							<span class="mx-2">|</span>
							<i class="fas fa-store mr-1"></i><?= escap(branch()->name()) ?>
						</p>
					</div>
					<div class="col-md-4 text-right no-print">
						<button type="button" onclick="window.print();" class="btn btn-light rounded-pill px-4">
							<i class="fas fa-print mr-2"></i><?= tr("Print") ?>
						</button>
					</div>
				</div>
			</div>

			<!-- KPI Cards Row -->
			<div class="row mb-4">
				<!-- Total Revenue -->
				<div class="col-md-6 col-lg-3 mb-3">
					<div class="card report-card shadow-sm h-100 border-left-success">
						<div class="card-body">
							<div class="d-flex justify-content-between align-items-start">
								<div>
									<p class="stat-label text-muted mb-1"><?= tr("Total Revenue") ?></p>
									<h4 class="stat-value text-dark mb-0"><?= amount($total_revenue) ?></h4>
									<small class="text-muted"><?= $order['rownum'] ?? 0 ?> <?= tr("orders") ?></small>
								</div>
								<div class="stat-icon bg-success text-white">
									<i class="fas fa-dollar-sign"></i>
								</div>
							</div>
						</div>
					</div>
				</div>

				<!-- Total Expenses -->
				<div class="col-md-6 col-lg-3 mb-3">
					<div class="card report-card shadow-sm h-100 border-left-danger">
						<div class="card-body">
							<div class="d-flex justify-content-between align-items-start">
								<div>
									<p class="stat-label text-muted mb-1"><?= tr("Total Expenses") ?></p>
									<h4 class="stat-value text-dark mb-0"><?= amount($total_expenses) ?></h4>
									<small class="text-muted"><?= tr("Operating costs") ?></small>
								</div>
								<div class="stat-icon bg-danger text-white">
									<i class="fas fa-receipt"></i>
								</div>
							</div>
						</div>
					</div>
				</div>

				<!-- Purchases -->
				<div class="col-md-6 col-lg-3 mb-3">
					<div class="card report-card shadow-sm h-100 border-left-warning">
						<div class="card-body">
							<div class="d-flex justify-content-between align-items-start">
								<div>
									<p class="stat-label text-muted mb-1"><?= tr("Purchases") ?></p>
									<h4 class="stat-value text-dark mb-0"><?= amount($total_purchases) ?></h4>
									<small class="text-muted"><?= tr("Stock purchases") ?></small>
								</div>
								<div class="stat-icon bg-warning text-white">
									<i class="fas fa-shopping-cart"></i>
								</div>
							</div>
						</div>
					</div>
				</div>

				<!-- Net Profit -->
				<div class="col-md-6 col-lg-3 mb-3">
					<div class="card report-card shadow-sm h-100 border-left-<?= $net_profit >= 0 ? 'success' : 'danger' ?>">
						<div class="card-body">
							<div class="d-flex justify-content-between align-items-start">
								<div>
									<p class="stat-label text-muted mb-1"><?= tr("Net Profit") ?></p>
									<h4 class="stat-value <?= $net_profit >= 0 ? 'kpi-positive' : 'kpi-negative' ?> mb-0">
										<?= amount($net_profit) ?>
									</h4>
									<small class="<?= $net_profit >= 0 ? 'kpi-positive' : 'kpi-negative' ?>">
										<i class="fas fa-<?= $net_profit >= 0 ? 'arrow-up' : 'arrow-down' ?> mr-1"></i>
										<?= $total_revenue > 0 ? number_format(($net_profit / $total_revenue) * 100, 1) : 0 ?>% <?= tr("margin") ?>
									</small>
								</div>
								<div class="stat-icon bg-<?= $net_profit >= 0 ? 'success' : 'danger' ?> text-white">
									<i class="fas fa-chart-pie"></i>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			<!-- Orders Status Cards -->
			<div class="row mb-4">
				<div class="col-12 mb-3">
					<h5 class="section-title"><i class="fas fa-shopping-bag mr-2"></i><?= tr("Orders Overview") ?></h5>
				</div>
				
				<div class="col-md-4 mb-3">
					<div class="card report-card shadow-sm h-100">
						<div class="card-body">
							<div class="d-flex align-items-center">
								<div class="stat-icon bg-success text-white mr-3">
									<i class="fas fa-check-circle"></i>
								</div>
								<div class="flex-grow-1">
									<h4 class="mb-0 font-weight-bold"><?= $order['rownum'] ?? 0 ?></h4>
									<p class="text-muted mb-0 small"><?= tr("Completed") ?></p>
								</div>
								<div class="text-right">
									<span class="badge badge-success px-3 py-2"><?= amount($total_revenue) ?></span>
								</div>
							</div>
						</div>
					</div>
				</div>

				<div class="col-md-4 mb-3">
					<div class="card report-card shadow-sm h-100">
						<div class="card-body">
							<div class="d-flex align-items-center">
								<div class="stat-icon bg-warning text-white mr-3">
									<i class="fas fa-pause-circle"></i>
								</div>
								<div class="flex-grow-1">
									<h4 class="mb-0 font-weight-bold"><?= $hold_orders['cnt'] ?? 0 ?></h4>
									<p class="text-muted mb-0 small"><?= tr("On Hold") ?></p>
								</div>
								<div class="text-right">
									<span class="badge badge-warning px-3 py-2"><?= amount($hold_orders['total'] ?? 0) ?></span>
								</div>
							</div>
						</div>
					</div>
				</div>

				<div class="col-md-4 mb-3">
					<div class="card report-card shadow-sm h-100">
						<div class="card-body">
							<div class="d-flex align-items-center">
								<div class="stat-icon bg-danger text-white mr-3">
									<i class="fas fa-times-circle"></i>
								</div>
								<div class="flex-grow-1">
									<h4 class="mb-0 font-weight-bold"><?= $canceled_orders['cnt'] ?? 0 ?></h4>
									<p class="text-muted mb-0 small"><?= tr("Canceled") ?></p>
								</div>
								<div class="text-right">
									<span class="badge badge-danger px-3 py-2"><?= amount($canceled_orders['total'] ?? 0) ?></span>
								</div>
							</div>
						</div>
					</div>
				</div>

				<?php if (floatval($order['tdiscount'] ?? 0) > 0): ?>
				<div class="col-md-4 mb-3">
					<div class="card report-card shadow-sm h-100">
						<div class="card-body">
							<div class="d-flex align-items-center">
								<div class="stat-icon bg-info text-white mr-3">
									<i class="fas fa-percentage"></i>
								</div>
								<div class="flex-grow-1">
									<h4 class="mb-0 font-weight-bold"><?= amount($order['tdiscount']) ?></h4>
									<p class="text-muted mb-0 small"><?= tr("Total Discounts") ?></p>
								</div>
							</div>
						</div>
					</div>
				</div>
				<?php endif ?>
			</div>

			<div class="row mb-4">
				<!-- Sales Trend -->
				<div class="col-lg-8 mb-3">
					<div class="card report-card shadow-sm h-100">
						<div class="card-header bg-white border-0 pt-3 pb-0">
							<h5 class="section-title mb-0 border-0 pb-0">
								<i class="fas fa-chart-bar mr-2"></i><?= tr("Daily Sales") ?>
							</h5>
						</div>
						<div class="card-body">
							<?php if (count($daily_sales) > 0): ?>
							<div class="table-responsive">
								<table class="table table-sm mb-0">
									<tbody>
										<?php foreach ($daily_sales as $ds): ?>
										<?php $percent = ($ds['total'] / $max_sale) * 100; ?>
										<tr>
											<td style="width: 100px;" class="text-muted small"><?= date("M d", strtotime($ds['date'])) ?></td>
											<td>
												<div class="chart-bar">
													<div class="chart-bar-fill" style="width: <?= $percent ?>%;"></div>
												</div>
											</td>
											<td style="width: 120px;" class="text-right font-weight-bold"><?= amount($ds['total']) ?></td>
											<td style="width: 60px;" class="text-right text-muted small"><?= $ds['cnt'] ?> <i class="fas fa-shopping-cart"></i></td>
										</tr>
										<?php endforeach ?>
									</tbody>
								</table>
							</div>
							<?php else: ?>
							<div class="text-center text-muted py-5">
								<i class="fas fa-chart-bar fa-3x mb-3" style="opacity:0.3"></i>
								<p><?= tr("No sales data available") ?></p>
							</div>
							<?php endif ?>
						</div>
					</div>
				</div>

				<!-- Payment Methods -->
				<div class="col-lg-4 mb-3">
					<div class="card report-card shadow-sm h-100">
						<div class="card-header bg-white border-0 pt-3 pb-0">
							<h5 class="section-title mb-0 border-0 pb-0">
								<i class="fas fa-credit-card mr-2"></i><?= tr("Payment Methods") ?>
							</h5>
						</div>
						<div class="card-body">
							<div class="mb-3 pb-3 border-bottom">
								<div class="d-flex justify-content-between align-items-center">
									<span class="font-weight-bold"><?= tr("Total") ?></span>
									<span class="badge badge-success px-3 py-2"><?= amount($tpayments) ?></span>
								</div>
							</div>
							<?php if (count($pay_by) > 0): ?>
							<?php foreach ($pay_by as $method => $amt): ?>
							<?php $percentage = $tpayments > 0 ? ($amt / $tpayments) * 100 : 0; ?>
							<div class="mb-3">
								<div class="d-flex justify-content-between mb-1">
									<span class="small"><?= escap($method) ?></span>
									<span class="font-weight-bold small"><?= amount($amt) ?></span>
								</div>
								<div class="progress progress-thin">
									<div class="progress-bar bg-primary" style="width: <?= $percentage ?>%"></div>
								</div>
								<small class="text-muted"><?= number_format($percentage, 1) ?>%</small>
							</div>
							<?php endforeach ?>
							<?php else: ?>
							<div class="text-center text-muted py-4">
								<p class="mb-0"><?= tr("No payment data") ?></p>
							</div>
							<?php endif ?>
						</div>
					</div>
				</div>
			</div>

			<div class="row mb-4">
				<!-- Sales by User -->
				<div class="col-lg-6 mb-3">
					<div class="card report-card shadow-sm h-100">
						<div class="card-header bg-white border-0 pt-3 pb-0">
							<h5 class="section-title mb-0 border-0 pb-0">
								<i class="fas fa-user-tie mr-2"></i><?= tr("Sales by Staff") ?>
							</h5>
						</div>
						<div class="card-body p-0">
							<table class="table table-report mb-0">
								<thead>
									<tr>
										<th class="pl-3"><?= tr("Staff") ?></th>
										<th class="text-right"><?= tr("Amount") ?></th>
										<th class="text-right pr-3"><?= tr("Share") ?></th>
									</tr>
								</thead>
								<tbody>
									<?php if (count($user_sales) > 0): ?>
									<?php foreach ($user_sales as $us): ?>
									<?php $share = $tpayments > 0 ? ($us['total'] / $tpayments) * 100 : 0; ?>
									<tr>
										<td class="pl-3">
											<span class="avatar-circle bg-primary text-white mr-2">
												<i class="fas fa-user small"></i>
											</span>
											<?= escap($us['name']) ?>
										</td>
										<td class="text-right font-weight-bold"><?= amount($us['total']) ?></td>
										<td class="text-right pr-3">
											<span class="badge badge-light"><?= number_format($share, 1) ?>%</span>
										</td>
									</tr>
									<?php endforeach ?>
									<?php else: ?>
									<tr>
										<td colspan="3" class="text-center text-muted py-4"><?= tr("No data available") ?></td>
									</tr>
									<?php endif ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>

				<!-- Delivery Stats -->
				<div class="col-lg-6 mb-3">
					<div class="card report-card shadow-sm h-100">
						<div class="card-header bg-white border-0 pt-3 pb-0">
							<h5 class="section-title mb-0 border-0 pb-0">
								<i class="fas fa-motorcycle mr-2"></i><?= tr("Delivery Performance") ?>
							</h5>
						</div>
						<div class="card-body p-0">
							<table class="table table-report mb-0">
								<thead>
									<tr>
										<th class="pl-3"><?= tr("Service") ?></th>
										<th class="text-center"><?= tr("Orders") ?></th>
										<th class="text-right pr-3"><?= tr("Revenue") ?></th>
									</tr>
								</thead>
								<tbody>
									<?php if (count($delivery_stats) > 0): ?>
									<?php foreach ($delivery_stats as $dv): ?>
									<tr>
										<td class="pl-3">
											<span class="avatar-circle bg-warning text-white mr-2">
												<i class="fas fa-truck small"></i>
											</span>
											<?= escap($dv['name']) ?>
										</td>
										<td class="text-center">
											<span class="badge badge-secondary"><?= $dv['order_count'] ?></span>
										</td>
										<td class="text-right font-weight-bold pr-3"><?= amount($dv['total_price']) ?></td>
									</tr>
									<?php endforeach ?>
									<?php else: ?>
									<tr>
										<td colspan="3" class="text-center text-muted py-4"><?= tr("No delivery data") ?></td>
									</tr>
									<?php endif ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>

			<?php if ($cake_price > 0): ?>
			<!-- Cake Section -->
			<div class="row mb-4">
				<div class="col-md-6 mb-3">
					<div class="card report-card shadow-sm border-left-info">
						<div class="card-body">
							<div class="d-flex align-items-center">
								<div class="stat-icon mr-3" style="background: #e91e63;">
									<i class="fas fa-birthday-cake text-white"></i>
								</div>
								<div>
									<h4 class="mb-0 font-weight-bold"><?= amount($cake_price) ?></h4>
									<p class="text-muted mb-0 small"><?= tr("Cake Sales") ?></p>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php endif ?>

			<!-- Financial Summary Table -->
			<div class="row mb-4">
				<div class="col-12">
					<div class="card report-card shadow-sm">
						<div class="card-header bg-white border-0 pt-3 pb-0">
							<h5 class="section-title mb-0 border-0 pb-0">
								<i class="fas fa-file-invoice-dollar mr-2"></i><?= tr("Financial Breakdown") ?>
							</h5>
						</div>
						<div class="card-body p-0">
							<table class="table mb-0">
								<tbody>
									<tr>
										<td class="pl-4 font-weight-bold">
											<i class="fas fa-plus-circle text-success mr-2"></i><?= tr("Total Revenue") ?>
										</td>
										<td class="text-right pr-4 font-weight-bold text-success" style="font-size: 1.1rem;">
											<?= amount($total_revenue) ?>
										</td>
									</tr>
									<tr>
										<td class="pl-4 font-weight-bold">
											<i class="fas fa-minus-circle text-danger mr-2"></i><?= tr("Purchases (COGS)") ?>
										</td>
										<td class="text-right pr-4 font-weight-bold text-danger" style="font-size: 1.1rem;">
											- <?= amount($total_purchases) ?>
										</td>
									</tr>
									<tr class="bg-light">
										<td class="pl-4 font-weight-bold">
											<i class="fas fa-equals text-info mr-2"></i><?= tr("Gross Profit") ?>
										</td>
										<td class="text-right pr-4 font-weight-bold <?= $gross_profit >= 0 ? 'text-success' : 'text-danger' ?>" style="font-size: 1.1rem;">
											<?= amount($gross_profit) ?>
										</td>
									</tr>
									<tr>
										<td class="pl-4 font-weight-bold">
											<i class="fas fa-minus-circle text-danger mr-2"></i><?= tr("Operating Expenses") ?>
										</td>
										<td class="text-right pr-4 font-weight-bold text-danger" style="font-size: 1.1rem;">
											- <?= amount($total_expenses) ?>
										</td>
									</tr>
									<tr class="bg-primary text-white">
										<td class="pl-4 font-weight-bold" style="font-size: 1.1rem;">
											<i class="fas fa-calculator mr-2"></i><?= tr("Net Profit/Loss") ?>
										</td>
										<td class="text-right pr-4 font-weight-bold" style="font-size: 1.3rem;">
											<?= amount($net_profit) ?>
										</td>
									</tr>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>

			<!-- Monthly Performance -->
			<div class="row mb-4">
				<div class="col-12 mb-3">
					<h5 class="section-title"><i class="fas fa-calendar-alt mr-2"></i><?= tr("Monthly Performance") ?> (<?= tr("Last 12 Months") ?>)</h5>
				</div>
				
				<!-- Monthly Chart -->
				<div class="col-12 mb-4">
					<div class="card report-card shadow-sm">
						<div class="card-header bg-white border-0 pt-3 pb-0">
							<h6 class="mb-0 text-muted">
								<i class="fas fa-chart-line mr-2"></i><?= tr("Revenue Trend") ?>
							</h6>
						</div>
						<div class="card-body">
							<div class="d-flex align-items-end justify-content-between" style="height: 200px;">
								<?php foreach ($monthly_performance as $mp): ?>
								<?php $height = $max_monthly_revenue > 0 ? ($mp['revenue'] / $max_monthly_revenue) * 100 : 0; ?>
								<div class="text-center flex-fill px-1">
									<div class="d-flex flex-column align-items-center" style="height: 180px;">
										<small class="text-muted mb-1" style="font-size: 0.7rem;"><?= amount($mp['revenue'], 0) ?></small>
										<div class="flex-grow-1 d-flex align-items-end w-100">
											<div class="w-100 rounded-top <?= $mp['profit'] >= 0 ? 'bg-success' : 'bg-danger' ?>" 
												 style="height: <?= max($height, 2) ?>%; min-height: 4px; opacity: 0.8;"
												 data-toggle="tooltip" 
												 title="<?= $mp['month'] ?>: <?= amount($mp['revenue']) ?>"></div>
										</div>
										<small class="mt-1 text-muted" style="font-size: 0.65rem;"><?= substr($mp['month'], 0, 3) ?></small>
									</div>
								</div>
								<?php endforeach ?>
							</div>
							<div class="mt-3 d-flex justify-content-center">
								<span class="mr-4"><span class="badge badge-success">&nbsp;</span> <?= tr("Profit") ?></span>
								<span><span class="badge badge-danger">&nbsp;</span> <?= tr("Loss") ?></span>
							</div>
						</div>
					</div>
				</div>

				<!-- Monthly Table -->
				<div class="col-12">
					<div class="card report-card shadow-sm">
						<div class="card-header bg-white border-0 pt-3 pb-0">
							<h6 class="mb-0 text-muted">
								<i class="fas fa-table mr-2"></i><?= tr("Detailed Monthly Breakdown") ?>
							</h6>
						</div>
						<div class="card-body p-0">
							<div class="table-responsive">
								<table class="table table-report table-hover mb-0">
									<thead>
										<tr>
											<th class="pl-3"><?= tr("Month") ?></th>
											<th class="text-center"><?= tr("Orders") ?></th>
											<th class="text-right"><?= tr("Revenue") ?></th>
											<th class="text-right"><?= tr("Purchases") ?></th>
											<th class="text-right"><?= tr("Expenses") ?></th>
											<th class="text-right pr-3"><?= tr("Net Profit") ?></th>
										</tr>
									</thead>
									<tbody>
										<?php 
										$total_year_revenue = 0;
										$total_year_orders = 0;
										$total_year_expenses = 0;
										$total_year_purchases = 0;
										$total_year_profit = 0;
										foreach ($monthly_performance as $mp): 
											$total_year_revenue += $mp['revenue'];
											$total_year_orders += $mp['orders'];
											$total_year_expenses += $mp['expenses'];
											$total_year_purchases += $mp['purchases'];
											$total_year_profit += $mp['profit'];
										?>
										<tr>
											<td class="pl-3">
												<i class="far fa-calendar mr-2 text-muted"></i>
												<strong><?= $mp['month'] ?></strong>
											</td>
											<td class="text-center">
												<span class="badge badge-secondary"><?= $mp['orders'] ?></span>
											</td>
											<td class="text-right font-weight-bold text-success">
												<?= amount($mp['revenue']) ?>
											</td>
											<td class="text-right text-danger">
												<?= amount($mp['purchases']) ?>
											</td>
											<td class="text-right text-danger">
												<?= amount($mp['expenses']) ?>
											</td>
											<td class="text-right pr-3 font-weight-bold <?= $mp['profit'] >= 0 ? 'text-success' : 'text-danger' ?>">
												<?php if ($mp['profit'] >= 0): ?>
													<i class="fas fa-arrow-up mr-1 small"></i>
												<?php else: ?>
													<i class="fas fa-arrow-down mr-1 small"></i>
												<?php endif ?>
												<?= amount($mp['profit']) ?>
											</td>
										</tr>
										<?php endforeach ?>
									</tbody>
									<tfoot class="bg-dark text-white">
										<tr>
											<th class="pl-3"><?= tr("Total (12 Months)") ?></th>
											<th class="text-center"><?= number_format($total_year_orders) ?></th>
											<th class="text-right"><?= amount($total_year_revenue) ?></th>
											<th class="text-right"><?= amount($total_year_purchases) ?></th>
											<th class="text-right"><?= amount($total_year_expenses) ?></th>
											<th class="text-right pr-3 <?= $total_year_profit >= 0 ? 'text-success' : 'text-danger' ?>" style="font-size: 1.1rem;">
												<?= amount($total_year_profit) ?>
											</th>
										</tr>
									</tfoot>
								</table>
							</div>
						</div>
					</div>
				</div>
			</div>

		</div>
	</div>

	<?php require_once($root."/inc/footer.php") ?>
	<?php require_once($root."/inc/scripts.php") ?>

</body>
</html>
