<?php
  $root="..";
  require("../php/init.php");
  $page=['title'=>$conf->get("App.name")];

$branch_id = $user->branch_id;


$from = date("d-m-Y",strtotime("-1 month"));
$to = date("d-m-Y");



if (isset($_GET['from'])) {
  $from = date("d-m-Y",strtotime($_GET['from']));
}

if (isset($_GET['to'])) {
  $to = date("d-m-Y",strtotime($_GET['to']));
}

$sql = "SELECT COALESCE(SUM(qty),0) FROM order_data 
WHERE p_id = ? 
AND size = ? 
AND DATE(STR_TO_DATE(added_on, '%Y-%m-%d %H:%i:%s' ))>=DATE( STR_TO_DATE('$from', '%d-%m-%Y' )) 
AND DATE(STR_TO_DATE(added_on, '%Y-%m-%d %H:%i:%s' ))<=DATE( STR_TO_DATE('$to', '%d-%m-%Y' )) AND cancel_01=0 
AND branch_id =?";


if (isset($_GET['branch']) &&  is_ruled('branches')) {
  if (is_numeric($_GET['branch'])) {
    $branch_id = $_GET['branch'];
  }

  if ($_GET['branch']=="all") {
      $sql = "SELECT COALESCE(SUM(qty),0) FROM order_data 
        WHERE p_id = ? 
        AND size = ? 
        AND DATE(STR_TO_DATE(added_on, '%Y-%m-%d %H:%i:%s' ))>=DATE( STR_TO_DATE('$from', '%d-%m-%Y' )) 
        AND DATE(STR_TO_DATE(added_on, '%Y-%m-%d %H:%i:%s' ))<=DATE( STR_TO_DATE('$to', '%d-%m-%Y' )) AND cancel_01=0 
        ";
    }
}

if (isset($_GET[$conf->get("csrf.session")])) {
  $redirect->to(remove_from_url($this_url,[$conf->get("csrf.session")]));
}
?>
<!DOCTYPE html>
<html lang="en">
<?php require($root . "/inc/head.inc.php") ?>
<body>

<?php require($root . "/inc/topbar.inc.php") ?>

<div class="container-fluid">
  <div class="row">
    <?php require($root . "/inc/sidelist.inc.php") ?>

    <main role="main" class="col-md-9 ml-sm-auto col-lg-10 px-4" >
      <!-- content here -->
      <?php $display->display_messages() ?>
    <div class="card">
  <div class="card-header">
    <div class="row">
      <div class="col-md-6 ">
        <h3>Products Report</h3>
      </div>
      <div class="col-md-6 text-end">
        <?php if (is_ruled('branches')): ?>
          <button type="button" class="btn btn-secondary dropdown-toggle" id="dropdownMenuOffset-branches" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" data-offset="10,20">
              Branch [
                <?php if (isset($_GET['branch']) &&  is_ruled('branches')): ?>
                  <?php if ($_GET['branch']!="all"): ?>
                    <?= escap($user->get_branch($_GET['branch'])['address']) ?>
                  <?php else: ?>
                    All
                  <?php endif ?>

                <?php else: ?>
                  <?= escap($user->get_branch($branch_id)['address']) ?>
                <?php endif ?>
              ]
            </button>
            <div class="dropdown-menu" aria-labelledby="dropdownMenuOffset-branches">
              <a class="dropdown-item" href="<?= add_to_url($this_url,['branch'],["all"]) ?>">All</a>
              <?php foreach ($branches as $key => $branch): ?>
                <a class="dropdown-item" href="<?= add_to_url($this_url,['branch'],[$branch['id']]) ?>"><?= escap($branch['address']) ?></a>
              <?php endforeach ?>
            </div>
        <?php endif ?>
        <button type="button" class="btn btn-secondary" data-toggle="modal" data-target="#filter-modal">
          <span><?= escap($from) ?></span> - 
          <span><?= escap($to) ?></span>
        </button>
      </div>
    </div>
  </div>
  <div class="card-body">


    <div class="row">
      <div class="col-md-6">
        <div id="chart-1"></div>
      </div>
      <div class="col-md-6">
        <div id="chart-2"></div>
      </div>
    </div>


    <table class="table table-responsive-md mb-0 table-hover v-align-center" id="datatable-tabletools">
      <thead>
        <tr>
          <th>#</th>
          <th>Image</th>
          <th>Product</th>
          <th>Categorey</th>
          <th class="text-center">Size/Price/Sold</th>
          <th class="text-center">Sold Qty</th>
          <th class="text-center">Sales</th>
          <th class="text-center">Action</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($product->get_products() as $key => $pr): ?>
          <?php 
            $sizes=json_decode($pr['sizes'],true);
            $prices=json_decode($pr['prices'],true);
           ?>
          <tr>
            <td><?= $pr['id'] ?></td>
            <td style="width: 100px">
              <div style="height: 70px;width: 100px" class="text-center">
                <img class="media" src="<?= $root."/uploads/".$pr['file'] ?>" alt="" onerror="this.onerror=null; this.src='<?= $root ?>/assets/images/noimg.png'">
              </div>
            </td>
            <td><?= $pr['name'] ?></td>
            <td><?= $pr['category'] ?></td>
            <td class="text-center">
                <?php $sales=0;$totalSold=0; ?>
                <?php for ($i=0; $i < count($sizes); $i++) { ?>

                  <?php 
                  
                  if (isset($_GET['branch']) && $_GET['branch']=="all" &&  is_ruled('branches')) {
                    $sold=$db->single($sql,[ $pr['id'],$sizes[$i] ]);
                  }else{
                    $sold=$db->single($sql,[ $pr['id'],$sizes[$i], $branch_id ]);
                  }

                  $sales+=($prices[$i]*$sold);
                  $totalSold+=$sold;
                  
                   ?>
                   <p><?= escap($sizes[$i]) ?> : <?= amount($prices[$i]) ?> : <?= escap($sold) ?> </p>
              
             
                  
                <?php } ?>
              
            </td>
            <td class="text-center text-monospace"><?= $totalSold ?></td>
            <td class="text-center text-monospace"><?= amount($sales) ?></td>
            <td class="actions text-center">
              <div class="btn-group btns-action">
                <a title="View" href="<?= $app_url ?>/products/?v=edit&i=<?= $pr['id'] ?>" class="btn btn-sm btn-outline-secondary"><i class="fas fa-search"></i></a>
              </div>
            </td>

          </tr>
        <?php endforeach ?>
      </tbody>
    </table>
  </div>
</div>



    </main>


  </div>
</div>



<div class="modal" id="filter-modal" tabindex="-1" role="dialog" aria-labelledby="filter-modal-title" aria-hidden="true" data-backdrop="static" data-keyboard="false">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="filter-modal-title">Filter</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">

         <div class="col">
        <div class="list-group " >
          <a 
          class="list-group-item list-group-item-action text-center" 
          onclick="$('#from').val('<?= date("d-m-Y") ?>');$('#to').val('<?= date("d-m-Y",strtotime("-1 year")) ?>');$('#filter-form').submit();"
          >Today</a>
          <a 
          class="list-group-item list-group-item-action text-center" 
          onclick="$('#from').val('<?= date("d-m-Y",strtotime("-1 week")) ?>');$('#to').val('<?= date("d-m-Y",strtotime("-1 year")) ?>');$('#filter-form').submit();"
          >Last Week</a>
          <a 
          class="list-group-item list-group-item-action text-center" 
          onclick="$('#from').val('<?= date("d-m-Y",strtotime("-1 month")) ?>');$('#to').val('<?= date("d-m-Y",strtotime("-1 year")) ?>');$('#filter-form').submit();"
          >Last Month</a>
          <a 
          class="list-group-item list-group-item-action text-center"
          onclick="$('#from').val('<?= date("d-m-Y",strtotime("-1 year")) ?>');$('#to').val('<?= date("d-m-Y",strtotime("-1 year")) ?>');$('#filter-form').submit();"
          >Last Year</a>
        </div>
      </div>
        <hr>
        Date

        <form action="<?= $this_url ?>" method="get" class="form-row mb-2" id="filter-form">
          <div class="col">
            <label for="">From</label>
            <input  name="from" id="from" type="text" class="form-control text-center fiter-date-from" value="<?= $from ?>">
          </div>
          <div class="col">
            <label for="">To</label>
            <input name="to" id="from"  type="text" class="form-control text-center fiter-date-to" value="<?= $to ?>">
          </div>

          <?php if (isset($_GET['branch']) &&  is_ruled('branches')): ?>
            <input type="text" hidden="" name="branch" value="<?= escap($_GET['branch']) ?>">
          <?php endif ?>
        </form>
 

      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-danger"  data-dismiss="modal">Cancel</button>
        <button type="button" onclick="$('#from').val('<?= date("d-m-Y",strtotime("-1 month")) ?>');$('#to').val('<?= date("d-m-Y",strtotime("-1 year")) ?>');$('#filter-form').submit();" class="btn btn-secondary"  data-dismiss="modal">Reset</button>
        <button onclick="$('#filter-form').submit();" type="button" class="btn btn-primary">Apply</button>
      </div>
    </div>
  </div>
</div>



<?php require_once($root."/inc/footer.inc.php") ?>  
<?php require_once($root."/inc/vendors.inc.php") ?> 
<script src="<?= $root ?>/assets/vendor/chart-js/chartjs.min.js"></script>

<script>
  $(document).ready(function() {
    var $table = $('#datatable-tabletools');
    var table = $table.dataTable({
      "lengthMenu": [
      [25, 100, 500,-1],
      [25, 100, 500,"All"]
      ],
      "oLanguage": {
        "sSearch": "Search: ",
        "sLengthMenu": "Show _MENU_ ",
      },
      "columnDefs": [
      { "orderable": false, "targets": [4,7]},
      // { "visible": false, "targets": [5]}
      ],
      
      sDom: '<"text-right mb-md"T><"row"<"col-lg-6"l><"col-lg-6"f>><"table-responsive"t>p',
      buttons: [ 
            {
              extend:'print',
              text: 'Print',
              exportOptions: {
                          columns: '0,2,3,5,6'
                      }
            },
            {
              extend:'excel',
              text: 'Exel',
              exportOptions: {
                          columns: '0,2,3,5,6'
                      }
            },
            {
              extend:'pdf',
              text: 'PDF',
              exportOptions: {
                          columns: '0,2,3,5,6'
                      }
            },
          ]
    });
    $('<div />').addClass('dt-buttons mb-2 pb-1 ').prependTo('#datatable-tabletools_wrapper');
        $('#datatable-tabletools_filter').addClass('');
        $table.DataTable().buttons().container().prependTo( '#datatable-tabletools_wrapper .dt-buttons' );
        // $('#datatable-tabletools_wrapper').find('.btn-secondary').removeClass('btn-secondary').addClass('btn-default');
      });


  $(document).ready(function() {
    $('.fiter-date-from').datepicker({
        
        todayHighlight: true,
        format:"dd-mm-yyyy",
        autoclose: true,
        endDate: '+0d',
      }).on('changeDate', function (selected) {
          
      });
      $('.fiter-date-to').datepicker({
        
        todayHighlight: true,
        format:"dd-mm-yyyy",
        autoclose: true,
        endDate: '+0d',
      }).on('changeDate', function (selected) {
          
      });



      
  });
  </script>
</body>
</html>
