<?php

	$root=".";
	require($root . "/php/init.php");


use ReCaptcha\ReCaptcha;
use Classes\Cookie;
use Illuminate\Database\Capsule\Manager as DB;

if (conf("App.active_recaptcha")) {
  $reCaptcha =new ReCaptcha(conf("App.recaptcha_secret"));
}


$hash= new Classes\Hash;
$rq = new Classes\Request;


$reset_page=false;

  if (isset($_POST['reset_password'])&&$tk->passes()) {

  	$username = $rq->input('username');

    $v->validate([
      tr("Username")=>[$username,"required"],
     
    ]);

    if (conf("App.active_recaptcha")) {
    	$v->validate([

      tr("recaptcha")      => [$rq->input('g-recaptcha-response'),"required"]
    ]);
    }

    if ($v->passes() && conf("App.active_recaptcha")) {
		$recaptcha = new ReCaptcha(conf("App.recaptcha_secret"));
		$resp = $recaptcha->setExpectedHostname($_SERVER['SERVER_NAME'])
              ->verify($rq->input('g-recaptcha-response'), $_SERVER['REMOTE_ADDR']);
        $recaptcha_status = $resp->isSuccess();

        if (!$recaptcha_status) {
        	$display->error(tr("Invalid recaptcha."));
        }
    }

    if ($v->passes()) {
      $data = $db->query("SELECT * FROM users WHERE (email=? OR phone=?) AND deleted_01=0 AND active_01=1 LIMIT 1",[$username,$username]);

      if (count($data)) {

        $reset_password_token = $tk->generateString(70);

        if (is_numeric($username) && strlen(conf("sms.username"))>3) {
        	$reset_password_token = $tk->generateString(7);
        }

        DB::update("UPDATE users SET reset_password_token=? WHERE id= ?",[$hash->password($reset_password_token),$data[0]['id']]);

        if (is_numeric($username) && strlen(conf("sms.username"))>3) {
        	$sms = tr("Reset password")."\n | ".$app_url."/resetpassword.php?t=".$reset_password_token;
        	sms_q($sms,$username);
        	$display->add_success(tr("We have sent an SMS to ").$username).".";
        }else{
        	$email=new Emailer;
        	$email->to($username);
	        $email->template("reset_password_en");
	        $email->app_name   = conf("App.name");
	        $email->user_email = $username;
	        $email->reset_url  = $app_url."/resetpassword.php?t=".$reset_password_token;
	        $email->title      = tr("Reset passowrd");
	        $email->send();
	        $display->success(tr("We have sent an email to ").$username).".";
        }
       
       $_POST=[];

      }else{
        $display->add_error(tr("We cant find an account with this email or phone ").$username);
      }
    }
  }


  if (isset($_GET['t']) && !empty($_GET['t'])) {

    $users_list=$db->query("SELECT * FROM users WHERE  deleted_01=0 AND active_01=1 AND  reset_password_token!=''");
    
    foreach ($users_list as $key => $us) {
      
      if ( $hash->password_check($_GET['t'],$us['reset_password_token'])) {

        $user_data=$us;

        $reset_page=true;

        if (isset($_POST['new_password'])) {

          $v->validate([
            tr("Password")=>[$rq->input('password'),'required|min(6)'],
            tr("Password agian")=>[$rq->input('cpassword'),'required|matches('.tr('Password').')']
          ]);

          if ($v->passes() && $tk->passes()) {
            DB::update(
              "UPDATE users SET password =? WHERE id =? ",
              [
                $hash->password($_POST['password']),
                $us['id']
              ]
            );

			$remember_token =$tk->generateString(120);
			$remember_id    =$tk->generateString(120);

			if (Cookie::get(conf("auth.remember"))) {
				Cookie::unset(conf("auth.remember"));
				DB::update("UPDATE user_remember SET status='Deleted' WHERE user_id = ?",[$us['id']]);
			}

			DB::table("user_remember")->insert(
				[
					"user_id"=>$us['id'],
					"remember_token"=>$hash->password($remember_token),
					"remember_id"=>$remember_id,
				]
			); 

			Cookie::set(
				conf("auth.remember"), 
				$remember_id."___".$remember_token, 
				conf("auth.remember_days"), 
			);

			DB::update("UPDATE users SET reset_password_token='' WHERE id = ?",[$us['id']]);


            $redirect->to($app_url);
          }
        }
      }
    }
  }

  $display->error($v->errors()->all());


?>
<!DOCTYPE html>
<html <?= $local ?>>
<?php require($root . "/inc/head.php") ?>

<style>
	.login-cover {
	    background: url(<?= $root ?>/assets2/images/backgrounds/user_bg1.png) no-repeat;
	    background-size: cover;
	}
</style>
<body style="position: inherit;">

	<!-- Page content -->
	<div class="page-content login-cover">

		<!-- Main content -->
		<div class="content-wrapper">

			<!-- Content area -->
			<div class="content d-flex justify-content-center align-items-center">

				<!-- Login form -->
				<form class="login-form wmin-sm-400" action="<?= $this_url ?>" method="post" autocomplete="off">
					<?php $display->display_messages() ?>
					<div class="card mb-0">
					

						<div class=" card-body">
							<div class="tab-pane fade show active" id="login-tab1">
								<div class="text-center mb-3">
							
										
									<h4 class="mb-0"><?= tr("Reset password") ?></h4>
									<!-- <span class="d-block text-muted">Your credentials</span> -->
								</div>

								<?php if (!$reset_page): ?>
									<div class="form-group form-group-feedback form-group-feedback-left">
										<input type="text" class="form-control" name="username" value="<?= old('username') ?>" placeholder="Phone or Email">
										<div class="form-control-feedback">
											<i class="icon-user text-muted"></i>
										</div>
									</div>
											<?php if (conf("App.active_recaptcha")): ?>
									<p>
										 <div class="g-recaptcha form-field" style="width: 100%" data-sitekey="<?= conf("App.recaptcha_site") ?>"></div>
									</p>
			                       <br>

			                       		<div class="form-group">
									
								</div>
			                      <?php endif ?>

			                      <button type="submit" name="reset_password" class="btn btn-primary btn-block"><?= tr("Submit") ?></button><br>
			                    <?php else: ?>
			                    	<div class="form-group form-group-feedback form-group-feedback-left input-group">

										<input type="password" class="form-control" placeholder="<?= tr("New password") ?>" name="password" id="password">
										<div class="form-control-feedback">
											<i class="icon-lock2 text-muted"></i>
										</div>

										<span class="input-group-prepend" onclick="$('#password').attr('type')=='password'?$('#password').attr('type','text'):$('#password').attr('type','password');">
											<span class="input-group-text"><i class="icon-eye "></i></span>
										</span>
									</div>
									<div class="form-group form-group-feedback form-group-feedback-left input-group">
										<input type="password" class="form-control" placeholder="<?= tr("Password again") ?>" name="cpassword" id="cpassword">
										<div class="form-control-feedback">
											<i class="icon-lock2 text-muted"></i>
										</div>
											<span class="input-group-prepend" onclick="$('#cpassword').attr('type')=='password'?$('#cpassword').attr('type','text'):$('#cpassword').attr('type','password');">
											<span class="input-group-text"><i class="icon-eye "></i></span>
										</span>
									</div>


											<div class="form-group">
									<button type="submit" name="new_password" class="btn btn-primary btn-block"><?= tr("Submit") ?></button>
								</div>
								<?php endif ?>

								



				




						

							

						


								<p class="text-center">
									<a href="<?= $app_url ?>"><?= tr("Sign In") ?></a>
								</p>
								<br>
								

						

						

					



							</div>

						
						</div>
					</div>
				</form>
				<!-- /login form -->

			</div>
			<!-- /content area -->

		</div>
		<!-- /main content -->

	</div>
	<!-- /page content -->
	<?php require($root . "/inc/scripts.php") ?>
	<?php if (conf("App.active_recaptcha")): ?>
    <script type="text/javascript" src="https://www.google.com/recaptcha/api.js?hl=<?= $ml->lang ?>"></script>
  <?php endif ?>

</body>
</html>