<?php 
$v = new Classes\Validator;
if (isset($_POST['new_role'])) {
	
	$name        =isset($_POST['name'])?$_POST['name']:"";
	$description =isset($_POST['name'])?$_POST['name']:"";
	$roles =isset($_POST['roles'])?$_POST['roles']:[];


	$v->validate([
		tr("name")=>[$name,"required|unique_table(roles,name)"],
	]);

	if (!is_array($roles)) {
		$roles=[];
	}



	if ($tk->passes() && $v->passes()) {
		$db->query("INSERT INTO roles(name,description,roles,created_by) VALUES(?,?,?,?)",[$name,$description, json_encode($roles),auth()->id]);

		$display->success(tr("Role added successfully."));
	}
}

if (isset($_POST['save_role'])) {
	
	$name        =isset($_POST['name'])?$_POST['name']:"";
	$description =isset($_POST['name'])?$_POST['name']:"";
	$roles =isset($_POST['roles'])?$_POST['roles']:[];
	$id=isset($_POST['id'])?$_POST['id']:"";



	$v->validate([
		tr("name")=>[$name,"required|unique_table(roles,name,".$id.")"],
		"ID"=>[$id,"required|number"],
	]);

	if (!is_array($roles)) {
		$roles=[];
	}



	if ($tk->passes() && $v->passes()) {


		$db->query("UPDATE  roles SET name=?,description=?,roles=?,updated_by=? WHERE id= ?",[$name,$description, json_encode($roles),auth()->id,$id]);

		$display->success(tr("Role updated successfully."));
	}
}


if (isset($_POST['delete_role'])) {
	$id=isset($_POST['id'])?$_POST['id']:"";



	$v->validate([
		"ID"=>[$id,"required|number"],
	]);

	if ($tk->passes() && $v->passes()) {

		$check=$db->single("SELECT count(*) FROM users WHERE role_id = ? ",[$id]);

		if ($check==0) {
			$db->query("DELETE FROM roles  WHERE id= ?",[$id]);

			$display->success(tr("Role deleted successfully."));
		}else{
			$display->success(tr("Role already asigned to users."));
		}
	}
}


$display->error($v->errors()->all());


$view = isset($_GET['v'])?$_GET['v']:'index';


switch ($view) {
	case 'new':
		$page_nav=[
			"back"=>$app_url."/roles",
			"breadcrumb"=>[
				tr("Roles")=>$app_url."/roles",
				tr("New")=>"",
			],
		];
		$page_view = "views/new.php";
	break;

	case 'edit':
		$page_nav=[
			"back"=>$app_url."/roles",
			"breadcrumb"=>[
				tr("Roles")=>$app_url."/roles",
				tr("Edit")=>"",
			],
		];


		if (isset($_GET['i']) && is_numeric($_GET['i'])) {
			$role = $db->row("SELECT * FROM roles WHERE id = ? ",[$_GET['i']]);

			if (!$role) {
				$redirect->to(404);
			}
		}


		$page_view = "views/edit.php";
	break;
	
	default:
		$page_nav=[
			"reload"=>1,
			"breadcrumb"=>[
				tr("Roles")=>$app_url."/roles",
			],
		];

		$roles = $db->query("SELECT * FROM roles");

		$page_view = "views/index.php";
	break;
}