
		<div class="card">
			<div class="card-header d-flex justify-content-between">
				<h3><?= tr("Roles") ?></h3>
				<div class="text-end">
					<a href="<?= add_to_url($this_url,"v","new") ?>" class="btn btn-primary rounded-pill"><?= tr("New role") ?></a>
				</div>
			</div>
			<table class="table" id="datatable-tabletools">
				<thead>
					<tr>
						<th>#</th>
						<th><?= tr("Name") ?></th>
						<th class="text-center"><?= tr("Action") ?></th>
					</tr>
				</thead>
				<tbody>
					<?php foreach ($roles as $key => $role): ?>
						<tr>
							<td><?= $role['id'] ?></td>
							<td><?= tr($role['name']) ?></td>
							<td class="text-center">
								<a href="<?= add_to_url($this_url,["v","i"],["edit",$role['id']]) ?>" class="btn btn-sm btn-outline-secondary"><?= tr("Edit") ?></a>
								<button type="button" onclick="$('#role-id').val(<?= $role['id'] ?>)" data-toggle="modal" data-target="#delete-modal"  class="btn btn-sm btn-outline-secondary"><?= tr("Delete") ?></button>
							</td>

						</tr>
					<?php endforeach ?>
				</tbody>
			</table>
		</div>

<form method="post">
<div class="modal fade" id="delete-modal" tabindex="-1" role="dialog" aria-labelledby="delete-modalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="delete-modalLabel"><?= tr("Are you sure?") ?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <?= tr("This modal will be deleted.") ?>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?= tr("Cancel") ?></button>
        <button class="btn btn-primary"><?= tr("Yes") ?></button>
      </div>
    </div>
  </div>
</div>
<input type="hidden" name="id" value="0" id="role-id">
<input type="hidden" name="delete_role" value="1" >
</form>

<script>

		$(document).ready(function() {
				var $table = $('#datatable-tabletools');

				 table = $table.dataTable({
				 	
        
			    language: {
		              search: '<span></span> _INPUT_',
		              searchPlaceholder: '<?= tr("Search") ?>',
		              lengthMenu: '<span><?= tr("Show") ?>:</span> _MENU_',
		              paginate: { 'first': '<?= tr("First") ?>', 'last': '<?= tr("Last") ?>', 'next': '<?= tr("Next") ?>', 'previous': '<?= tr("Previous") ?>' }
		          },
    
					"lengthMenu": [
			          [25, 100, 500,1000],
			          [25, 100, 500,1000]
			        ],
			        "order": [[ 0, "desc" ]],
		
					"columnDefs": [
					    { "orderable": false, "targets": [2]},
					 
					],
					// stateSave: true,
			        // processing: true,
			        // serverSide: true,
		
					
					// sDom: '<"text-right mb-md"T><"row"<"col-lg-6"l><"col-lg-6"f>><"table-responsive"t>p',
					dom: '<"datatable-header"fBl><"datatable-scroll-wrap"t><"datatable-footer"ip>',
					responsive: true,
					 autoWidth: false,
					 buttons: {
          dom: {
              button: {
                  className: 'btn btn-light border'
		              }
		          },
		          buttons: [
		    
		         

		          ],
		      },

					
				});

			
				 $('#datatable-tabletools_length').attr({
				 	"dir": 'ltr',
			
				 });;

				 $('<div />').addClass('dt-buttons mb-2 pb-1 text-start').prependTo('#datatable-tabletools_wrapper');



		
				$table.DataTable().buttons().container().prependTo( '#datatable-tabletools_wrapper ' ).addClass('text-right m-2 mx-3');
				


				
			});

</script>