<?php 
	$banners_2=$db->single("SELECT banners_2 FROM website_settings ");
	$banners_2=is_json($banners_2)?json_decode($banners_2):[];

 ?>
		<div class="col-lg-12">

			<div class="card">
				<div class="card-header">
					<h5><?= tr("Banners") ?> #2  </h5>
				</div>
				<table class="table table-sm" id="banners_2-table">
					<thead>
						<tr>
							<td></td>
						<th>
							<?= tr("Image") ?>
						</th>

						<th><?= tr("Url") ?></th>
						<th><?= tr("Language") ?></th>
						<th></th>
					</tr>
					</thead>
					<tbody>
						<?php $in=0; foreach ($banners_2 as $key => $item): ?>
							<tr data-index="<?= $in ?>">
								<td></td>
								<td><img src="<?= file_get($item->file) ?>" height="50px" alt=""></td>

								<td><?= $item->url ?></td>
								<td><?= $item->lang ?></td>
								
								<td>
									<form method="post">
										<button 
										class="btn btn-sm btn-danger" name="delete_banners_2"><?= tr("Delete") ?></button>
										<input type="hidden" name="index" value="<?= $in++ ?>">
									</form>
								
								</td>
							</tr>
						<?php endforeach ?>
					</tbody>
					<tfoot>
						<tr>
							<td></td>
							<td><button 
						
								class="btn btn-light btn-sm" 
								type="button" data-toggle="modal" data-target="#new_banners_2-modal"><?= tr("Add new") ?></button></td>
							<td></td>
							<td></td>
							<td></td>
			
						</tr>
					</tfoot>
				</table>

				

				<div class="card-body">
					<form method="post">
						<input dir="ltr" type="hidden" name="banners_2_order" id="banners_2-order" value="">
						<button name="save_banners_2_order" class="btn btn-primary"><?= tr("Save") ?></button>
					</form>
					
				</div>



			
			</div>


	</div>


<form method="post" enctype="multipart/form-data">
	<div class="modal fade" id="new_banners_2-modal" tabindex="-1" role="dialog" aria-labelledby="new_banners_2-modalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="new_banners_2-modalLabel"><?= tr("New") ?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
     
        <label for=""><?= tr("Url") ?></label>
        <input type="text" class="form-control" name="url" value="<?= old("url") ?>"><br>

        <label for=""><?= tr("Language") ?></label>
        <select name="lang" class="form-control">
        	<option <?= old("lang")=="ar"?'selected':'' ?> value="ar"><?= tr("Arabic") ?></option>
        	<option <?= old("lang")=="en"?'selected':'' ?> value="en"><?= tr("English") ?></option>
        </select><br>

        <label for=""><?= tr("Image") ?></label>
        <?= file_input() ?>
        <small dir="ltr">1140x300</small>

        <br>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?= tr("Close") ?></button>
        <button name="new_banners_2" class="btn btn-primary"><?= tr("Submit") ?></button>
      </div>
    </div>
  </div>
</div>
</form>


<script>
	$(document).ready(function() {

	

		$('#banners_2-table tbody').sortable({
			axis: 'y',
			update:  function (event, ui) {

	         	$("#banners_2-order").val(JSON.stringify($('#banners_2-table tbody').sortable("toArray",{attribute: 'data-index'})))


	        }
		})

			$("#banners_2-order").val(JSON.stringify($('#banners_2-table tbody').sortable("toArray",{attribute: 'data-index'})))
	});
</script>