<?php 
	$carousel=$db->single("SELECT carousel FROM website_settings ");
	$carousel=is_json($carousel)?json_decode($carousel):[];

 ?>
		<div class="col-lg-12">

			<div class="card">
				<div class="card-header">
					<h5><?= tr("Carousel") ?></h5>
				</div>
			<div class="table-responsive">
					<table class="table table-sm" id="carousel-table">
					<thead>
						<tr>
							<td></td>
						<th>
							<?= tr("Image") ?>
						</th>
						<th><?= tr("Title") ?></th>
						<th><?= tr("Subtitle") ?></th>
						<th><?= tr("Url") ?></th>
						<th><?= tr("Language") ?></th>
						<th></th>
					</tr>
					</thead>
					<tbody>
						<?php $in=0; foreach ($carousel as $key => $item): ?>
							<tr data-index="<?= $in ?>">
								<td></td>
								<td><img src="<?= file_get($item->file) ?>" height="50px" alt=""></td>
								<td><?= $item->title ?></td>
								<td><?= $item->subtitle ?></td>
								<td><?= $item->url ?></td>
								<td><?= $item->lang ?></td>
								
								<td>
									<form method="post">
										<button 
										class="btn btn-sm btn-danger" name="delete_carousel"><?= tr("Delete") ?></button>
										<input type="hidden" name="index" value="<?= $in++ ?>">
									</form>
								
								</td>
							</tr>
						<?php endforeach ?>
					</tbody>
					<tfoot>
						<tr>
							<td></td>
							<td><button 
						
								class="btn btn-light btn-sm" 
								type="button" data-toggle="modal" data-target="#new_carouel-modal"><?= tr("Add new") ?></button></td>
							<td></td>
							<td></td>
							<td></td>
							<td></td>
							<td></td>
						</tr>
					</tfoot>
				</table>

			</div>
				

				<div class="card-body">
					<form method="post">
						<input dir="ltr" type="hidden" name="carousel_order" id="carousel-order" value="">
						<button name="save_carousel_order" class="btn btn-primary"><?= tr("Save") ?></button>
					</form>
					
				</div>



			
			</div>


	</div>


<form method="post" enctype="multipart/form-data">
	<div class="modal fade" id="new_carouel-modal" tabindex="-1" role="dialog" aria-labelledby="new_carouel-modalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="new_carouel-modalLabel"><?= tr("New") ?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <label for=""><?= tr("Title") ?></label>
        <input type="text" class="form-control" name="title" value="<?= old("title") ?>"><br>

        <label for=""><?= tr("Subtitle") ?></label>
        <input type="text" class="form-control" name="subtitle" value="<?= old("subtitle") ?>"><br>

        <label for=""><?= tr("Url") ?></label>
        <input type="text" class="form-control" name="url" value="<?= old("url") ?>"><br>

         <label for=""><?= tr("Language") ?></label>
        <select name="lang" class="form-control">
        	<option <?= old("lang")=="ar"?'selected':'' ?> value="ar"><?= tr("Arabic") ?></option>
        	<option <?= old("lang")=="en"?'selected':'' ?> value="en"><?= tr("English") ?></option>
        </select><br>

        <label for=""><?= tr("Image") ?></label>
        <?= file_input() ?>
        <small dir="ltr">1920x500</small>

        <br>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?= tr("Close") ?></button>
        <button name="new_carousel" class="btn btn-primary"><?= tr("Submit") ?></button>
      </div>
    </div>
  </div>
</div>
</form>


<script>
	$(document).ready(function() {

	

		$('#carousel-table tbody').sortable({
			axis: 'y',
			update:  function (event, ui) {

	         	$("#carousel-order").val(JSON.stringify($('#carousel-table tbody').sortable("toArray",{attribute: 'data-index'})))


	        }
		})

			$("#carousel-order").val(JSON.stringify($('#carousel-table tbody').sortable("toArray",{attribute: 'data-index'})))
	});
</script>