<?php 
  $currencies = $db->query("SELECT * FROM currencies");

 ?>
<div  class="col-md-6">
  <h5><?= tr("Currency") ?></h5>
  <button class="btn btn-primary" data-toggle="modal" data-target="#new-currency-modal"><?= tr("New") ?></button>
  <table class="table">
    <thead>
      <tr>
        <td></td>
        <td></td>
        <td></td>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($currencies as $key => $currency): ?>
        <tr>
          <td><?= $currency['code'] ?></td>
          <td><?= pname($currency['name'],$currency['name_en']) ?></td>
          <td><?= pname($currency['prefix'],$currency['prefix_en']) ?></td>
          <td><?= pname($currency['suffix'],$currency['suffix_en']) ?></td>
          <td><?= $currency['rate'] ?></td>
          <td><button data-toggle="modal" data-target="#edit-<?= $currency['id'] ?>-currency-modal" class="btn btn-sm btn-light"><?= tr("Edit") ?></button><button data-toggle="modal" data-target="#delete-<?= $currency['id'] ?>-currency-modal" class="btn btn-sm btn-light"><?= tr("delete") ?></button></td>
        </tr> 
      <?php endforeach ?>
    </tbody>
  </table>
</div>

<div class="modal" id="new-currency-modal" tabindex="-1" role="dialog" aria-labelledby="new-currency-modalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="new-currency-modalLabel">New currency</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form method="post">
          <label for=""><?= tr("Code") ?></label>
        <input type="text" name="code" value="<?= old("code") ?>" class="form-control"><br>
                  <label for=""><?= tr("Name") ?></label>
        <input type="text" name="name" value="<?= old("name") ?>" class="form-control"><br>

        <label for=""><?= tr("Name") ?> en</label>
        <input type="text" name="name_en" value="<?= old("name_en") ?>" class="form-control"><br>

        <label for=""><?= tr("Rate") ?></label>
        <input type="text" name="rate" value="<?= old("rate") ?>" class="form-control"><br>

        <label for=""><?= tr("Prefix") ?></label>
        <input type="text" name="prefix" value="<?= old("prefix") ?>" class="form-control"><br>

        <label for=""><?= tr("Suffix") ?></label>
        <input type="text" name="suffix" value="<?= old("suffix") ?>" class="form-control"><br>

        <label for=""><?= tr("Prefix") ?> en</label>
        <input type="text" name="prefix_en" value="<?= old("prefix_en") ?>" class="form-control"><br>

        <label for=""><?= tr("Suffix") ?> en</label>
        <input type="text" name="suffix_en" value="<?= old("suffix_en") ?>" class="form-control"><br>



        <button name="new_currency" class="btn btn-primary"><?= tr("Submit") ?></button>
        </form>
      </div>
    </div>
  </div>
</div>


<?php foreach ($currencies as $key => $currency): ?>
  <div class="modal" id="edit-<?= $currency['id'] ?>-currency-modal" tabindex="-1" role="dialog" aria-labelledby="edit-<?= $currency['id'] ?>-currency-modalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="edit-<?= $currency['id'] ?>-currency-modalLabel">Edit currency</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
    <form method="post">
      <label for=""><?= tr("Code") ?></label>
        <input type="text" name="code" value="<?= $currency['code'] ?>" class="form-control"><br>
             <label for=""><?= tr("Name") ?></label>
        <input type="text" name="name" value="<?= $currency['name'] ?>" class="form-control"><br>

        <label for=""><?= tr("Name") ?> en</label>
        <input type="text" name="name_en" value="<?= $currency['name_en'] ?>" class="form-control"><br>

        <label for=""><?= tr("Rate") ?></label>
        <input type="text" name="rate" value="<?= $currency['rate'] ?>" class="form-control"><br>

        <label for=""><?= tr("Prefix") ?></label>
        <input type="text" name="prefix" value="<?= $currency['prefix'] ?>" class="form-control"><br>

        <label for=""><?= tr("Suffix") ?></label>
        <input type="text" name="suffix" value="<?= $currency['suffix'] ?>" class="form-control"><br>

        <label for=""><?= tr("Prefix") ?> en</label>
        <input type="text" name="prefix_en" value="<?= $currency['prefix_en'] ?>" class="form-control"><br>

        <label for=""><?= tr("Suffix") ?> en</label>
        <input type="text" name="suffix_en" value="<?= $currency['suffix_en'] ?>" class="form-control"><br>


        <input type="hidden" name="id" value="<?= $currency['id'] ?>">
        <button name="edit_currency" class="btn btn-primary"><?= tr("Save") ?></button>
    </form>
      </div>
    </div>
  </div>
</div>


  <div class="modal" id="delete-<?= $currency['id'] ?>-currency-modal" tabindex="-1" role="dialog" aria-labelledby="delete-<?= $currency['id'] ?>-currency-modalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="delete-<?= $currency['id'] ?>-currency-modalLabel"><?= tr("Are you sure") ?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
    <form method="post">



        <input type="hidden" name="id" value="<?= $currency['id'] ?>">
        <button name="delete_currency" class="btn btn-primary"><?= tr("Yes") ?></button>
    </form>
      </div>
    </div>
  </div>
</div>
<?php endforeach ?>