<?php 
  $shipping = $db->query("SELECT * FROM shipping_methods WHERE deleted_01 = 0");

 ?>
<div  class="col-md-6">
  <h5><?= tr("Shipping") ?></h5>
  <button class="btn btn-primary" data-toggle="modal" data-target="#new-ship-modal"><?= tr("New") ?></button>
  <table class="table">
    <thead>
      <tr>
        <td><?= tr("Name") ?></td>
        <td><?= tr("Price") ?></td>
        <td><?= tr("Free on above") ?></td>
        <td></td>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($shipping as $key => $ship): ?>
        <tr>

          <td><?= pname($ship['name'],$ship['name_en']) ?></td>
          <td><?= amount($ship['price']) ?></td>
          <td><?= amount($ship['free']) ?></td>

          <td><button data-toggle="modal" data-target="#edit-<?= $ship['id'] ?>-ship-modal" class="btn btn-sm btn-light"><?= tr("Edit") ?></button><button class="btn btn-sm btn-light" data-toggle="modal" data-target="#delete-<?= $ship['id'] ?>-ship-modal"><?= tr("delete") ?></button></td>
        </tr> 
      <?php endforeach ?>
    </tbody>
  </table>
</div>

<div class="modal" id="new-ship-modal" tabindex="-1" role="dialog" aria-labelledby="new-ship-modalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="new-ship-modalLabel">New ship</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form method="post" autocomplete="off">

        <label for=""><?= tr("Name") ?></label>
        <input type="text" name="name" value="<?= old("name") ?>" class="form-control"><br>

        <label for=""><?= tr("Name") ?> en</label>
        <input type="text" name="name_en" value="<?= old("name_en") ?>" class="form-control"><br>

        <label for=""><?= tr("Price") ?></label>
        <input type="number" name="price" min="0" step="0.001" value="<?= old("price") ?>" class="form-control"><br>

        <label for=""><?= tr("Free on above") ?></label>
        <input type="number" name="free" min="0" step="0.001" value="<?= old("free") ?>" class="form-control"><br>

        <label for=""><?= tr("City") ?></label>
        <select name="city[]" multiple="multiple" class="form-control">
        
        <?php foreach ($db->query("SELECT * FROM tb_region") as $key => $reg): ?>
             <optgroup label="<?= pname($reg['name_ar'],$reg['name_en']) ?>">
              <?php foreach ($db->query("SELECT * FROM tb_wallayat WHERE reg_id = ? ",[$reg['id']]) as $key => $city): ?>
                <option value="<?= $city['id'] ?>"><?= pname($city['name_ar'],$city['name_en']) ?></option>
              <?php endforeach ?>
              </optgroup>
          <?php endforeach ?>
        </select>


          <label for=""><?= tr("Note") ?></label>
          <textarea name="note" class="form-control" cols="30" rows="3"><?= old("note") ?></textarea>
 

          <label for=""><?= tr("Note") ?> en</label>
          <textarea name="note_en" class="form-control" cols="30" rows="3"><?= old("note_en") ?></textarea>

     


          <button name="new_ship" class="btn btn-primary"><?= tr("Submit") ?></button>
        </form>
      </div>
    </div>
  </div>
</div>


<?php foreach ($shipping as $key => $ship): ?>
  <div class="modal" id="edit-<?= $ship['id'] ?>-ship-modal" tabindex="-1" role="dialog" aria-labelledby="edit-<?= $ship['id'] ?>-ship-modalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="edit-<?= $ship['id'] ?>-ship-modalLabel">Edit ship</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
    <form method="post" autocomplete="off">


  



             <label for=""><?= tr("Name") ?></label>
        <input type="text" name="name" value="<?= $ship['name'] ?>" class="form-control"><br>

        <label for=""><?= tr("Name") ?> en</label>
        <input type="text" name="name_en" value="<?= $ship['name_en'] ?>" class="form-control"><br>

                <label for=""><?= tr("Price") ?></label>
        <input type="number" name="price" min="0" step="0.001" value="<?= $ship['price'] ?>" class="form-control"><br>

        <label for=""><?= tr("Free on above") ?></label>
        <input type="number" name="free" min="0" step="0.001" value="<?= $ship['free'] ?>" class="form-control"><br>

                <label for=""><?= tr("City") ?></label>
        <select name="city[]" multiple="multiple" class="form-control">
        
        <?php foreach ($db->query("SELECT * FROM tb_region") as $key => $reg): ?>
             <optgroup label="<?= pname($reg['name_ar'],$reg['name_en']) ?>">
              <?php foreach ($db->query("SELECT * FROM tb_wallayat WHERE reg_id = ? ",[$reg['id']]) as $key => $city): ?>
                <option <?= is_json($ship['city'])?(in_array($city['id'], json_decode($ship['city']))?'selected':''):'' ?> value="<?= $city['id'] ?>"><?= pname($city['name_ar'],$city['name_en']) ?></option>
              <?php endforeach ?>
              </optgroup>
          <?php endforeach ?>
        </select>


        <label for=""><?= tr("Note") ?></label>
        <textarea name="note" class="form-control" cols="30" rows="3"><?= $ship['note'] ?></textarea>
 

        <label for=""><?= tr("Note") ?> en</label>
        <textarea name="note_en" class="form-control" cols="30" rows="3"><?= $ship['note_en'] ?></textarea>

    


        <input type="hidden" name="id" value="<?= $ship['id'] ?>">
        <button name="edit_ship" class="btn btn-primary"><?= tr("Save") ?></button>
    </form>
      </div>
    </div>
  </div>
</div>


  <div class="modal" id="delete-<?= $ship['id'] ?>-ship-modal" tabindex="-1" role="dialog" aria-labelledby="delete-<?= $ship['id'] ?>-ship-modalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="delete-<?= $ship['id'] ?>-ship-modalLabel"><?= tr("Are you sure") ?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
    <form method="post">



        <input type="hidden" name="id" value="<?= $ship['id'] ?>">
        <button name="delete_ship" class="btn btn-primary"><?= tr("Yes") ?></button>
    </form>
      </div>
    </div>
  </div>
</div>
<?php endforeach ?>