<?php 
	$shopping_info=$db->single("SELECT shopping_info FROM website_settings ");
	$shopping_info=is_json($shopping_info)?json_decode($shopping_info):[];

 ?>
		<div class="col-lg-12">

			<div class="card">
				<div class="card-header">
					<h5><?= tr("Shopping info") ?></h5>
				</div>
				<table class="table table-sm" id="shopping_info-table">
					<thead>
						<tr>
							<td></td>
						<th>
							<?= tr("Icon") ?>
						</th>
						<th><?= tr("Title") ?></th>
						<th><?= tr("Subtitle") ?></th>
						<th><?= tr("Language") ?></th>
				
						<th></th>
					</tr>
					</thead>
					<tbody>
						<?php $in=0; foreach ($shopping_info as $key => $item): ?>
							<tr data-index="<?= $in ?>">
								<td></td>
								<td><i class="<?= $item->icon ?>"></i></td>
								<td><?= $item->title ?></td>
								<td><?= $item->subtitle ?></td>
								<td><?= $item->lang ?></td>
					
								
								<td>
									<form method="post">
										<button 
										class="btn btn-sm btn-danger" name="delete_shopping_info"><?= tr("Delete") ?></button>
										<input type="hidden" name="index" value="<?= $in++ ?>">
									</form>
								
								</td>
							</tr>
						<?php endforeach ?>
					</tbody>
					<tfoot>
						<tr>
							<td></td>
							<td><button 
						
								class="btn btn-light btn-sm" 
								type="button" data-toggle="modal" data-target="#new_shopping_info-modal"><?= tr("Add new") ?></button></td>
				
							<td></td>
							<td></td>
				
							<td></td>
							<td></td>
						</tr>
					</tfoot>
				</table>

				

				<div class="card-body">
					<form method="post">
						<input dir="ltr" type="hidden" name="shopping_info_order" id="shopping_info-order" value="">
						<button name="save_shopping_info_order" class="btn btn-primary"><?= tr("Save") ?></button>
					</form>
					
				</div>



			
			</div>


	</div>


<form method="post" enctype="multipart/form-data">
	<div class="modal fade" id="new_shopping_info-modal" tabindex="-1" role="dialog" aria-labelledby="new_shopping_info-modalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="new_shopping_info-modalLabel"><?= tr("New") ?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <label for=""><?= tr("Title") ?></label>
        <input type="text" class="form-control" name="title" value="<?= old("title") ?>"><br>


        <label for=""><?= tr("Subtitle") ?></label>
        <input type="text" class="form-control" name="subtitle" value="<?= old("subtitle") ?>"><br>


  		<label for=""><?= tr("Language") ?></label>
        <select name="lang" class="form-control">
        	<option <?= old("lang")=="ar"?'selected':'' ?> value="ar"><?= tr("Arabic") ?></option>
        	<option <?= old("lang")=="en"?'selected':'' ?> value="en"><?= tr("English") ?></option>
        </select><br>


        <label for=""><?= tr("Icon") ?></label>
        <input type="text" class="form-control" name="icon" value="<?= old("icon") ?>"><br>

        <br>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?= tr("Close") ?></button>
        <button name="new_shopping_info" class="btn btn-primary"><?= tr("Submit") ?></button>
      </div>
    </div>
  </div>
</div>
</form>


<script>
	$(document).ready(function() {

	

		$('#shopping_info-table tbody').sortable({
			axis: 'y',
			update:  function (event, ui) {

	         	$("#shopping_info-order").val(JSON.stringify($('#shopping_info-table tbody').sortable("toArray",{attribute: 'data-index'})))


	        }
		})

			$("#shopping_info-order").val(JSON.stringify($('#shopping_info-table tbody').sortable("toArray",{attribute: 'data-index'})))
	});
</script>