<?php 
	$top_products=$db->single("SELECT top_products FROM website_settings ");
	$top_products=is_json($top_products)?json_decode($top_products):[];

 ?>
		<div class="col-lg-12">

			<div class="card">
				<div class="card-header">
					<h5><?= tr("Top products") ?></h5>
				</div>
				<table class="table table-sm" id="top_products-table">
					<thead>
						<tr>
							<td></td>
						<th>
							<?= tr("Item") ?>
						</th>
						<th><?= tr("Brand") ?></th>

				
						<th></th>
					</tr>
					</thead>
					<tbody>
						<?php $in=0; foreach ($top_products as $key => $item): ?>
						<?php $this_item = $db->row("SELECT p.name as item, b.name as brand FROM products p LEFT JOIN brands b ON b.id = p.brand_id WHERE p.id = ? ",[$item]) ?>
							<tr data-index="<?= $in ?>">
								<td></td>
								<td><?= $this_item['item'] ?></td>
								<td><?= $this_item['brand'] ?></td>
				

					
								
								<td>
									<form method="post">
										<button 
										class="btn btn-sm btn-danger" name="delete_top_products"><?= tr("Delete") ?></button>
										<input type="hidden" name="index" value="<?= $in++ ?>">
									</form>
								
								</td>
							</tr>
						<?php endforeach ?>
					</tbody>
					<tfoot>
						<tr>
							<td></td>
							<td><button 
						
								class="btn btn-light btn-sm" 
								type="button" data-toggle="modal" data-target="#new_top_products-modal"><?= tr("Add new") ?></button></td>
				
							<td></td>
				
							<td></td>
						</tr>
					</tfoot>
				</table>

				

				<div class="card-body">
					<form method="post">
						<input dir="ltr" type="hidden" name="top_products_order" id="top_products-order" value="">
						<button name="save_top_products_order" class="btn btn-primary"><?= tr("Save") ?></button>
					</form>
					
				</div>



			
			</div>


	</div>


<form method="post" enctype="multipart/form-data">
	<div class="modal fade" id="new_top_products-modal" tabindex="-1" role="dialog" aria-labelledby="new_top_products-modalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="new_top_products-modalLabel"><?= tr("New") ?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <label for="">Itme ID</label>
        <input type="text" class="form-control" name="id" value="<?= old("id") ?>"><br>



        <br>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?= tr("Close") ?></button>
        <button name="new_top_products" class="btn btn-primary"><?= tr("Submit") ?></button>
      </div>
    </div>
  </div>
</div>
</form>


<script>
	$(document).ready(function() {

	

		$('#top_products-table tbody').sortable({
			axis: 'y',
			update:  function (event, ui) {

	         	$("#top_products-order").val(JSON.stringify($('#top_products-table tbody').sortable("toArray",{attribute: 'data-index'})))


	        }
		})

			$("#top_products-order").val(JSON.stringify($('#top_products-table tbody').sortable("toArray",{attribute: 'data-index'})))
	});
</script>