<?php 

$barcode_data=$db->single("SELECT settings FROM barcode_settings LIMIT 1");

$barcode_settings = stripcslashes($barcode_data);
$barcode_settings = json_decode($barcode_data, true);
set_lang(
	["font","bw","wid"],
	["حجم الخط","حجم الباركود","العرض"],
	["Font size","Barcode size","Width"]
);


 ?>
 <div id="nav-barcode">
<div class="row pt-3"  dir="rtl" >
	<div class="col-md-4">
		<label for=""><?= $lang['wid'] ?> (cm)</label>
		<input type="number" min="0" class="form-control text-center" v-model="width">
	</div>
	<div class="col-md-4">
		<label for=""><?= $lang['font'] ?></label>
		<input type="number" min="2" class="form-control text-center"  v-model="font">
	</div>
	<div class="col-md-4">
		<label for=""><?= $lang['bw'] ?></label>
		<input type="number" min="1" step="0.1" class="form-control text-center" v-model="bWidth">
	</div>
</div>
<div class="row" dir="ltr">
	<br>
	<label for=""><?= tr("Format") ?></label>
	<input type="text" class="form-control" v-model="format">
</div>
<div class="row mt-3">
	<div class="col">
		<button class="btn btn-primary" @click="submit()"><?= $lang['save'] ?></button>
	</div>
</div>
</div>




<script>
	const barcode_settings = new Vue({
		el:"#nav-barcode",
		data:{
			width:<?= $barcode_settings[0]['width'] ?>,
		      bWidth:<?= $barcode_settings[0]['bWidth'] ?>,
		      font:<?= $barcode_settings[0]['font'] ?>,
		      format:'<?= isset($barcode_settings[0]['format'])?$barcode_settings[0]['format']:'' ?>'
		},
		methods:{

			submit(){

				let job=this
				$.post('<?= $app_url ?>/settings/ajax/settings.php', 
					{
						func: 'barcode_settings',

						"settings":JSON.stringify([{"width":job.width,"bWidth":job.bWidth,"font":job.font,"format":job.format}]),
			
					}, 
					function(data, textStatus, xhr) {
						if(data=="OK"){
							bAlert("<?= $lang['wents_success'] ?>","success")
							location.reload()
						}else{
							bAlert("<?= $lang['wents_wrong'] ?>","danger")
							location.reload()
						}
					}
				);
			}
		}
	})
</script>