<?php 
set_lang(
		[
			"war_note",
			"default_customer",
			"show_sn",
			"name2_for_en",
		],
		[
			"ملاحضة الضمان",
			"رقم العميل الافتراضي",
			"عرض الباركود",
			"الاسم 2 للغة الانجليزية.",
		],
		[
			"Waranty note",
			"Default customer No.",
			"Show barcode.",
			"Product Name 2 for english UI.",
		]
	);



?>

<div id="nav-bill_settings">
	


<div class="row pt-3" id="bill_settings" dir="rtl">
	<div class="col px-0" dir="rtl">
		<h6 class="text-start">ملاحضة الضمان</h6>
		<table class="table table-borderless">
			<tr v-for="(item,index) in ar" class="pt-2">
				<td class="p-0 pt-2">
				<input type="text" class="form-control" v-model="item.note">
				</td>
				<td class="p-0 pt-2 text-center"><button @click="ar.splice(index, 1)" class="btn btn-outline-danger mx-2"><i class="fas fa-minus"></i></button></td>
			</tr>
			<tr>
				<td class="text-start">
				<button class="btn btn-outline-info my-3" @click="ar=ar.concat({note:''})"><i class="fas fa-plus"></i></button>
				</td>
			</tr>
	
		</table>
	</div>
	<div class="col px-0" dir="ltr">
		<h6 class="text-start">Waranty note</h6>
		<table class="table table-borderless">
			<tr v-for="(item,index) in en" class="pt-2">
				<td class="p-0 pt-2">
				<input type="text" class="form-control" v-model="item.note">
				</td>
				<td class="p-0 pt-2 text-center"><button @click="en.splice(index, 1)" class="btn btn-outline-danger mx-2"><i class="fas fa-minus"></i></button></td>
			</tr>
			<tr>
				<td class="text-start">
				<button class="btn btn-outline-info my-3" @click="en=en.concat({note:''})"><i class="fas fa-plus"></i></button>
				</td>
			</tr>
	
		</table>
	</div>
</div>

<div class="row" dir="auto">
	<div class="col-3">
		<label for=""><?= $lang['default_customer'] ?></label>
		<input type="number" min="1" step="1" class="form-control text-center" v-model="default_customer">
	</div>
</div>

<div class="row mt-5" dir="auto">
	<div class="col">
		<div class="custom-control custom-checkbox">
		  <input type="checkbox" class="custom-control-input" v-model="show_sn" id="show_sn_checkbox">
		  <label class="custom-control-label" for="show_sn_checkbox"  ><?= $lang['show_sn'] ?></label>
		</div>
		<div class="custom-control custom-checkbox">
		  <input type="checkbox" class="custom-control-input" v-model="name_two_for_en" id="name2_for_en_checkbox">
		  <label class="custom-control-label" for="name2_for_en_checkbox"  ><?= $lang['name2_for_en'] ?></label>
		</div>

		<div class="custom-control custom-checkbox">
		  <input type="checkbox" class="custom-control-input" v-model="add_discount" id="add_discount_checkbox">
		  <label class="custom-control-label" for="add_discount_checkbox"  ><?= tr("Add discount to bill") ?></label>
		</div>


		<div class="custom-control custom-checkbox">
		  <input type="checkbox" class="custom-control-input" v-model="price_with_tax" id="price_with_tax_checkbox">
		  <label class="custom-control-label" for="price_with_tax_checkbox"  ><?= tr("Price after tax") ?></label>
		</div>
	</div>
</div>

<div class="row mt-5">
	<div class="col">
		<button class="btn btn-primary" @click="submit()"><?= $lang['save'] ?></button>
	</div>
</div>

</div>



<script>
	const bill_settings = new Vue({
		el:"#nav-bill_settings",
		data:{
			ar:<?= $db->single("SELECT war_note_ar FROM bill_settings") ?>,
			en:<?= $db->single("SELECT war_note_en FROM bill_settings") ?>,
			default_customer:<?= $db->single("SELECT default_customer FROM bill_settings") ?>,
			show_sn:<?= $db->single("SELECT show_sn FROM bill_settings") ?>,
			add_discount:<?= $db->single("SELECT add_discount FROM bill_settings") ?>,
			name_two_for_en:<?= $db->single("SELECT name_two_for_en FROM bill_settings") ?>,
			price_with_tax:<?= $db->single("SELECT price_with_tax FROM bill_settings") ?>,
		},
		methods:{

			submit(){

				let job=this
				$.post('<?= $app_url ?>/settings/ajax/settings.php', 
					{
						func: 'bill_settings',
						"default_customer":job.default_customer,
						"war_note_ar":JSON.stringify(job.ar),
						"war_note_en":JSON.stringify(job.en),
						"show_sn":(job.show_sn)?"1":"0",
						"name_two_for_en":(job.name_two_for_en)?"1":"0",
						"add_discount":(job.add_discount)?"1":"0",
						"price_with_tax":(job.price_with_tax)?"1":"0",
					}, 
					function(data, textStatus, xhr) {
						if(data=="OK"){
							bAlert("<?= $lang['wents_success'] ?>","success")
							location.reload()
						}else{
							bAlert("<?= $lang['wents_wrong'] ?>","danger")
							location.reload()
						}
					}
				);
			}
		}
	})
</script>