<?php 
	
	set_lang(['email'],["البريد"],["Email"]);

	$email=$db->row("SELECT * FROM email_settings LIMIT 1");

	set_lang(["send_quantity"],["ارسال تنبيه الكمبية."],["Send quantity alert email."]);
	set_lang(["send_sales"],["إرسال تقرير مبيعات"],["Send sales report email."]);
	set_lang(["send_profit"],["إرسال الربح و / أو تقرير الخسارة"],["Send profit and/or loss email."]);


	

 ?>

<div class="row" id="email" <?= $local ?>>
	<div class="col-md-6">
		<div class="form-group">
			<h5>CPU Email</h5>
			<label for=""><?= $lang['email'] ?></label>
			<input type="email" class="form-control" v-model="email">
			<label for=""><?= $lang['password'] ?></label>
			<input type="text" class="form-control" v-model="password">
		</div>


		<div class="form-group">
			<h5>Receiver Email</h5>
			<label for=""><?= $lang['email'] ?></label>
			<input type="email" class="form-control" v-model="r_email">
		</div>

		<hr>

		<label for=""><?= $lang['time'] ?></label>
		<input type="time" class="form-control text-center" v-model="email_time">



		<div class="row mt-3" dir="auto">
			<div class="col">
				<div class="custom-control custom-checkbox">
				  <input value="true" type="checkbox" class="custom-control-input" v-model="send_quantity" id="send_quantity_checkbox">
				  <label class="custom-control-label" for="send_quantity_checkbox"  ><?= $lang['send_quantity'] ?></label>
				</div>
			</div>
		</div>
		<div class="row mt-3" dir="auto">
			<div class="col">
				<div class="custom-control custom-checkbox">
				  <input value="true" type="checkbox" class="custom-control-input" v-model="send_sales" id="send_sales_checkbox">
				  <label class="custom-control-label" for="send_sales_checkbox"  ><?= $lang['send_sales'] ?></label>
				</div>
			</div>
		</div>
		<div class="row mt-3" dir="auto">
			<div class="col">
				<div class="custom-control custom-checkbox">
				  <input value="true" type="checkbox" class="custom-control-input" v-model="send_profit" id="send_profit_checkbox">
				  <label class="custom-control-label" for="send_profit_checkbox"  ><?= $lang['send_profit'] ?></label>
				</div>
			</div>
		</div>


		<button class="btn btn-primary mt-4" @click="submit()"><?= $lang['save'] ?></button>
	</div>

</div>

<script>
	
	const email_settings=new Vue({
		el:"#email",
		data:{
			email:'<?= $email['email'] ?>',
			r_email:'<?= $email['r_email'] ?>',
			password:'<?= $email['password'] ?>',
			email_type:'<?= $email['email_type'] ?>',
			send_profit:<?= ($email['send_profit']=="1")?'true':'false' ?>,
			send_sales:<?= ($email['send_sales']=="1")?'true':'false' ?>,
			send_quantity:<?= ($email['send_quantity']=="1")?'true':'false' ?>,
			email_time:'<?= $email['email_time'] ?>',

		},
		methods:{
			submit(){
				let	job=this
				$.post('<?= $app_url ?>/settings/ajax/settings.php', 
					{
						'func': "email",
						'email': job.email,
						'r_email': job.r_email,
						'password': job.password,
						'email_type': job.email_type,
						'send_sales': job.send_sales,
						'send_profit': job.send_profit,
						'send_quantity': job.send_quantity,
						'email_time': job.email_time,
					}, 
					function(data, textStatus, xhr) {
						console.log(data)
					}
				);
			}
		}
	})
</script>
