<?php 

$repair_sms          =$db->single("SELECT repair_sms FROM sms_settings LIMIT 1");
$send_repair_sms     =$db->single("SELECT send_repair_sms FROM sms_settings LIMIT 1");

$order_sms           =$db->single("SELECT order_sms FROM sms_settings LIMIT 1");
$send_order_sms      =$db->single("SELECT send_order_sms FROM sms_settings LIMIT 1");
$send_debt_sms       =$db->single("SELECT 	send_customer_debt FROM sms_settings LIMIT 1");
$debt_sms            =$db->single("SELECT debt_sms FROM sms_settings LIMIT 1");
$reminder_sms        =$db->single("SELECT reminder_sms FROM sms_settings LIMIT 1");
$reminder_categories =$db->single("SELECT reminder_categories FROM sms_settings LIMIT 1");
$reminder            =$db->single("SELECT reminder FROM sms_settings LIMIT 1");
$monthly_debt_sms=$db->single("SELECT monthly_debt_sms FROM sms_settings LIMIT 1");


set_lang(
	[
		"repair_sms",
		"send_repair_sms",
		"order_sms",
		"send_order_sms",
		"debt_sms",
		"send_debt_sms",
	],
	[
		"رسالة  اكتمال الصيانة",
		"ارسال رسالة  اكتمال الصيانة",
		"رسالة  اكتمال الطلب",
		"ارسال رسالة  اكتمال الطلب",
		"رسالة المستحقات",
		"ارسال رسالة المستحقات للعميل",
	],
	[
		"Repair complete SMS",
		"Send Repair complete SMS",
		"Order complete SMS",
		"Send Order complete SMS",
		"Customers debt SMS",
		"Send Customers debt SMS",
	]
);

set_lang(["user_name"],["اسم المستخدم"],["user name"]);
set_lang(["device"],["الجهاز"],["device"]);

set_lang(["send_pofit_sms"],["ارسال رسالة ترير الربح والخسارة"],["Send Profit and/or loss SMS"]);


?>



<div id="nav-sms" class="row" dir="auto">
	<div class="col">

		<div class="row mt-3" dir="auto">
			<div class="col">
				<div class="custom-control custom-checkbox">
				  <input value="1" type="checkbox" class="custom-control-input" v-model="send_repair_sms" id="send_repair_sms_checkbox">
				  <label class="custom-control-label" for="send_repair_sms_checkbox"  ><?= $lang['send_repair_sms'] ?></label>
				</div>
			</div>
		</div>
		
		<div class="row mt-2" v-show="send_repair_sms">
			<div class="col">
				<label for=""><?= $lang['repair_sms'] ?></label>
				<textarea <?= $local ?> cols="30" rows="5" class="form-control" v-model="repair_sms"></textarea>
				<p class="bg-light"><?= $lang['date'] ?>:{date}, <?= $lang['customer'] ?>:{customer}, <?= $lang['company_name'] ?> ar:{company_ar}, <?= $lang['company_name'] ?> en:{company_en}, <?= $lang['device'] ?>:{device}, <?= $lang['user_name'] ?>:{user}, Delivery date:{delivery_date}</p>
			</div>
		</div>


		<div class="row mt-3" dir="auto">
			<div class="col">
				<div class="custom-control custom-checkbox">
				  <input value="1" type="checkbox" class="custom-control-input" v-model="send_order_sms" id="send_order_sms_checkbox">
				  <label class="custom-control-label" for="send_order_sms_checkbox"  ><?= $lang['send_order_sms'] ?></label>
				</div>
			</div>
		</div>

		<div class="row mt-2" v-show="send_order_sms">
			<div class="col">
				<label for=""><?= $lang['order_sms'] ?></label>
				<textarea <?= $local ?> cols="30" rows="5" class="form-control" v-model="order_sms"></textarea>
				<p class="bg-light"><?= $lang['date'] ?>:{date}, <?= $lang['customer'] ?>:{customer}, <?= $lang['company_name'] ?> ar:{company_ar}, <?= $lang['company_name'] ?> en:{company_en}, <?= $lang['type'] ?>:{type}, <?= $lang['user_name'] ?>:{user}, Delivery date:{delivery_date}</p>
			</div>
		</div>



		<div class="row mt-3" dir="auto">
			<div class="col">
				<div class="custom-control custom-checkbox">
				  <input value="1" type="checkbox" class="custom-control-input" v-model="send_debt_sms" id="send_debt_sms_checkbox">
				  <label class="custom-control-label" for="send_debt_sms_checkbox"  ><?= $lang['send_debt_sms'] ?></label>
				</div>
			</div>
		</div>

		<div class="row mt-2" v-show="send_debt_sms">
			<div class="col">
				<label for=""><?= $lang['debt_sms'] ?></label>
				<textarea <?= $local ?> cols="30" rows="5" class="form-control" v-model="debt_sms"></textarea>
				<p class="bg-light"><?= $lang['date'] ?>:{date}, <?= $lang['customer'] ?>:{customer}, <?= $lang['company_name'] ?> ar:{company_ar}, <?= $lang['company_name'] ?> en:{company_en}, <?= $lang['amount'] ?>:{amount}</p>
			</div>
		</div>



		<div class="row mt-3" dir="auto">
			<div class="col">
				<div class="custom-control custom-checkbox">
				  <input value="1" type="checkbox" class="custom-control-input" v-model="monthly_debt_sms" id="monthly_debt_sms_checkbox">
				  <label class="custom-control-label" for="monthly_debt_sms_checkbox"  ><?= tr("monthly debt sms") ?></label>
				</div>
			</div>
		</div>


		<hr>

		<h5><?= tr("Reminder") ?></h5>
		<div class="row mt-3" dir="auto">
			<div class="col">
				<div class="custom-control custom-checkbox">
				  <input value="1" type="checkbox" class="custom-control-input" v-model="reminder" id="reminder-sms-cehckbox">
				  <label class="custom-control-label" for="reminder-sms-cehckbox"  ><?= tr("Reminer") ?></label>
				</div>
			</div>
		</div>

		<div class="row" v-show="reminder">
			<div class="col-md-6">
				<label for=""><?= tr("Reminer SMS") ?></label>
				<textarea <?= $local ?> cols="30" rows="5" class="form-control" v-model="reminder_sms"></textarea>
				<p class="bg-light"><?= $lang['date'] ?>:{date}, <?= $lang['customer'] ?>:{customer} , <?= tr("Category") ?>:{category},  <?= $lang['company_name'] ?> ar:{company_ar}, <?= $lang['company_name'] ?> en:{company_en}, <?= $lang['amount'] ?>:{amount}</p>
			</div>
	
			<div class="col-md-6">
				<table class="table table-sm border">
				<tbody>
					<tr v-for="(category,index) in reminder_categories">
						<td>
							{{category.name}}
						</td>
						<td>
							{{category.days}}
						</td>
						<td>
							<button 
							class="btn btn-sm btn-danger"
							@click="reminder_categories.splice(index,1)"
							><?= tr("Delete") ?></button>
						</td>
					</tr>
				</tbody>
				<tfoot>
					<tr>
						<td><input type="text" class="form-control form-control-sx" v-model="new_name" placeholder="<?= tr("Category") ?>"></td>
						<td><input type="number" class="form-control form-control-sx" v-model="new_days"  placeholder="<?= tr("days") ?>"></td>
						<td><button 
							class="btn btn-sm btn-primary" 
							@click="reminder_categories.push({'name':new_name,'days':new_days});new_days=0;new_name=''"
							><?= tr("Add") ?></button></td>
					</tr>

				</tfoot>
				</table>
			</div>
		</div>


		<button class="btn btn-primary mt-5" @click="submit()"><?= $lang['save'] ?></button>

	</div>
</div>




<script>
	const sms_settings = new Vue({
		el:"#nav-sms",
		data:{
			repair_sms:<?= json_encode($repair_sms)  ?>,
			send_repair_sms:<?= ($send_repair_sms)?'true':'false'  ?>,
			order_sms:<?= json_encode($order_sms)  ?>,
			send_order_sms:<?= ($send_order_sms)?'true':'false' ?>,
			send_pofit_sms:1,
			send_debt_sms:<?= $send_debt_sms?'true':'false' ?>,
			debt_sms:<?= json_encode($debt_sms)  ?>,
			reminder:<?= ($reminder)?'true':'false'  ?>,
			reminder_sms:<?= json_encode($reminder_sms)  ?>,
			reminder_categories:<?= $reminder_categories?$reminder_categories:'[]'  ?>,
			new_name:'',
			new_days:'',
			monthly_debt_sms:<?= $monthly_debt_sms?'true':'false' ?>,
		},
		methods:{
			submit(){
				let job=this
				$.post('<?= $app_url ?>/settings/ajax/settings.php', 
					{
						'func': 'sms',
						'repair_sms':job.repair_sms,
						'send_repair_sms':job.send_repair_sms,
						'order_sms':job.order_sms,
						'send_order_sms':job.send_order_sms,
						'debt_sms':job.debt_sms,
						'send_debt_sms':job.send_debt_sms,
						'reminder':job.reminder,
						'reminder_sms':job.reminder_sms,
						'reminder_categories':JSON.stringify(job.reminder_categories),
						'monthly_debt_sms':job.monthly_debt_sms,
					}, 
					function(data, textStatus, xhr) {
						if (data=="OK") {
							notifi('<?= $lang['wents_success'] ?>','success')
						}else{
							bAlert('<?= $lang['wents_wrong'] ?>','danger')
							location.reload()
						}
					}
				);
			}
		}
	})
</script>