<?php 

	$categories = $db->single("SELECT categories FROM website_settings");
 ?>
<div class="row" >
	<div class="col-lg-6">
		<form method="post" id="categories">
			<div class="card">
				<div class="card-header">
					<h5><?= tr("Categories") ?></h5>
				</div>
				<table class="table table-sm">
					<thead>
						<tr>
						<th>
							<?= tr("Category") ?>
						</th>
						<th></th>
					</tr>
					</thead>
					<tbody>
						<tr v-for="(item,index) in list">
							<td>
								<select class="form-control form-control-sm" v-model="list[index]">
									<?php foreach ($db->query("SELECT * FROM categories WHERE parent_id = 0") as $key => $cat): ?>
										<option value="<?= $cat['id'] ?>"><?= $cat[pname('name','name_en')] ?></option>
									<?php endforeach ?>
								</select>
							</td>
							<td>
								<button 
								@click="list.splice(index,1)"
								type="button" 
								class="btn btn-sm btn-danger"><?= tr("Delete") ?></button>
							</td>
						</tr>
					</tbody>
					<tfoot>
						<tr>
							<td><button 
								@click="list.push('')"
								class="btn btn-light btn-sm" 
								type="button"><?= tr("Add new") ?></button></td>
							<td></td>
						</tr>
					</tfoot>
				</table>

				

				<div class="card-body">
					<button name="save_categories" class="btn btn-primary"><?= tr("Save") ?></button>
				</div>
			
			</div>


			<input type="hidden" name="categories" :value="JSON.stringify(list)">
		</form>
	</div>


	<?php include "inc/info.php" ?>
	<?php include "inc/carousal.php" ?>
	<?php include "inc/banners_1.php" ?>
	<?php include "inc/banners_2.php" ?>
	<?php include "inc/shopping_info.php" ?>
	<?php include "inc/social.php" ?>
	<?php include "inc/top_products.php" ?>
	<?php include "inc/currencies.php" ?>
	<?php include "inc/shipping.php" ?>
	<?php include "inc/payments.php" ?>



</div>


<script>
	categories = new Vue({
		el:'#categories',
		data:{
			list:<?= is_json($categories)?$categories:'[]' ?>
		}
	})


</script>