<?php

	$root=".";
	require($root . "/php/init.php");
	

use ReCaptcha\ReCaptcha;

if (conf("App.active_recaptcha")) {
  $reCaptcha =new ReCaptcha(conf("App.recaptcha_secret"));
}


?>
<!DOCTYPE html>
<html lang="<?= strtolower($ml->lang) ?>" dir="<?= $ml->lang=="AR"?'rtl':'ltr' ?>">
<?php require($root . "/inc/head.php") ?>

<style>
	.login-cover {
	    background: url(<?= $root ?>/assets/images/food-bg.jpg) no-repeat;
	    background-size: cover;
	}
</style>
<body style="position: inherit;">

	<!-- Page content -->
	<div class="page-content login-cover">

		<!-- Main content -->
		<div class="content-wrapper">

			<!-- Content area -->
			<div class="content d-flex justify-content-center align-items-center">

				<!-- Login form -->
				<form class="login-form wmin-sm-400"  method="post" autocomplete="off" enctype="multipart/form-data">
					<?php $display->display_messages() ?>
					<div class="card mb-0 bg-primary shadow" style="border-radius: 30px; border: white solid 2px;">
					

						<div class=" card-body shadow">
							<div class="tab-pane fade show active" id="login-tab1">
								<div class="text-center mb-3">
									<?php if (strlen(conf("App.logo"))): ?>
										

									<div class="card-img-actions d-inline-block mb-3">
										<i class="fas fa-key fa-4x"></i>
									
									</div>
								
									<?php else: ?>
										<i class="icon-reading icon-2x text-slate-300 border-slate-300 border-3 rounded-round p-3 mb-3 mt-1"></i>
									<?php endif ?>
									

									<!-- <span class="d-block text-muted">Your credentials</span> -->
								</div>

								<div class="form-group form-group-feedback form-group-feedback-left">
									<input type="text" class="form-control" name="username" value="<?= old('username') ?>" placeholder="Username">
									<div class="form-control-feedback">
										<i class="icon-user text-muted"></i>
									</div>
								</div>

								<div class="form-group form-group-feedback form-group-feedback-left">
									<input type="password" class="form-control" placeholder="Password" name="password">
									<div class="form-control-feedback">
										<i class="icon-lock2 text-muted"></i>
									</div>
								</div>

					

                      <div class="form-group d-flex align-items-center">
					

								<div class="custom-control custom-checkbox my-1 mr-sm-2">
								    <input type="checkbox" checked="" class="custom-control-input" id="remember-me" name="remember_me">
								    <label class="custom-control-label" for="remember-me"><?= tr("Remember me") ?></label>
								  </div>

								
							</div>



								<?php if (conf("App.active_recaptcha")): ?>
			                        <p>
										 <div class="g-recaptcha form-field" style="width: 100%" data-sitekey="<?= conf("App.recaptcha_site") ?>"></div>
									</p>
			                       <br>
			                      <?php endif ?>

							

								<div class="form-group">
									<button type="submit" name="signin" class="btn btn-light rounded-pill btn-block"><?= tr("Sign In") ?></button>
								</div>


								<p class="text-center text-light">
								
									<a class="text-light" href="resetpassword.php"><?= tr("Frogot password") ?></a>
									
								</p>
						
								

						

						

					


								
							</div>

						
						</div>
					</div>
				</form>
				<!-- /login form -->

			</div>
			<!-- /content area -->

		</div>
		<!-- /main content -->

	</div>
	<!-- /page content -->
	<?php require($root . "/inc/scripts.php") ?>
	<?php if (conf("App.active_recaptcha")): ?>
    <script type="text/javascript" src="https://www.google.com/recaptcha/api.js?hl=<?= $ml->lang ?>"></script>
  <?php endif ?>

</body>
</html>