

<div class="modal fade" id="new-pay-vcher-modal" tabindex="-1" role="dialog" aria-labelledby="new-pay-vcher-modal-title" aria-hidden="true" data-backdrop="static" data-keyboard="false">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="new-customer-modal-title"><?= $lang['pay_vcher'] ?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div v-show="error" class="alert alert-danger" role="alert">
          <?= $lang['wents_wrong'] ?>
        </div>
        <div class="form-group">
          <label for=""><?= $lang['day'] ?> *</label>
          <input v-model="day" class=" form-control text-center new-pay-sup-modal-date" type="text" >

          <label for=""><?= $lang['name'] ?> *</label>
          <input v-model="name" class=" form-control" type="text" >


          
          <div class="bg-light mt-1 py-1 border">
            <label for=""><?= $lang['amount'] ?> *</label>
            <input v-model="amount" class=" form-control text-center" type="number" min="0.01 ">
            <label class="mt-2" for=""><?= $lang['pay_by'] ?></label>
            <select class="form-control text-center" v-model="pay_by">
              <option selected value="cash"><?= $lang['cash'] ?></option>
              <option value="ccard"><?= $lang['ccard'] ?></option>
              <option value="cheque"><?= $lang['cheque'] ?></option>
              <option value="other"><?= $lang['other'] ?></option>
            </select>
            <div  v-show="(pay_by == 'cheque') ? true : false">
              <label class="" for=""><?= $lang['cheque_no'] ?></label>
              <input type="text" class="form-control text-center" v-model="cheque_no">
            </div>
            <div   v-show="(pay_by == 'cheque') ? true : false">
              <label class="" for=""><?= $lang['cheque_date'] ?></label>
              <input type="text " class="form-control text-center cheque_date_pay_sup" v-model="cheque_date">
            </div>
          </div>
          <label for=""><?= $lang['for'] ?> </label>
          <input v-model="itsfor" class="form-control text-center" type="text" >
          <div>
            <label class="" for=""><?= $lang['note'] ?></label>
            <textarea  cols="1" rows="1" class="form-control" v-model='descr'></textarea>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-danger"  data-dismiss="modal"><?= $lang['cancel'] ?></button>
        <button :disabled="(amount === undefined || amount == null ||amount == 0 || amount.length <= 0 || day === undefined || day == null ||day == 0 || day.length <= 0 || name==0) ? true : false"  @click="submit" type="button" class="btn btn-primary"><?= $lang['add'] ?></button>
      </div>
    </div>
  </div>
</div>

<script>
  const newPaySupModal=new Vue({
    el:"#new-pay-vcher-modal",
    data:{
      token:<?= $tk->generate('sp'); ?>,
      day:'<?= date("d-m-Y") ?>',
      sub_id:<?= isset($sup_id)?$sup_id:0 ?>,

      amount:1.00,
      pay_by:'cash',
      cheque_date:'',
      cheque_no:'',
      note:'',


      error:false
    },
    methods:{
      submit:function(event){
        var elem=event.currentTarget
        if (!(this.amount === undefined || this.amount == null ||this.amount == 0 || this.amount.length <= 0 || this.day === undefined || this.day == null ||this.day == 0 || this.day.length <= 0 || this.name==0)) {
          $(elem).button('loading')
          $.post('<?= $app_url ?>/customers/payment_voucher/ajax/pr.php', 
            {
              'token_val':this.token_val,
              'token_name':this.token_name,
              'func':'new',
              'day':this.day,
              'name':this.name,
              'amount':this.amount,
              'pay_by':this.pay_by,
              'cheque_date':this.cheque_date,
              'cheque_no':this.cheque_no,
              'descr':this.descr,
            }, 
            function(data) {
              console.log(data)
              data=JSON.parse(data)
              if (data.status=="OK") {

                bAlert("<?= escap($lang['wents_success']) ?>","success")
                newPaySupModal.id=data.vid;

                $("#print-pay-vcher-modal").modal("show")
                
                newPaySupModal.error=false
                $("#new-pay-vcher-modal").modal("toggle")
              }else{
                newPaySupModal.error=true
              }
              $(elem).button('reset')
            }
          );
        }
      },

    },

  })

  $(document).ready(function() {
    $('.new-pay-sup-modal-date').datepicker({
        <?php if ($isRtl) {echo "rtl: true,";} ?>
        todayHighlight: true,
        format:"dd-mm-yyyy",
        autoclose: true,
      }).on('changeDate', function (selected) {
          newPaySupModal.day=selected.format('dd-mm-yyyy')
      });

      $('.cheque_date_pay_sup').datepicker({
        <?php if ($isRtl) {echo "rtl: true,";} ?>
        todayHighlight: true,
        format:"dd-mm-yyyy",
        autoclose: true,
        startDate: new Date(),
      }).on('changeDate', function (selected) {
          newPaySupModal.cheque_date=selected.format('dd-mm-yyyy')
      });

      $('.cus-select').selectpicker();
  });
</script>