<?php 
;
  if ($user->is_signed) {
    $new_supplier_token = $tk->generate('new_sup');
  }


 ?>

<!-- <button type="button" class="btn btn-info" data-toggle="modal" data-target="#new-supplier-modal"> -->
<!-- Modal -->
<div class="modal fade" id="new-supplier-modal" tabindex="-1" role="dialog" aria-labelledby="new-supplier-modal-title" aria-hidden="true" style="z-index: 1600;">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content" >
      <div class="modal-header">
        <h3 class="modal-title" id="new-supplier-modal-title"><?= $lang['new_supplier'] ?></h3>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div  class="alert alert-danger" role="alert" v-for="error in errors">
          {{error}}
        </div>
        <div class="form-group">
          <label for=""><?= $lang['name'] ?></label>
          <input v-model="name" class=" form-control text-center" type="text" >
          <label for=""><?= $lang['phone'] ?></label>
          <input v-model="phone" class=" form-control" type="text" >

          <label for=""><?= tr("Tax no") ?></label>
          <input v-model="tax_no" class=" form-control" type="text" >

          <label for=""><?= $lang['start_debit'] ?></label>
          <input type="number" class="form-control text-center" value="0" v-model="start_amount">


          <label for=""><?= $lang['address'] ?></label>
          <textarea v-model="address" class="form-control" id="" cols="1" rows="2"></textarea>
          
          <label for=""><?= $lang['note'] ?></label>
          <textarea v-model="descr" class="form-control" id="" cols="1" rows="2"></textarea>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal"><?= $lang['cancel'] ?></button>
        <button :disabled="(name === undefined || name == null ||name == 0 || name.length <= 0) ? true : false" @click="submit" type="button" class="btn btn-primary"><?= $lang['add'] ?></button>
      </div>
    </div>
  </div>
</div>

<script>
  const newSupplierModal=new Vue({
    el:"#new-supplier-modal",
    data:{
      name:'',
      phone:'',
      address:'',
      tax_no:'',
      descr:'',
      start_amount:0,
      errors:[],
      token:'<?= $new_supplier_token  ?>',

    },
    methods:{
      submit:function(event){
        var elem=event.currentTarget
        console.log('send')
        if (!(this.name === undefined || this.name == null ||this.name == 0 || this.name.length <= 0)) {
          $(elem).button('loading')
          $.post('<?= $app_url ?>/suppliers/ajax/suppliers.php', 
            {
              'func': 'new',
              'name': this.name,
              'phone': this.phone,
              'tax_no': this.tax_no,
              'address': this.address,
              'descr': this.descr,
              'start_amount': this.start_amount,
              'token': this.token,
             
            }, 
            function(data) {
              console.log(data)
              data=JSON.parse(data)
              if (data.status==true) {
                $(elem).button('reset')

                <?php if ($this_url == $app_url."/suppliers/"): ?>
                  window.location.reload()
                <?php endif ?>

                try{
                  newProductPage.suppliersList(data.data.id)
                }catch(e){}

                try{
                  newImportPage.suppliersList(data.data.id)
                }catch(e){}
                try{
                  viewImportPage.suppliersList(data.data.id)
                }catch(e){}

          


                newSupplierModal.errors=data.message
                newSupplierModal.name=''
                newSupplierModal.phone=''
                newSupplierModal.address=''
                newSupplierModal.descr=''
                $("#new-supplier-modal").modal("toggle")
              }else{
                $(elem).button('reset')
                newSupplierModal.errors=data.message
              }

              try{
                newSupplierModal.token=data.token
              }catch(e){

              }
            }
          );
        }
      }
    }
  })
</script>


<script>

</script>