
<div class="modal fade" id="view-sup-pay-modal" tabindex="-1" role="dialog" aria-labelledby="view-sup-pay-modal-title" aria-hidden="true" data-backdrop="static" data-keyboard="false">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="new-customer-modal-title"><?= $lang['pay_vcher'] ?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div v-show="error" class="alert alert-danger" role="alert">
          <?= $lang['wents_wrong'] ?>
        </div>
        <div class="form-group">
          <label for=""><?= $lang['day'] ?> *</label>
          <input v-model="day" class=" form-control text-center view-sup-pay-date" type="text" >

          <label for=""><?= $lang['name'] ?> *</label>
          <select v-model="sup_id" class=" form-control view-sup-pay-select" data-size="8" data-live-search="true" data-style="btn-default border text-center">
            <option  v-for="(sup, index) in sup_list" :value="sup.id" >{{sup.name}}</option>
          </select>

          <div class="bg-light mt-1 py-1 border">
            <label for=""><?= $lang['amount'] ?> *</label>
            <input v-model="amount" class=" form-control text-center" type="number" min="0.01 ">
            <label class="mt-2" for=""><?= $lang['pay_by'] ?></label>
            <select class="form-control text-center" v-model="pay_by">
              <?php foreach ($bill->payment_methods as $key => $value): ?>
                  <option value="<?= $value ?>"><?= $lang[$value] ?></option>
              <?php endforeach ?>
            </select>
            <div  v-show="(pay_by == 'cheque') ? true : false">
              <label class="" for=""><?= $lang['cheque_no'] ?></label>
              <input type="text" class="form-control text-center" v-model="cheque_no">
            </div>
            <div   v-show="(pay_by == 'cheque') ? true : false">
              <label class="" for=""><?= $lang['cheque_date'] ?></label>
              <input type="text " class="form-control text-center cheque_date_sup_pay" v-model="cheque_date">
            </div>
          </div>
          <label for=""><?= $lang['for'] ?> </label>
          <input v-model="p_for" class="form-control text-center" type="text" >
          <label for=""><?= $lang['import'] ?> (#)</label>
          <input class="form-control text-center" type="number" v-model="import_id" placeholder="No.">
          <div>
            <label class="" for=""><?= $lang['note'] ?></label>
            <textarea  cols="1" rows="1" class="form-control" v-model='note'></textarea>
          </div>
        </div>
     <div class="modal fade" id="delete-sup-pay" tabindex="-1" role="dialog" aria-labelledby="delete-quantityLabel" aria-hidden="true" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog modal-dialog-centered" role="document">
          <div class="modal-content " style="border:2px black solid">
            <div class="modal-header">
              <h5 class="modal-title" id="delete-quantityLabel"><?= $lang['you_sure'] ?></h5>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true" style="font-size: 24px">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <?= $lang['delete_element'] ?>
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-secondary" data-dismiss="modal"><?= $lang['close'] ?></button>
              <button type="button" @click="delete_el()"class="btn btn-danger" data-dismiss="modal"><?= $lang['yes'] ?></button>
            </div>
          </div>
        </div>
      </div>


      </div>
      <div class="modal-footer">
        <button title="<?= $lang['delete'] ?>" type="button" class="btn btn-danger <?= $mrAuto ?>" data-toggle="modal"  data-target="#delete-sup-pay"><i class="far fa-trash-alt"></i></button>
        <button type="button" class="btn btn-danger"  data-dismiss="modal"><?= $lang['cancel'] ?></button>
        <button :disabled="!valid"  @click="submit" type="button" class="btn btn-primary"><?= $lang['save'] ?></button>

      </div>
    </div>
  </div>
</div>

<script>
  const updateSupPayModal=new Vue({
    el:"#view-sup-pay-modal",
    data:{
      token:<?= json_encode($tk->generate('suppay')); ?>,

      day:'<?= date("d-m-Y") ?>',
 
      sup_id:<?= $sup_id ?>,
      sup_list:[],
      p_for:'',
      amount:1.00,
      pay_by:'cash',
      cheque_date:'',
      cheque_no:'',
      note:'',
      import_id:'',
      id:0,


      error:false,
      err_msg:'<?= $lang['wents_wrong'] ?>',
    },
    methods:{
      submit:function(event){
        var elem=event.currentTarget
        if (this.valid) {
          $(elem).button('loading')
          $.post('<?= $app_url ?>/suppliers/payment/ajax/payment.php', 
            {
              'token_val':this.token.val,
              'token_name':this.token.key,
              'func':'edit',
              'id':this.id,
              'sup_id':this.sup_id,
              'p_day':this.day,
              'p_for':this.p_for,
              'amount':this.amount,
              'pay_by':this.pay_by,
              'cheque_date':this.cheque_date,
              'cheque_no':this.cheque_no,
              'note':this.note,
              'import_id':this.import_id,
            }, 
            function(data) {
              console.log(data)
            
              if (data.status=="OK") {

                bAlert("<?= escap($lang['wents_success']) ?>","success")
        

              
                location.reload()
                updateSupPayModal.error=false
         
              }else{
                updateSupPayModal.error=true
                updateSupPayModal.err_msg=data.msg
                bAlert("<?= escap($lang['wents_wrong']) ?>","danger")
                location.reload()
              }
              $(elem).button('reset')
            },'json'
          );
        }
      },
      get_data:function(id){
        updateSupPayModal.id=id
        $.post('<?= $app_url ?>/suppliers/payment/ajax/payment.php', 
          {
            'func': 'get',
            'id':updateSupPayModal.id
          }, 
          function(data) {
            updateSupPayModal.day         = data.p_day
            updateSupPayModal.sup_id      = data.sup_id
            updateSupPayModal.amount      = data.amount
            updateSupPayModal.p_for       = data.p_for
            updateSupPayModal.pay_by      = data.pay_by
            updateSupPayModal.cheque_date = data.due_date
            updateSupPayModal.cheque_no   = data.cheque_no
            updateSupPayModal.note        = data.note
            updateSupPayModal.import_id        = data.import_id
            updateSupPayModal.suppliersList()

            $("#view-sup-pay-modal").modal("show")
          },
          'json'
        );
      },
      delete_el:function(){
        $.post('<?= $app_url ?>/suppliers/payment/ajax/payment.php', {'func': 'delete','id':updateSupPayModal.id}, function(data) {
          if (data=="OK") {
            bAlert("<?= escap($lang['wents_success']) ?>","success")
          }else{
            bAlert("<?= escap($lang['wents_wrong']) ?>","danger")
          }
          location.reload()
        });
      },
      suppliersList:function(){
        $.get('<?= $app_url ?>/suppliers/ajax/get-suppliers.php', function(data) {
 
          updateSupPayModal.sup_list=JSON.parse(data)

        }).then(function(){

           $('.view-sup-pay-selec').val(updateSupPayModal.sup_id);
            $('.view-sup-pay-selec').selectpicker('refresh');
            $('.view-sup-pay-selec').trigger('change');
        });
      }

    },
    computed:{
      valid:function(){
        return (!(this.amount === undefined || this.amount == null ||this.amount == 0 || this.amount.length <= 0 || this.day === undefined || this.day == null ||this.day == 0 || this.day.length <= 0 || this.sup_id==0))
      }
    }

  })

  $(document).ready(function() {

    $('.view-sup-pay-date').datepicker({
        <?php if ($isRtl) {echo "rtl: true,";} ?>
        todayHighlight: true,
        format:"dd-mm-yyyy",
        autoclose: true,
      }).on('changeDate', function (selected) {
          updateSupPayModal.day=selected.format('dd-mm-yyyy')
      });

      $('.cheque_date_sup_pay').datepicker({
        <?php if ($isRtl) {echo "rtl: true,";} ?>
        todayHighlight: true,
        format:"dd-mm-yyyy",
        autoclose: true,
        startDate: new Date(),
      }).on('changeDate', function (selected) {
          updateSupPayModal.cheque_date=selected.format('dd-mm-yyyy')
      });

      $('.view-sup-pay-select').selectpicker();

       $( "#view-sup-pay-modal" ).on('shown.bs.modal', function(){
        $('.view-sup-pay-select').selectpicker('refresh');
    });
  });
</script>