<?php 

if (isset($_POST['new_suppayment'])) {

	$sup_id    =isset($_POST['sup_id'])?$_POST['sup_id']:"";
	$p_day     =isset($_POST['p_day'])?$_POST['p_day']:"";
	$amount    =isset($_POST['amount'])?$_POST['amount']:"";
	$note      =isset($_POST['note'])?$_POST['note']:"";
	$pay_by    =isset($_POST['pay_by'])?$_POST['pay_by']:"";
	$cheque_no =isset($_POST['cheque_no'])?$_POST['cheque_no']:"";
	$due_date =isset($_POST['due_date'])?$_POST['due_date']:"";
	$import_id =isset($_POST['import_id'])?$_POST['import_id']:"";

	$v->validate([
		tr("Supplier") =>[$sup_id,"required|in_table(suppliers,id)"],
		tr("Amount") =>[$amount,"required|number"],
		tr("Date") =>[$p_day,"required"],
	]);

	if ($v->passes()) {
		$recieved=1;
	
		if ($pay_by=="cheque") {
			$recieved=0;

			$v->validate([
				$lang['cheque_no'] =>[$cheque_no,"required"],
				$lang['cheque_date'] =>[$due_date,"required"],

			]);
			
			$due_date=$due_date;
			
		}
	}

	if (strlen($import_id)>0) {
		$v->validate([
			"Import"=>[$import_id,"in_table(imports,id)"]
		]);
	}

	
	if ($tk->passes() && $v->passes()) {


		$db->query(
					"INSERT INTO sup_payment(sup_id,p_day, amount,import_id, note, pay_by, due_date, cheque_no, added_on, added_by, received_01)
					VALUES (?,?,?,?,?,?,?,?,?,?,?)",
					[$sup_id, $p_day, $amount,$import_id, $note, $pay_by, $due_date, $cheque_no,$now,auth()->id,$recieved]
				);


		$display->success(tr("Payment added successfully."));

		$redirect->to(remove_from_url($this_url,["i","v"]));
	}
}



if (isset($_POST['update_suppayment'])) {

	$sup_id    =isset($_POST['sup_id'])?$_POST['sup_id']:"";
	$p_day     =isset($_POST['p_day'])?$_POST['p_day']:"";
	$amount    =isset($_POST['amount'])?$_POST['amount']:"";
	$note      =isset($_POST['note'])?$_POST['note']:"";
	$pay_by    =isset($_POST['pay_by'])?$_POST['pay_by']:"";
	$cheque_no =isset($_POST['cheque_no'])?$_POST['cheque_no']:"";
	$due_date =isset($_POST['due_date'])?$_POST['due_date']:"";
	$import_id =isset($_POST['import_id'])?$_POST['import_id']:"";
	$id =isset($_POST['id'])?$_POST['id']:"";

	$v->validate([
		tr("Supplier") =>[$sup_id,"required|in_table(suppliers,id)"],
		tr("Amount") =>[$amount,"required|number"],
		tr("Date") =>[$p_day,"required"],
		"id" =>[$id,"required"],
	]);

	if ($v->passes()) {
		$recieved=1;

		if ($pay_by=="cheque") {
			$recieved=0;

			$v->validate([
				$lang['cheque_no'] =>[$cheque_no,"required"],
				$lang['cheque_date'] =>[$due_date,"required"],

			]);
			
			$due_date=$due_date;
			
		}
	}

	if (strlen($import_id)>0) {
		$v->validate([
			"Import"=>[$import_id,"in_table(imports,id)"]
		]);
	}


	if ($tk->passes() && $v->passes()) {


		$db->query(
					"UPDATE sup_payment SET sup_id=?,p_day=?, amount=?,import_id=?, note=?, pay_by=?, due_date=?, cheque_no=?, added_on=?, added_by=?, received_01=? WHERE id = ? ",
					[$sup_id, $p_day, $amount,$import_id, $note, $pay_by, $due_date, $cheque_no,$now,auth()->id,$recieved,$id]
				);


		$display->success(tr("Payment updated successfully."));

		if (isset($_GET['popup'])) {
			echo '<script>window.close()</script>';
		}
	}
}


if (isset($_POST['received'])) {

	$id =isset($_POST['id'])?$_POST['id']:""; 

	$v->validate([
		"ID"=>[$id,"required"]
	]);

	if ($v->passes() && $tk->passes()) {
		$db->query("UPDATE sup_payment SET received_01 = 1 WHERE id = ? ",[$id]);

		$display->success(tr("Payment updated succssfully"));
	}
}


if (isset($_POST['delete_sup_pay'])) {

	$id =isset($_POST['id'])?$_POST['id']:""; 
	
	$v->validate([
		"ID"=>[$id,"required"]
	]);

	if ($v->passes() && $tk->passes()) {
		$db->query("UPDATE sup_payment SET deleted_01 = 1 WHERE id = ? ",[$id]);

		$display->success(tr("Payment deleted succssfully"));
	}
}

$display->error($v->errors()->all());


$view = isset($_GET['v'])?$_GET['v']:'index';


switch ($view) {
	case 'new':
		$page=[
			"title"=>tr("New payment vouchers"),
			"active"=>"payment vouchers",
		];

		$page_nav=[
			"back"=>remove_from_url($this_url,["v","i"]),
		
			"breadcrumb"=>[
				tr("Suppliers")=>$app_url."/suppliers",
				tr("Payment voucher")=>$app_url."/suppliers/payment.php",
				tr("New payment vouchers")=>""
			],
		];
		$sup_id = isset($_GET['sup'])?$_GET['sup']:1;
		if (isset($_GET['popup'])) {
			$page_nav['close']=1;
		}


		$import_id = "";
		if (isset($_GET['import'])) {
			$import_id =$_GET['import'];
		}

		$page_view = "views/pnew.php";
	break;

	case 'view':
		
		


		if (isset($_GET['i']) && is_numeric($_GET['i'])) {
			$data=$db->row("SELECT * FROM sup_payment WHERE id = ? ",[$_GET['i']]);

			if (!$data) {
				$redirect->to(404);
			}
		}


		$page=[
			"title"=>tr("payment vouchers")." #".$data['id'],
			"active"=>"payment vouchers",
		];

		$page_nav=[
			"back"=>remove_from_url($this_url,["v","i"]),
			"reload"=>"",
			"breadcrumb"=>[
				tr("Suppliers")=>$app_url."/suppliers",
				tr("Payment vouchers")=>$app_url."/suppliers/payment.php",
				tr("payment vouchers")." #".$data['id']=>""
			],
		];

		if (isset($_GET['popup'])) {
			$page_nav['close']=1;
		}

		$page_view = "views/pview.php";
	break;
	
	default:
		$from = date("d-m-Y",strtotime("-1 year"));
		$to   = date("d-m-Y");



		if (isset($_GET['from'])) {
		  $from = date("d-m-Y",strtotime($_GET['from']));
		}

		if (isset($_GET['to'])) {
		  $to = date("d-m-Y",strtotime($_GET['to']));
		}

	$list = $db->query("SELECT p.*,s.name,s.id AS s_id, 
(
	DATEDIFF(STR_TO_DATE(p.due_date, '%d-%m-%Y' ),STR_TO_DATE(?, '%d-%m-%Y' ))
)
AS r_days
FROM sup_payment p LEFT JOIN suppliers s 
ON p.sup_id = s.id 
WHERE  p.deleted_01=0 AND DATE(STR_TO_DATE(added_on, '%H:%i %d-%m-%Y' ))>= DATE( STR_TO_DATE(?, '%d-%m-%Y' )) AND DATE(STR_TO_DATE(added_on, '%H:%i %d-%m-%Y' ))<= DATE( STR_TO_DATE(?, '%d-%m-%Y' ))",[date("d-m-Y"),$from,$to]);


		$page_nav=[
			"reload"=>1,
			"breadcrumb"=>[
				tr("Suppliers")=>$app_url."/suppliers/",
				tr("Payment voucher")=>$app_url."/suppliers/payment.php",

			],
			"date_filter"=>[
				"from"=>$from,
				"to"=>$to
			]
		
		];

		$page=[
			"title"=>tr("Payment vouchers"),
			"active"=>"payment vouchers",
		];


		$page_view = "views/pindex.php";
	break;
}