<?php 


 ?>
<div class="row" id="new_refund">
	<div class="col">
		<div class="card">
			<div class="card-header d-flex">
				<div class="col">
					<h5><?= tr("New refund") ?></h5>
				</div>
				<div class="col"></div>
			</div>
			<div class="card-body row">
				<div class="col">
					<form action="<?= $this_url ?>" method="post">

						<label  ><?= tr("Invoice No") ?>*</label>
					      <div class="input-group mb-2">
					        <div class="input-group-prepend" @click="get_bill">
					          <div class="input-group-text btn btn-primary" ><i class="fas fa-search"></i></div>
					        </div>
					        <input type="text" class="form-control" name="bill_id" v-model="bill_id"  value="<?= old("bill_id",$bill_id) ?>" placeholder="<?= tr("Invoice No") ?>">
					      </div>
					      <br>
					      <div class="input-group mb-2">
					        <div class="input-group-prepend" @click="get_item">
					          <div class="input-group-text btn btn-primary" ><i class="fas fa-search"></i></div>
					        </div>
					        <input type="text" class="form-control" name="code" v-model="code"  value="<?= old("code") ?>" placeholder="<?= tr("Item code") ?>">
					      </div>


					      <br>

					      <label for=""><?= tr("Qunatity") ?></label>
					      <input type="number" class="form-control  text-center" name="quantity" value="<?= old("quntity",1) ?>"><br>

					      <label for=""><?= tr("Price") ?></label>
					      <input type="number" class="form-control text-center" name="price"  v-model="price" value="<?= old("price") ?>"><br>

						<label for=""><?= tr("Note") ?></label>
						<textarea class="form-control" name="note"><?= old("note") ?></textarea>

						<br>

				

		

						<br>
						<button class="btn btn-primary" name="new_refund"><?= tr("Submit") ?></button>
					</form>
				</div>

				<div class="col">
					<table class="table table-borderless table-sm" v-if="bill_data.customer">
						<tr>
							<th><?= tr("Customer") ?></th>
							<td>{{bill_data.customer}}</td>
						</tr>
						<tr>
							<th><?= tr("Price") ?></th>
							<td>{{bill_data.price}}</td>
						</tr>
						<tr>
							<th><?= tr("Paid") ?></th>
							<td>{{bill_data.paid}}</td>
						</tr>

						<tr>
							<th><?= tr("Created at") ?></th>
							<td>{{bill_data.created_at}}</td>
						</tr>
						<tr>
							<th><?= tr("Created by") ?></th>
							<td>{{bill_data.created_by}}</td>
						</tr>
						<tr>
							<th><?= tr("Details") ?></th>
							<td>
								<ul>
									<li v-for="item in bill_data.items">{{item.name}}</li>
								</ul>
							</td>
						</tr>
					</table>

					<table class="table table-borderless table-sm" v-if="item.name">
						<tr>
							<th><?= tr("Item") ?></th>
							<td>{{item.name}}</td>
						</tr>
						<tr>
							<th><?= tr("Price") ?></th>
							<td>{{item.price}}</td>
						</tr>
					
					</table>

				</div>
				
		
			</div>
			
		</div>
	</div>
	
</div>

<script>
	const new_refund = new Vue({
		el:"#new_refund",
		data:{
			bill_id:'<?= old("bill_id",$bill_id) ?>',
			code:'<?= old("code") ?>',
			price:'<?= old("price") ?>',
			bill_data:[],
			item:[]

		},
		methods:{
			get_bill(){
				let job =this;


				$.post('<?= $app_url ?>/refunds/ajax/', 
				{
					'function': 'get_bill',
					'bill_id': job.bill_id,

				}, 
				function(data, textStatus, xhr) {
					
					data.errors.forEach( function(element, index) {
						notifi(element,'danger')
					});

					job.bill_data=data.data
					job.item=[]
				},'json');
			},
			get_item(){
				let job =this;


				$.post('<?= $app_url ?>/refunds/ajax/', 
				{
					'function': 'get_item',
					'code': job.code,

				}, 
				function(data, textStatus, xhr) {
					
					data.errors.forEach( function(element, index) {
						notifi(element,'danger')
					});
					job.bill_data=[]
					job.item=data.data

				
				},'json');
			}
		}
	})
</script>


		