<div class="card">
				<div class="card-header">
					<div class="row">
						<div class="col-md-6 text-start">
							<h3><?= $lang['pay_vchers'] ?></h3>
						</div>
						<div class="col-md-6 text-end">
							<a href="<?= add_to_url($this_url,"v","new") ?>" class="btn btn-primary rounded-pill"><?= tr("New payment vouchers") ?></a>
						</div>
					</div>
				</div>
				
					<table class="table table-responsive-md mb-0 table-hover" id="datatable-tabletools">
						<thead>
							<tr>
								<th>#</th>
								<th><?= $lang['date'] ?></th>
								<th><?= tr("Created at") ?></th>
								<th><?= tr("Supplier") ?></th>
								<th><?= $lang['amount'] ?></th>
								<!-- <th><?= $lang['for'] ?></th> -->
								<th><?= tr("Payment method") ?></th>
								<th><?= $lang['cheque_date'] ?></th>
								<th><?= $lang['status'] ?></th>
								<th class="text-center"><?= $lang['action'] ?></th>
							</tr>
						</thead>
						<tbody>
							<?php foreach ($list as $key => $item): ?>
								<tr>
									<td><?= $item['id'] ?></td>
									<td><?= $item['p_day'] ?></td>
									<td><?= $item['added_on'] ?></td>
									<td><a href="<?= $app_url ?>/suppliers/?v=view&i=<?= $item['s_id'] ?>"><?= $item['name'] ?></a></td>
									<td><?= amount($item["amount"]) ?></td>
							
									<td><?= $lang[$item["pay_by"]] ?><?= $item["pay_by"]=="cheque"?" [". $item["cheque_no"]."]":'' ?></td>
								

									<?php if ($item["received_01"]): ?>
										<td><?= ($item["pay_by"]=="cheque")?$item["due_date"]:$item["p_day"] ?></td>
										<td><?= '<h5 class="badge badge-success">' .$lang['received']. '</h5>' ?></td>
										<td class="text-center">
											<div class="btn-group btns-action">
												<a href="<?= add_to_url($this_url,["v","i"],["view",$item['id']]) ?>"  title="<?= tr("Edit") ?>"   class="btn btn-sm btn-light border"><i class="far fa-edit"></i></a>
											<button class="btn btn-sm btn-light border" onclick="printPaymentVoucher(<?= $item["id"] ?>)" title="<?= tr("Print") ?>"><i class="fas fa-print"></i></button></div>
										</td>
									<?php else: ?>
										<?php if ($item["r_days"]<4 && $item["r_days"]>=0 && is_numeric($item["r_days"])): ?>
											<td>
												'<span class="text-danger"><?= $item["due_date"] ?> <i class="fas fa-exclamation-circle"></i></span>'
											</td>
											
												<td>	<form method="post">
													<h5 class="badge badge-danger"><?= $lang['not_received'] ?></h5>
															<button title="<?= $lang['received'] ?>" name="received"   class="btn btn-sm btn-light border"><i class="fas fa-check"></i></button>
															<input type="hidden" value="<?= $item['id'] ?>" name="id">
														</form></td>
												<td class="text-center">
													<div class="btn-group btns-action">
													
														<a href="<?= add_to_url($this_url,["v","i"],["view",$item['id']]) ?>"  title="<?= tr("Edit") ?>"   class="btn btn-sm btn-light border"><i class="far fa-edit"></i></a><button class="btn btn-sm btn-light border" onclick="printPaymentVoucher(<?= $item['id'] ?>)" title="<?= tr("Print") ?>"><i class="fas fa-print"></i></button>
													</div>
												</td>
									
										<?php elseif($item["r_days"]<0 && is_numeric($item["r_days"])): ?>
											<td><span class="text-info"><?= $item["due_date"] ?> <i class="fas fa-exclamation-circle"></i></span></td>
										<td>	<form method="post">
													<h5 class="badge badge-danger"><?= $lang['not_received'] ?></h5>
															<button title="<?= $lang['received'] ?>" name="received"   class="btn btn-sm btn-light border"><i class="fas fa-check"></i></button>
															<input type="hidden" value="<?= $item['id'] ?>" name="id">
														</form></td>
											<td>
													<div class="btn-group btns-action">
												
														<a href="<?= add_to_url($this_url,["v","i"],["view",$item['id']]) ?>"  title="<?= tr("Edit") ?>"   class="btn btn-sm btn-light border"><i class="far fa-edit"></i></a>
														<button class="btn btn-sm btn-light border" onclick="printPaymentVoucher(<?= $item['id'] ?>)" title="<?= tr("Print") ?>"><i class="fas fa-print"></i></button>
													</div>
												</td>
										<?php else: ?>
											<td><?= ($item["pay_by"]=="cheque")?$item["due_date"]:'' ?></td>
											<td>
												<h5 class="badge badge-danger"><?= $lang['not_received'] ?></h5>
											</td>
											<td class="text-center">
												<div class="btn-group btns-action">
												<a href="<?= add_to_url($this_url,["v","i"],["view",$item['id']]) ?>"  title="<?= tr("Edit") ?>"   class="btn btn-sm btn-light border"><i class="far fa-edit"></i></a>
											<button class="btn btn-sm btn-light border" onclick="printPaymentVoucher(<?= $item["id"] ?>)" title="<?= tr("Print") ?>"><i class="fas fa-print"></i></button></div>
											</td>
										<?php endif ?>
									<?php endif ?>
								</tr>
							<?php endforeach ?>
						</tbody>
					</table>
			
			</div>

<script>
	$(document).ready(function() {

		var table=''
		$(document).ready(function() {
				var $table = $('#datatable-tabletools');

				 table = $table.dataTable({
				 	
        
			    language: {
		              search: '<span></span> _INPUT_',
		              searchPlaceholder: '<?= tr("Search") ?>',
		              lengthMenu: '<span><?= tr("Show") ?>:</span> _MENU_',
		              paginate: { 'first': '<?= tr("First") ?>', 'last': '<?= tr("Last") ?>', 'next': '<?= tr("Next") ?>', 'previous': '<?= tr("Previous") ?>' }
		          },
    
					"lengthMenu": [
			          [25, 100, 500,1000],
			          [25, 100, 500,1000]
			        ],
			        "order": [[ 0, "desc" ]],
		
					"columnDefs": [
					    { "orderable": false, "targets": [8,1,2,6]},
					 
					],
					// stateSave: true,
			        // processing: true,
			        // serverSide: true,
		
					
					// sDom: '<"text-right mb-md"T><"row"<"col-lg-6"l><"col-lg-6"f>><"table-responsive"t>p',
					dom: '<"datatable-header"fBl><"datatable-scroll-wrap"t><"datatable-footer"ip>',
					responsive: true,
					 autoWidth: false,
					 buttons: {
          dom: {
              button: {
                  className: 'btn btn-light border'
		              }
		          },
		          buttons: [
		    
		         

		          ],
		      },

					
				});

			
				 $('#datatable-tabletools_length').attr({
				 	"dir": 'ltr',
			
				 });;

				 $('<div />').addClass('dt-buttons mb-2 pb-1 text-start').prependTo('#datatable-tabletools_wrapper');



		
				$table.DataTable().buttons().container().prependTo( '#datatable-tabletools_wrapper ' ).addClass('text-right m-2 mx-3');
				


				
			});
	});
</script>
