<?php
	$root=".";
	require($root."/php/init.php");
	$page=[
		"title"=>tr("Track shipment")
	];

	$search = isset($_GET['t'])?$_GET['t']:'';
	$list=[];


	if ($search) {

		

		
		$ship = $db->row("SELECT * FROM shipments WHERE code = ?  AND (date(delivered_at)>=date(?) OR delivered_at ='0000-00-00' OR delivered_at Is null)  ",[$search,date("Y-m-d",strtotime("-2 days"))]);

		if ($ship) {
			$list[]=$ship;
		}
		


		
	}

	
?>
<!DOCTYPE html>
<html lang="en">
	<?php require($root."/inc/head.php") ?>
	<style>
		.dot:before {
			  content: "";
			  width: 15px;
			  height: 15px;
			  background: #ACACAC;
			  /*border: 1px solid #454545;*/
			
			  border-radius: 50%;
			  position: absolute;
			  left: -10px;
			  top: 30px;
			}
			.line:before {
			  content: "";
			  
			  height: 100px;
			  background: #ACACAC;
			  border: 1px solid #454545;
			
			
			  position: absolute;
			  left: -3px;
			  top: -10px;
			}
		
	</style>
	<body>
		<div class="container pt-3">
			<div class="row justify-content-center">
				<div class="col-md-12">
					<div class="jumbotron shadow text-center" style="background: url(assets/images/map.jpg);">
						<p><img height="200px" src="assets/images/logot.png" alt=""></p>
						<h1 class="display-4">Track Shipments</h1>
						<p class="lead"></p>
						<hr class="my-4">
						<form method="get" class="no_csrf" action="<?= $app_url ?>/tracking.php">
							<div class="d-flex justify-content-center">
								<input type="text" style="width: 400px;" value="<?= escap($search) ?>" placeholder="<?= tr("Enter shipment numbers") ?>" class="form-control text-center" name="t" required>
							</div>
							<br>
							<button class="btn btn-primary btn-lg" href="#" role="button"><?= tr("Track") ?></button>
						</form>
					</div>
				</div>
				<?php if (count($list)): ?>
				<div class="col-md-12">
					<div class="" id="accordion-control">
						<?php $n=0; foreach ($list as $key => $item): ?>
						<div class="card rounded shadow">
							<div class="card-header">
								<h6 class="card-title">
								<a data-toggle="collapse" class="text-default collapsed" href="#shipments-<?= $item['code'] ?>" aria-expanded="<?= $n==0?'true':'' ?>">
									<div class="d-flex justify-content-between">
										<strong><h3>#<?= $item['code'] ?></h3></strong>
										<div class="pt-2">
											<!-- <h5 class="badge rounded-pill badge-<?= $item['status']=="Draft"?"dark":($item['status']=="Processing"?'danger':'success') ?>"><?= tr($item['status']) ?></h5> -->
										</div>
									</div>
								</a>
								</h6>
							</div>
							<div id="shipments-<?= $item['code'] ?>" class="collapse <?= $n++==0?'show':'' ?>" data-parent="#accordion-control" style="">
								<div class="card-body">
									<div class="row">
										<div class="col-md-6">
											<div class="d-flex justify-content-between">
										<div class="col-md-6 px-1 ">
											<div class="card card-body shadow border-left-danger rounded-0 h-100 m-0" style="border-left:3px solid #F11E1E;">
												
												<?= $item['origin'] ?>
											</div>
										</div>
										<div class="col-md-6 px-1">
											<div class="card card-body shadow border-left-danger rounded-0 h-100 m-0" style="border-left:3px solid #363636;">
												
												<?= $item['destination'] ?>
											</div>
										</div>
									</div>
									<br>
									<?php if (strtotime($item['received_date'])>0): ?>
										
									<h5 for=""><?= tr("Received date") ?> <br><?= $item['received_date'] ?></h5>
								<br>
								<?php endif ?>
					

									<?php if (strtotime($item['expected_departure_date'])>0): ?>
										<h5><?= tr("Expected departure date") ?><br>
											<?= date("d D M m Y",strtotime($item['expected_departure_date'])) ?>
										</h5>
										<br>
									<?php endif ?>
									<?php if (strtotime($item['departure_date'])>0): ?>
										<h5><?= tr("Departure date") ?><br>
											<?= date("d D M m Y",strtotime($item['departure_date'])) ?>
										</h5>
										<br>
									<?php endif ?>
									<?php if (strtotime($item['estimated_delivery'])>0): ?>
										<h5><?= tr("Estimated delivery date") ?><br>
											<?= date("d D M m Y",strtotime($item['estimated_delivery'])) ?>
										</h5>
										<br>
									<?php endif ?>
									<?php if (strtotime($item['delivered_at'])>0): ?>
										<h5><?= tr("Delivery at") ?><br>
											<?= date("d D M m Y",strtotime($item['delivered_at'])) ?>
										</h5>
										<br>
									<?php endif ?>
									<!-- <table class="table table-borderless table-sm">
										<?php
										$logs = $db->query("SELECT s.*, l.name FROM shipment_logs s left join logs l on l.id=s.log_id WHERE s.deleted_01=0 AND s.shipment_id=? ORDER by s.id DESC",[$item['id']]) 
										 ?>
										<?php $m=1; foreach  ($logs as $key => $log): ?>
											<tr style="position: relative;">
												
												<td class="<?= ($m==1 || $m==count($logs))?'dot':'line' ?> <?= ($m==1 )?'font-weight-bold':'' ?>" >
													<?= $log['name'] ?><br>
													<span class="text-muted"><i><small><?= $log['created_at'] ?></small></i>	
												</td>

											</tr>
										<?php $m++; endforeach ?>
									</table> -->
										</div>
										<?php 
										$itmes = $db->query("SELECT * FROM shipment_data WHERE shipment_id=?",[$item['id']]);
										 ?>
										<?php if (count($itmes)): ?>
											<div class="col-md-6 card shadow">
											<table class="table table-sm">
												<tr>
													<td><?= tr("Item") ?></td>
													<td><?= tr("Supplier") ?></td>
													<td><?= tr("Quantity") ?></td>
												</tr>
												<tbody>
													
														<?php foreach ($itmes as $key => $item2): ?>
															<tr>
														<td><?= $item2['name'] ?></td>
														<td><?= $db->single("SELECT name FROM suppliers WHERE id = ? ",[$item2['supplier_id']]) ?></td>
														<td><?= $item2['quantity'] ?></td>
														</tr>
													<?php endforeach ?>
													
												</tbody>
											</table>
											
										</div>
										<?php endif ?>
									</div>
								</div>

							</div>
						</div>
						<?php endforeach ?>
						
					</div>
				</div>
				<?php endif ?>
			</div>
			
			
		</div>
		
		
		
	</body>
</html>