<?php 
use Classes\Hash;
$v = new Classes\Validator;


if (isset($_POST['toggle']) && $tk->passes()) {
	$id = isset($_POST['id'])?$_POST['id']:'';
	$status = isset($_POST['status'])?$_POST['status']:"0";
	$v->validate([
		"id"=>[$_POST['id'],"required"],

	]);	

	if ($v->passes() ) {
		$db->query("UPDATE users SET active_01 = ? WHERE id = ?",[$status, $id]);

		$display->success("Status updated successfully.");
	}
}


if (isset($_POST['update_user']) && $tk->passes()) {
	$user_id   =isset($_POST['id'])?$_POST['id']:'';
	$name      =isset($_POST['name'])?$_POST['name']:'';
	$phone     =isset($_POST['phone'])?$_POST['phone']:'';
	$email     =isset($_POST['email'])?$_POST['email']:'';
	$log_name     =isset($_POST['log_name'])?$_POST['log_name']:'';
	
	$password  =isset($_POST['password'])?$_POST['password']:'';

	$role_id   =isset($_POST['role_id'])?$_POST['role_id']:'';
	$branch_id   =isset($_POST['branch_id'])?$_POST['branch_id']:'';
	$status   =isset($_POST['status'])?$_POST['status']:'Inactive';


	$v->validate([
		"ID"          =>[$user_id,"required|in_table(users,id)"],
		tr("Name")           =>[$name,"required"],
		tr("phone")          =>[$phone,"required|number|unique_phone(users,phone,$user_id)"],
		tr("Email")          =>[$email,"required|unique_email(users,email,$user_id)"],
	
		tr("Role")           =>[$role_id,"required|in_table(roles,id)"],
		tr("log_name")       =>[$log_name,"required|unique_table(users,log_name,$user_id)"],
		tr("Warehouse")           =>[$branch_id,"required|in_table(branches,id)"],

		// tr("birth")           =>[$birth,"required"],
		// tr("county")           =>[$country,"required"],
		// tr("card_id")           =>[$card_id,"required|unique_table(users,card_id,$user_id)"],
	]);




	if ($v->passes() ) {

		// $current_status = $db->single("SELECT status FROM users WHERE id = ? ",[$user_id]);

		// if ($current_status=="Inactive" && $status=="Active") {
		// 	$db->query("UPDATE users SET status_date=? WHERE id = ? ",[date("Y-m-d"),$user_id]);
		// }

		// $log_name  =$email;

		$db->query(
		"UPDATE users SET name=?,log_name=?,phone=?,email=?, role_id=?,branch_id=?,updated_by=?,updated_at=? WHERE id=?",
		[ $name,$log_name,$phone,$email, $role_id,$branch_id,auth()->id,timestamp(),$user_id ]
				);

	
		
		$display->success(tr("User updated successfully."));
	}

}

if (isset($_POST['update_password']) && $tk->passes()) {
	$user_id   =isset($_POST['id'])?$_POST['id']:'';
	$password  =isset($_POST['password'])?$_POST['password']:'';
	$cpassword =isset($_POST['cpassword'])?$_POST['cpassword']:'';
	$v->validate([
				"ID"          =>[$user_id,"required|in_table(users,id)"],
				tr("password")       =>[$password,"required"],
				tr("Password again") =>[$cpassword,"required|matches(".tr("password").")"],

			]);

	if ($v->passes()) {
		$db->query(
				"UPDATE users SET password=? WHERE id=?",
				[ Hash::password($password),$user_id ]
			);

		$display->success(tr("password updated successfully."));
	}
}

if (isset($_POST['new_user']) && $tk->passes()) {

	$name      =isset($_POST['name'])?$_POST['name']:'';
	$phone     =isset($_POST['phone'])?$_POST['phone']:'';
	
	$password  =isset($_POST['password'])?$_POST['password']:'';
	$cpassword =isset($_POST['cpassword'])?$_POST['cpassword']:'';
	$role_id   =isset($_POST['role_id'])?$_POST['role_id']:'';
	$branch_id   =isset($_POST['branch_id'])?$_POST['branch_id']:'';

	$email     =isset($_POST['email'])?$_POST['email']:'';
	$log_name     =isset($_POST['log_name'])?$_POST['log_name']:'';

	$status   =isset($_POST['status'])?$_POST['status']:'Inactive';

	$v->validate([
		tr("Name")           =>[$name,"required"],
		tr("phone")          =>[$phone,"required|unique_phone(users,phone)"],
		tr("Email")          =>[$email,"required|unique_email(users,email)"],
		tr("password")       =>[$password,"required"],
		tr("Password again") =>[$cpassword,"required|matches(".tr("password").")"],
		tr("Role")           =>[$role_id,"required|in_table(roles,id)"],
		tr("log_name")       =>[$log_name,"required|unique_logname(users,log_name)"],
		tr("Warehouse")           =>[$branch_id,"required|in_table(branches,id)"],
	]);



	

	if ($v->passes() ) {

		// $log_name=$email;

		$db->query(
			"INSERT INTO users(name,log_name,phone, email,role_id,branch_id,password,created_by) VALUES (?,?,?,?,?,?,?,?)",
			[$name,$log_name,$phone, $email,$role_id,$branch_id,Hash::password($password),auth()->id]
		);

		$display->success(tr("User added successfully."));
		$redirect->to(remove_from_url($this_url,["v"]));
		
	}
			
}







$display->error($v->errors()->all());


$view = isset($_GET['v'])?$_GET['v']:'index';


switch ($view) {
	case 'new':
		$page_nav=[
			"back"=>$app_url."/users",
			"breadcrumb"=>[
				tr("Users")=>$app_url."/users",
				tr("New")=>"",
			],
		];
		$roles = $db->query("SELECT * FROM roles");
		$page_view = "views/new.php";
	break;

	case 'edit':
		


		if (isset($_GET['i']) && is_numeric($_GET['i'])) {
			$data = $db->row("SELECT * FROM users WHERE id = ? ",[$_GET['i']]);

			if (!$data) {
				$redirect->to(404);
			}
		}
		$balance = 0;


		$page_nav=[
			"back"=>$app_url."/users",
			"breadcrumb"=>[
				tr("Users")=>$app_url."/users",
				$data['name']=>"",
			],
		];
		$page['class']=" sidebar-xs";

		$roles = $db->query("SELECT * FROM roles");

		$tab="";

		if (isset($_GET['tab'])) {
			$tab=$_GET['tab'];
		}

		switch ($tab) {
			case 'settings':
				$tab=__DIR__. DIRECTORY_SEPARATOR."views".DIRECTORY_SEPARATOR."view.tabs". DIRECTORY_SEPARATOR . "settings.php";
			break;
	

			// case 'profile':
			// 	$tab=__DIR__. DIRECTORY_SEPARATOR."views".DIRECTORY_SEPARATOR."view.tabs". DIRECTORY_SEPARATOR . "profile.php";
			// break;
			
			default:
				$tab=__DIR__. DIRECTORY_SEPARATOR."views".DIRECTORY_SEPARATOR."view.tabs". DIRECTORY_SEPARATOR . "settings.php";
				break;
		}



		$page_view = "views/view.php";
	break;
	
	default:
		$page_nav=[
			"reload"=>1,
			"breadcrumb"=>[
				tr("Users")=>$app_url."/users",
			],
		];

		$users_list = $db->query("SELECT u.*,(SELECT created_at FROM user_activities WHERE user_id=u.id ORDER BY id DESC LIMIT 1) as last_active FROM users u WHERE u.deleted_01=0");

		$page_view = "views/index.php";
	break;
}