<style>
	.dataTables_info{
		display: none;
	}
</style>
<div class="row">
	
	<div class="col">
		<div class="card shadow">
			<div class="card-header d-flex justify-content-between bg-primary">
				<h3><?= tr("Balance") ?></h3>
				<h2 dir="ltr"> <span class="badge badge-<?= $balance>0?'danger':'success' ?> rounded-pill px-3" style="border:solid white 3px;"> <?= amount($balance) ?></span></h2>
			</div>
			<div class="card-body">
				<div class="row px-0 mx-0">
					<div class="col-lg-6">
						<!-- bills card -->
						<div class="card shadow">
							<div class="card-header bg-danger d-flex justify-content-between">
								<h5><?= tr("Bills") ?></h5>
								<button type="button" data-toggle="modal" data-target="#new-bill-modal" class="btn btn-light rounded-pill"><?= tr("New") ?></button>
							</div>
							<table class="table table-sm  datatable-semple table-hover" >
								<thead style="display: none;">
									<tr>
										<td></td>
										<td></td>
										<td></td>
									</tr>
								</thead>
								<tbody>
									<?php foreach ($db->query("SELECT * FROM bills WHERE user_id = ? AND deleted_01=0 ORDER BY id DESC LIMIT 50",[$data['id']]) as $key => $bill): ?>
									<tr>
										<th dir="ltr"><?= datef($bill['date_time']) ?></th>
										<th><?= amount($bill['amount']) ?></th>
										<th class="text-center">
											<button class="btn btn-light" onclick="app.get_bill(<?= $bill['id'] ?>)"><?= tr("View") ?></button>
										</th>
									</tr>

							
									<?php endforeach ?>
								</tbody>
							</table>
						</div>
						
					</div>

					<div class="col-lg-6">
						<!-- payment card -->
						<div class="card shadow">
							<div class="card-header bg-success d-flex justify-content-between">
								<h5><?= tr("Payments") ?></h5>
								<button type="button" data-toggle="modal" data-target="#new-payment-modal" class="btn btn-light rounded-pill"><?= tr("New") ?></button>
							</div>
							<table class="table table-sm  datatable-semple" >
								<thead style="display: none;">
									<tr>
										<td></td>
										<td></td>
										<td></td>
									</tr>
								</thead>
								<tbody>
									<?php $total_pay=0; foreach ($db->query("SELECT * FROM payments WHERE user_id = ? AND deleted_01=0 and payment_type='bill' ORDER BY id DESC LIMIT 50",[$data['id']]) as $key => $payment): ?>
								<tr>
									<th dir="ltr"><?= datef($payment['created_at']) ?></th>
									<th><?= amount($payment['amount']) ?></th>
									<th class="text-center">
										<button class="btn btn-light"  onclick="app.get_payment(<?= $payment['id'] ?>)"><?= tr("View") ?></button>
									</th>
								</tr>
								<?php $total_pay+=$payment['amount']; endforeach ?>
								</tbody>
								
							</table>
							
						</div>
						
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<!-- new bill modal -->
<form method="post">
	<div class="modal fade" id="new-bill-modal" tabindex="-1" role="dialog" aria-labelledby="new-bill-modalLabel" aria-hidden="true">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header bg-danger">
					<h5 class="modal-title" id="new-bill-modalLabel"><?= tr("New bill") ?></h5>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true"><i class="fas fa-times"></i></span>
					</button>
				</div>
				<div class="modal-body">

					<label for=""><?= tr("Date") ?></label>
					<input type="date" name="date_time" class="form-control" required value="<?= date("Y-m-d") ?>"><br>

					<label for=""><?= tr("Group") ?></label>
					<select name="group_id" class="form-control">
						<?php foreach ($db->query("SELECT * FROM groups WHERE deleted_01=0") as $key => $group): ?>
							<option <?= old("group_id",$data['group_id'])==$group['id']?'selected':'' ?> value="<?= $group['id'] ?>"><?= $group['name'] ?></option>
						<?php endforeach ?>
					</select><br>



				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary rounded-pill" data-dismiss="modal"><?= tr("Cancel") ?></button>
					<button name="new_bill" class="btn btn-primary rounded-pill"><?= tr("Submit") ?></button>
				</div>
			</div>
		</div>
	</div>

	<input type="hidden" name="user_id" value="<?= $data['id'] ?>">
</form>


<!-- new payment modal -->
<form method="post">
	<div class="modal fade" id="new-payment-modal" tabindex="-1" role="dialog" aria-labelledby="new-payment-modalLabel" aria-hidden="true">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header bg-success">
					<h5 class="modal-title" id="new-payment-modalLabel"><?= tr("New payment") ?></h5>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true"><i class="fas fa-times"></i></span>
					</button>
				</div>
				<div class="modal-body">

					<label for=""><?= tr("Amount") ?></label>
					<input type="number" required min="0" step="0.001" name="amount" class="form-control"><br>

					<label for=""><?= tr("Payment method") ?></label>
					<select name="payment_method" class="form-control">
						<?php foreach ($payment_methods as $key => $method): ?>
							<option  value="<?= $method ?>"><?= tr($method) ?></option>
						<?php endforeach ?>
					</select><br>



				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary rounded-pill" data-dismiss="modal"><?= tr("Cancel") ?></button>
					<button name="new_payment" class="btn btn-primary rounded-pill"><?= tr("Submit") ?></button>
				</div>
			</div>
		</div>
	</div>

	<input type="hidden" name="user_id" value="<?= $data['id'] ?>">
</form>

<div id="vue">
	
	<div class="modal fade" id="view-payment-modal" tabindex="-1" role="dialog" aria-labelledby="view-payment-modalLabel" aria-hidden="true">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header bg-success">
					<h5 class="modal-title" id="view-payment-modalLabel"><?= tr("Payment") ?></h5>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true"><i class="fas fa-times"></i></span>
					</button>
				</div>
				<table class="table table-striped" v-if="payment">
					<tr>
						<th><?= tr("No.") ?></th>
						<th>{{payment.id}}</th>
					</tr>

				
					<tr>
						<th><?= tr("Amount") ?></th>
						<th dir="ltr">{{payment.amount}}</th>
					</tr>

					<tr>
						<th><?= tr("Payment method") ?></th>
						<th>{{payment.payment_method}}</th>
					</tr>

					<tr>
						<th><?= tr("Created at") ?></th>
						<th>{{payment.created_at}}</th>
					</tr>

					<tr>
						<th><?= tr("Created by") ?></th>
						<th>{{payment.created_by}}</th>
					</tr>

					<tr v-if="payment.updated_by">
						<th><?= tr("Updated at") ?></th>
						<th>{{payment.updated_at}}</th>
					</tr>

					<tr v-if="payment.updated_by">
						<th><?= tr("Updated by") ?></th>
						<th>{{payment.updated_by}}</th>
					</tr>

				</table>
				<div class="modal-footer d-flex justify-content-between pt-2">
				
					<button type="button" @click="$('#delete-payment-id').val(payment.id)" data-toggle="modal" data-target="#delete-payment-modal" class="btn btn-danger rounded-pill"><i class="fas fa-trash-alt mx-1"></i> <?= tr("Delete") ?></button>
				</div>
			</div>
		</div>
	</div>

	<div class="modal fade" id="view-bill-modal" tabindex="-1" role="dialog" aria-labelledby="view-bill-modalLabel" aria-hidden="true">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header bg-danger">
					<h5 class="modal-title" id="view-bill-modalLabel"><?= tr("Bill") ?></h5>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true"><i class="fas fa-times"></i></span>
					</button>
				</div>
				<table class="table table-striped" v-if="bill">
					<tr>
						<th><?= tr("No.") ?></th>
						<th>{{bill.id}}</th>
					</tr>

					<tr>
						<th><?= tr("Date") ?></th>
						<th dir="ltr">{{bill.date_time}}</th>
					</tr>

					<tr>
						<th><?= tr("Amount") ?></th>
						<th dir="ltr">{{bill.amount}}</th>
					</tr>

					<tr>
						<th><?= tr("Group") ?></th>
						<th>{{bill.group}}</th>
					</tr>

					<tr>
						<th><?= tr("Created at") ?></th>
						<th>{{bill.created_at}}</th>
					</tr>

					<tr>
						<th><?= tr("Created by") ?></th>
						<th>{{bill.created_by}}</th>
					</tr>

					<tr v-if="bill.updated_by">
						<th><?= tr("Updated at") ?></th>
						<th>{{bill.updated_at}}</th>
					</tr>

					<tr v-if="bill.updated_by">
						<th><?= tr("Updated by") ?></th>
						<th>{{bill.updated_by}}</th>
					</tr>



				</table>
				<div class="modal-footer d-flex justify-content-between pt-2">
				
					<button type="button" @click="$('#delete-bill-id').val(bill.id)" data-toggle="modal" data-target="#delete-bill-modal" class="btn btn-danger rounded-pill"><i class="fas fa-trash-alt mx-1"></i> <?= tr("Delete") ?></button>
				</div>
			</div>
		</div>
	</div>
</div>

<form method="post">
	
	<div class="modal fade" id="delete-bill-modal" tabindex="-1" role="dialog" aria-labelledby="delete-bill-modalLabel" aria-hidden="true">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header bg-danger">
					<h5 class="modal-title" id="delete-bill-modalLabel"><?= tr("Are you sure?") ?></h5>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true"><i class="fas fa-times"></i></span>
					</button>
				</div>
				<div class="modal-body">
					<p><?= tr("This bill will be deleted.") ?></p>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary " data-dismiss="modal"><?= tr("Cancel") ?></button>
					<button name="delete_bill" class="btn btn-danger "> <?= tr("Yes") ?></button>
				</div>
			</div>
		</div>
	</div>
	<input type="hidden" name="id" id="delete-bill-id" value="0">
</form>

<form method="post">
	
	<div class="modal fade" id="delete-payment-modal" tabindex="-1" role="dialog" aria-labelledby="delete-payment-modalLabel" aria-hidden="true">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header bg-danger">
					<h5 class="modal-title" id="delete-payment-modalLabel"><?= tr("Are you sure?") ?></h5>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true"><i class="fas fa-times"></i></span>
					</button>
				</div>
				<div class="modal-body">
					<p><?= tr("This payment will be deleted.") ?></p>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary " data-dismiss="modal"><?= tr("Cancel") ?></button>
					<button name="delete_payment" class="btn btn-danger "> <?= tr("Yes") ?></button>
				</div>
			</div>
		</div>
	</div>
	<input type="hidden" name="id" id="delete-payment-id" value="0">
</form>

<script>
	let app = new Vue({
		el:"#vue",
		data:{
			payment:false,
			bill:false
		},
		methods:{
			get_bill(id){
			 let job= this;
				$.get('<?= $app_url ?>/users/ajax/user.php?function=get_bill&id='+id, function(data) {
					job.bill=data;
					$("#view-bill-modal").modal("show");
				},'json');
			},
			get_payment(id){
			 let job= this;
				$.get('<?= $app_url ?>/users/ajax/user.php?function=get_payment&id='+id, function(data) {
					job.payment=data;
					$("#view-payment-modal").modal("show");
				},'json');
			}
		}
	})
</script>

<script>
		$(document).ready(function() {

		var table=''
		$(document).ready(function() {
				var $table = $('.datatable-semple');

				 table = $table.dataTable({
				 	
        
			    language: {
		              paginate: { 'first': '<?= tr("First") ?>', 'last': '<?= tr("Last") ?>', 'next': '<?= tr("Next") ?>', 'previous': '<?= tr("Previous") ?>' }
		          },
    
					"lengthMenu": [
			          [7],
			          [7]
			        ],

		
					"ordering": false,
					"searching": false,
					"bLengthChange": false,
					responsive: true,
					 autoWidth: false,
					
				});

			});
	
	});
</script>