<?php

namespace Violin\Rules;

use Violin\Contracts\RuleContract;

class LatlngRule implements RuleContract
{
    public function run($value, $input, $args)
    {
        return (bool) preg_match('/^[-]?(([0-8]?[0-9])\.(\d+))|(90(\.0+)?);[-]?((((1[0-7][0-9])|([0-9]?[0-9]))\.(\d+))|180(\.0+)?)$/',$value);
    }

    public function error()
    {
        return '{field} '.tr('was not in the correct format.');
    }

    public function canSkip()
    {
        return true;
    }
}
